@extends('layouts.modern')

@section('title', 'تفاصيل المهمة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تفاصيل المهمة: {{ $task->title }}</h3>
                    <div>
                        <a href="{{ route('hrm.tasks.edit', $task->id) }}" class="btn btn-primary me-2">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <!-- معلومات المهمة -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">معلومات المهمة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">العنوان</th>
                                            <td>{{ $task->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($task->status == 'pending')
                                                    <span class="badge bg-secondary">قيد الانتظار</span>
                                                @elseif($task->status == 'in_progress')
                                                    <span class="badge bg-primary">قيد التنفيذ</span>
                                                @elseif($task->status == 'completed')
                                                    <span class="badge bg-success">مكتملة</span>
                                                @elseif($task->status == 'cancelled')
                                                    <span class="badge bg-danger">ملغاة</span>
                                                @elseif($task->status == 'on_hold')
                                                    <span class="badge bg-warning">معلقة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الأولوية</th>
                                            <td>
                                                @if($task->priority == 'low')
                                                    <span class="badge bg-success">منخفضة</span>
                                                @elseif($task->priority == 'medium')
                                                    <span class="badge bg-info">متوسطة</span>
                                                @elseif($task->priority == 'high')
                                                    <span class="badge bg-warning">عالية</span>
                                                @elseif($task->priority == 'urgent')
                                                    <span class="badge bg-danger">عاجلة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البدء</th>
                                            <td>{{ $task->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاستحقاق</th>
                                            <td>
                                                @if($task->is_overdue && $task->status != 'completed')
                                                    <span class="text-danger fw-bold">{{ $task->due_date->format('Y-m-d') }} (متأخرة)</span>
                                                @else
                                                    {{ $task->due_date->format('Y-m-d') }}
                                                @endif
                                            </td>
                                        </tr>
                                        @if($task->completed_date)
                                        <tr>
                                            <th>تاريخ الإكمال</th>
                                            <td>{{ $task->completed_date->format('Y-m-d') }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>تم إنشاؤها بواسطة</th>
                                            <td>{{ $task->creator->name ?? 'غير معروف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم تكليفها بواسطة</th>
                                            <td>{{ $task->assigner->name ?? 'غير معروف' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="card mb-4">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">وصف المهمة</h5>
                                </div>
                                <div class="card-body">
                                    <p>{!! nl2br(e($task->description)) !!}</p>
                                </div>
                            </div>

                            @if($task->notes)
                            <div class="card mb-4">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    <p>{!! nl2br(e($task->notes)) !!}</p>
                                </div>
                            </div>
                            @endif
                        </div>

                        <!-- الموظفين المكلفين والمرفقات والتعليقات -->
                        <div class="col-md-6">
                            <!-- الموظفين المكلفين -->
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">الموظفين المكلفين</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>الموظف</th>
                                                    <th>الحالة</th>
                                                    <th>التقدم</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($task->assignees as $assignee)
                                                <tr>
                                                    <td>{{ $assignee->employee->full_name }}</td>
                                                    <td>
                                                        @if($assignee->status == 'pending')
                                                            <span class="badge bg-secondary">قيد الانتظار</span>
                                                        @elseif($assignee->status == 'in_progress')
                                                            <span class="badge bg-primary">قيد التنفيذ</span>
                                                        @elseif($assignee->status == 'completed')
                                                            <span class="badge bg-success">مكتملة</span>
                                                        @elseif($assignee->status == 'declined')
                                                            <span class="badge bg-danger">مرفوضة</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="progress">
                                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $assignee->progress }}%;" aria-valuenow="{{ $assignee->progress }}" aria-valuemin="0" aria-valuemax="100">{{ $assignee->progress }}%</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#updateAssigneeModal{{ $assignee->id }}">
                                                            <i class="fas fa-edit"></i> تحديث
                                                        </button>

                                                        <!-- Modal for Update Assignee Status -->
                                                        <div class="modal fade" id="updateAssigneeModal{{ $assignee->id }}" tabindex="-1" aria-labelledby="updateAssigneeModalLabel{{ $assignee->id }}" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="updateAssigneeModalLabel{{ $assignee->id }}">تحديث حالة المهمة للموظف: {{ $assignee->employee->full_name }}</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <form action="{{ route('hrm.tasks.assignees.update', ['id' => $task->id, 'assigneeId' => $assignee->id]) }}" method="POST">
                                                                        @csrf
                                                                        @method('PUT')
                                                                        <div class="modal-body">
                                                                            <div class="form-group mb-3">
                                                                                <label for="status{{ $assignee->id }}" class="form-label">الحالة</label>
                                                                                <select class="form-select" id="status{{ $assignee->id }}" name="status">
                                                                                    <option value="pending" {{ $assignee->status == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                                                                    <option value="in_progress" {{ $assignee->status == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                                                                    <option value="completed" {{ $assignee->status == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                                                                    <option value="declined" {{ $assignee->status == 'declined' ? 'selected' : '' }}>مرفوضة</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="progress{{ $assignee->id }}" class="form-label">نسبة التقدم (%)</label>
                                                                                <input type="number" class="form-control" id="progress{{ $assignee->id }}" name="progress" min="0" max="100" value="{{ $assignee->progress }}">
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="notes{{ $assignee->id }}" class="form-label">ملاحظات</label>
                                                                                <textarea class="form-control" id="notes{{ $assignee->id }}" name="notes" rows="3">{{ $assignee->notes }}</textarea>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- المرفقات -->
                            <div class="card mb-4">
                                <div class="card-header bg-warning text-dark d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">المرفقات</h5>
                                    <button type="button" class="btn btn-sm btn-dark" data-bs-toggle="modal" data-bs-target="#addAttachmentModal">
                                        <i class="fas fa-plus"></i> إضافة مرفق
                                    </button>
                                </div>
                                <div class="card-body">
                                    @if($task->attachments->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>اسم الملف</th>
                                                    <th>الوصف</th>
                                                    <th>تم الرفع بواسطة</th>
                                                    <th>تاريخ الرفع</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($task->attachments as $attachment)
                                                <tr>
                                                    <td>{{ $attachment->file_name }}</td>
                                                    <td>{{ $attachment->description ?: 'لا يوجد وصف' }}</td>
                                                    <td>{{ $attachment->user->name ?? 'غير معروف' }}</td>
                                                    <td>{{ $attachment->created_at->format('Y-m-d H:i') }}</td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="{{ route('hrm.tasks.attachments.download', ['id' => $task->id, 'attachmentId' => $attachment->id]) }}" class="btn btn-sm btn-success">
                                                                <i class="fas fa-download"></i>
                                                            </a>
                                                            @if(Auth::id() == $attachment->user_id || Auth::user()->hasRole('admin'))
                                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteAttachmentModal{{ $attachment->id }}">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                            @endif
                                                        </div>

                                                        <!-- Modal for Delete Attachment Confirmation -->
                                                        <div class="modal fade" id="deleteAttachmentModal{{ $attachment->id }}" tabindex="-1" aria-labelledby="deleteAttachmentModalLabel{{ $attachment->id }}" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="deleteAttachmentModalLabel{{ $attachment->id }}">تأكيد حذف المرفق</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        هل أنت متأكد من رغبتك في حذف المرفق "{{ $attachment->file_name }}"؟
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                        <form action="{{ route('hrm.tasks.attachments.delete', ['id' => $task->id, 'attachmentId' => $attachment->id]) }}" method="POST">
                                                                            @csrf
                                                                            @method('DELETE')
                                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @else
                                    <p class="text-center">لا توجد مرفقات</p>
                                    @endif
                                </div>
                            </div>

                            <!-- Modal for Add Attachment -->
                            <div class="modal fade" id="addAttachmentModal" tabindex="-1" aria-labelledby="addAttachmentModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="addAttachmentModalLabel">إضافة مرفق جديد</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <form action="{{ route('hrm.tasks.attachments.add', $task->id) }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="modal-body">
                                                <div class="form-group mb-3">
                                                    <label for="file" class="form-label">الملف <span class="text-danger">*</span></label>
                                                    <input type="file" class="form-control" id="file" name="file" required>
                                                    <small class="form-text text-muted">الحد الأقصى للملف: 10 ميجابايت</small>
                                                </div>
                                                <div class="form-group mb-3">
                                                    <label for="description" class="form-label">الوصف</label>
                                                    <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                <button type="submit" class="btn btn-primary">رفع الملف</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- التعليقات -->
                    <div class="card mt-4">
                        <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">التعليقات</h5>
                        </div>
                        <div class="card-body">
                            <!-- نموذج إضافة تعليق -->
                            <form action="{{ route('hrm.tasks.comments.add', $task->id) }}" method="POST" class="mb-4">
                                @csrf
                                <div class="form-group mb-3">
                                    <label for="comment" class="form-label">إضافة تعليق</label>
                                    <textarea class="form-control" id="comment" name="comment" rows="3" required></textarea>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-paper-plane"></i> إرسال
                                    </button>
                                </div>
                            </form>

                            <!-- قائمة التعليقات -->
                            <div class="comments-list">
                                @if($task->comments->count() > 0)
                                    @foreach($task->comments as $comment)
                                        <div class="card mb-3">
                                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                                <div>
                                                    <strong>{{ $comment->user->name ?? 'غير معروف' }}</strong>
                                                    <small class="text-muted">{{ $comment->created_at->format('Y-m-d H:i') }}</small>
                                                </div>
                                                @if(Auth::id() == $comment->user_id || Auth::user()->hasRole('admin'))
                                                    <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteCommentModal{{ $comment->id }}">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                @endif
                                            </div>
                                            <div class="card-body">
                                                <p class="card-text">{!! nl2br(e($comment->comment)) !!}</p>
                                            </div>
                                        </div>

                                        <!-- Modal for Delete Comment Confirmation -->
                                        <div class="modal fade" id="deleteCommentModal{{ $comment->id }}" tabindex="-1" aria-labelledby="deleteCommentModalLabel{{ $comment->id }}" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteCommentModalLabel{{ $comment->id }}">تأكيد حذف التعليق</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        هل أنت متأكد من رغبتك في حذف هذا التعليق؟
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                        <form action="{{ route('hrm.tasks.comments.delete', ['id' => $task->id, 'commentId' => $comment->id]) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <p class="text-center">لا توجد تعليقات</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection