@extends('layouts.modern')

@section('title', 'المهام المتأخرة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">المهام المتأخرة</h3>
                    <div>
                        <a href="{{ route('hrm.tasks.upcoming') }}" class="btn btn-warning me-2">
                            <i class="fas fa-clock"></i> المهام القادمة
                        </a>
                        <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i> هذه المهام تجاوزت تاريخ الاستحقاق ولم يتم إكمالها بعد.
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الموظفين المكلفين</th>
                                    <th>الأولوية</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>التأخير</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($overdueTasks as $task)
                                    <tr>
                                        <td>{{ $loop->iteration + ($overdueTasks->currentPage() - 1) * $overdueTasks->perPage() }}</td>
                                        <td>{{ $task->title }}</td>
                                        <td>
                                            @foreach($task->assignees as $assignee)
                                                <span class="badge bg-info">{{ $assignee->employee->full_name }}</span>
                                            @endforeach
                                        </td>
                                        <td>
                                            @if($task->priority == 'low')
                                                <span class="badge bg-success">منخفضة</span>
                                            @elseif($task->priority == 'medium')
                                                <span class="badge bg-info">متوسطة</span>
                                            @elseif($task->priority == 'high')
                                                <span class="badge bg-warning">عالية</span>
                                            @elseif($task->priority == 'urgent')
                                                <span class="badge bg-danger">عاجلة</span>
                                            @endif
                                        </td>
                                        <td class="text-danger fw-bold">{{ $task->due_date->format('Y-m-d') }}</td>
                                        <td class="text-danger fw-bold">{{ $task->due_date->diffForHumans(['parts' => 1]) }}</td>
                                        <td>
                                            @if($task->status == 'pending')
                                                <span class="badge bg-secondary">قيد الانتظار</span>
                                            @elseif($task->status == 'in_progress')
                                                <span class="badge bg-primary">قيد التنفيذ</span>
                                            @elseif($task->status == 'on_hold')
                                                <span class="badge bg-warning">معلقة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.tasks.show', $task->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.tasks.edit', $task->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد مهام متأخرة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $overdueTasks->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection