@extends('layouts.modern')

@section('title', 'إدارة مهام الموظفين')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">إدارة مهام الموظفين</h3>
                    <div>
                        <a href="{{ route('hrm.tasks.overdue') }}" class="btn btn-danger me-2">
                            <i class="fas fa-exclamation-circle"></i> المهام المتأخرة
                        </a>
                        <a href="{{ route('hrm.tasks.upcoming') }}" class="btn btn-warning me-2">
                            <i class="fas fa-clock"></i> المهام القادمة
                        </a>
                        <a href="{{ route('hrm.tasks.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة مهمة جديدة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="mb-4">
                        <form action="{{ route('hrm.tasks.index') }}" method="GET" class="row g-3">
                            <div class="col-md-3">
                                <input type="text" name="search" class="form-control" placeholder="بحث..." value="{{ request('search') }}">
                            </div>
                            <div class="col-md-2">
                                <select name="status" class="form-select">
                                    <option value="">-- الحالة --</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                    <option value="on_hold" {{ request('status') == 'on_hold' ? 'selected' : '' }}>معلقة</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="priority" class="form-select">
                                    <option value="">-- الأولوية --</option>
                                    <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>منخفضة</option>
                                    <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                    <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>عالية</option>
                                    <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="employee_id" class="form-select">
                                    <option value="">-- الموظف --</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> إعادة تعيين
                                </a>
                            </div>
                        </form>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الموظفين المكلفين</th>
                                    <th>الأولوية</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($tasks as $task)
                                    <tr>
                                        <td>{{ $loop->iteration + ($tasks->currentPage() - 1) * $tasks->perPage() }}</td>
                                        <td>{{ $task->title }}</td>
                                        <td>
                                            @foreach($task->assignees as $assignee)
                                                <span class="badge bg-info">{{ $assignee->employee->full_name }}</span>
                                            @endforeach
                                        </td>
                                        <td>
                                            @if($task->priority == 'low')
                                                <span class="badge bg-success">منخفضة</span>
                                            @elseif($task->priority == 'medium')
                                                <span class="badge bg-info">متوسطة</span>
                                            @elseif($task->priority == 'high')
                                                <span class="badge bg-warning">عالية</span>
                                            @elseif($task->priority == 'urgent')
                                                <span class="badge bg-danger">عاجلة</span>
                                            @endif
                                        </td>
                                        <td>{{ $task->start_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($task->is_overdue)
                                                <span class="text-danger fw-bold">{{ $task->due_date->format('Y-m-d') }} (متأخرة)</span>
                                            @else
                                                {{ $task->due_date->format('Y-m-d') }}
                                            @endif
                                        </td>
                                        <td>
                                            @if($task->status == 'pending')
                                                <span class="badge bg-secondary">قيد الانتظار</span>
                                            @elseif($task->status == 'in_progress')
                                                <span class="badge bg-primary">قيد التنفيذ</span>
                                            @elseif($task->status == 'completed')
                                                <span class="badge bg-success">مكتملة</span>
                                            @elseif($task->status == 'cancelled')
                                                <span class="badge bg-danger">ملغاة</span>
                                            @elseif($task->status == 'on_hold')
                                                <span class="badge bg-warning">معلقة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.tasks.show', $task->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.tasks.edit', $task->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $task->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Modal for Delete Confirmation -->
                                            <div class="modal fade" id="deleteModal{{ $task->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $task->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $task->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف المهمة "{{ $task->title }}"؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('hrm.tasks.destroy', $task->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد مهام</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $tasks->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection