@extends('layouts.modern')

@section('title', 'لوحة معلومات المهام')

@section('styles')
<style>
    .stat-card {
        transition: all 0.3s ease;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    .task-list-item {
        transition: all 0.2s ease;
    }
    .task-list-item:hover {
        background-color: rgba(0,0,0,0.03);
    }
    .chart-container {
        position: relative;
        height: 250px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">لوحة معلومات المهام</h3>
                    <div>
                        <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary me-2">
                            <i class="fas fa-list"></i> قائمة المهام
                        </a>
                        <a href="{{ route('hrm.tasks.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus-circle"></i> إضافة مهمة جديدة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- إحصائيات سريعة -->
                    <div class="row mb-4">
                        <div class="col-md-3 mb-3">
                            <div class="card bg-primary text-white stat-card h-100">
                                <div class="card-body text-center">
                                    <h1 class="display-4">{{ $totalTasks }}</h1>
                                    <h5 class="card-title">إجمالي المهام</h5>
                                    <p class="card-text">
                                        <a href="{{ route('hrm.tasks.index') }}" class="btn btn-outline-light btn-sm mt-2">عرض الكل</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-success text-white stat-card h-100">
                                <div class="card-body text-center">
                                    <h1 class="display-4">{{ $completedTasks }}</h1>
                                    <h5 class="card-title">المهام المكتملة</h5>
                                    <p class="card-text">
                                        <a href="{{ route('hrm.tasks.index', ['status' => 'completed']) }}" class="btn btn-outline-light btn-sm mt-2">عرض المكتملة</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-info text-white stat-card h-100">
                                <div class="card-body text-center">
                                    <h1 class="display-4">{{ $inProgressTasks }}</h1>
                                    <h5 class="card-title">قيد التنفيذ</h5>
                                    <p class="card-text">
                                        <a href="{{ route('hrm.tasks.index', ['status' => 'in_progress']) }}" class="btn btn-outline-light btn-sm mt-2">عرض الجارية</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-danger text-white stat-card h-100">
                                <div class="card-body text-center">
                                    <h1 class="display-4">{{ $overdueTasks }}</h1>
                                    <h5 class="card-title">المهام المتأخرة</h5>
                                    <p class="card-text">
                                        <a href="{{ route('hrm.tasks.index', ['date_filter' => 'overdue']) }}" class="btn btn-outline-light btn-sm mt-2">عرض المتأخرة</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الرسوم البيانية -->
                    <div class="row mb-4">
                        <div class="col-md-6 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">توزيع المهام حسب الحالة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="statusChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">توزيع المهام حسب الأولوية</h5>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="priorityChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- المهام المتأخرة والقادمة -->
                    <div class="row mb-4">
                        <div class="col-md-6 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-danger text-white">
                                    <h5 class="mb-0">المهام المتأخرة</h5>
                                </div>
                                <div class="card-body">
                                    @if($recentOverdueTasks->count() > 0)
                                        <div class="list-group">
                                            @foreach($recentOverdueTasks as $task)
                                                <a href="{{ route('hrm.tasks.show', $task->id) }}" class="list-group-item list-group-item-action task-list-item">
                                                    <div class="d-flex w-100 justify-content-between">
                                                        <h6 class="mb-1">{{ $task->title }}</h6>
                                                        <small class="text-danger">متأخرة بـ {{ abs($task->days_remaining) }} يوم</small>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <span class="badge bg-{{ $task->priority_color }}">{{ $task->priority_label }}</span>
                                                            <small class="text-muted me-2">
                                                                المكلفين: 
                                                                @foreach($task->assignees as $assignee)
                                                                    {{ $loop->first ? '' : '، ' }}
                                                                    {{ $assignee->employee->full_name ?? 'غير محدد' }}
                                                                @endforeach
                                                            </small>
                                                        </div>
                                                        <div class="progress" style="width: 100px; height: 10px;">
                                                            <div class="progress-bar bg-{{ $task->status_color }}" role="progressbar" 
                                                                style="width: {{ $task->progress }}%;" 
                                                                aria-valuenow="{{ $task->progress }}" 
                                                                aria-valuemin="0" 
                                                                aria-valuemax="100">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="{{ route('hrm.tasks.index', ['date_filter' => 'overdue']) }}" class="btn btn-outline-danger">عرض كل المهام المتأخرة</a>
                                        </div>
                                    @else
                                        <div class="alert alert-success">
                                            لا توجد مهام متأخرة
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">المهام القادمة</h5>
                                </div>
                                <div class="card-body">
                                    @if($upcomingTasks->count() > 0)
                                        <div class="list-group">
                                            @foreach($upcomingTasks as $task)
                                                <a href="{{ route('hrm.tasks.show', $task->id) }}" class="list-group-item list-group-item-action task-list-item">
                                                    <div class="d-flex w-100 justify-content-between">
                                                        <h6 class="mb-1">{{ $task->title }}</h6>
                                                        <small class="text-{{ $task->days_remaining <= 3 ? 'warning' : 'muted' }}">
                                                            متبقي {{ $task->days_remaining }} يوم
                                                        </small>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <span class="badge bg-{{ $task->priority_color }}">{{ $task->priority_label }}</span>
                                                            <small class="text-muted me-2">
                                                                المكلفين: 
                                                                @foreach($task->assignees as $assignee)
                                                                    {{ $loop->first ? '' : '، ' }}
                                                                    {{ $assignee->employee->full_name ?? 'غير محدد' }}
                                                                @endforeach
                                                            </small>
                                                        </div>
                                                        <div class="progress" style="width: 100px; height: 10px;">
                                                            <div class="progress-bar bg-{{ $task->status_color }}" role="progressbar" 
                                                                style="width: {{ $task->progress }}%;" 
                                                                aria-valuenow="{{ $task->progress }}" 
                                                                aria-valuemin="0" 
                                                                aria-valuemax="100">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="{{ route('hrm.tasks.index', ['date_filter' => 'this_week']) }}" class="btn btn-outline-warning">عرض مهام هذا الأسبوع</a>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد مهام قادمة
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- المهام المكتملة مؤخراً وأكثر الموظفين نشاطاً -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">المهام المكتملة مؤخراً</h5>
                                </div>
                                <div class="card-body">
                                    @if($recentCompletedTasks->count() > 0)
                                        <div class="list-group">
                                            @foreach($recentCompletedTasks as $task)
                                                <a href="{{ route('hrm.tasks.show', $task->id) }}" class="list-group-item list-group-item-action task-list-item">
                                                    <div class="d-flex w-100 justify-content-between">
                                                        <h6 class="mb-1">{{ $task->title }}</h6>
                                                        <small class="text-success">
                                                            تم الإكمال {{ $task->completed_at->diffForHumans() }}
                                                        </small>
                                                    </div>
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <span class="badge bg-{{ $task->priority_color }}">{{ $task->priority_label }}</span>
                                                            <small class="text-muted me-2">
                                                                المكلفين: 
                                                                @foreach($task->assignees as $assignee)
                                                                    {{ $loop->first ? '' : '، ' }}
                                                                    {{ $assignee->employee->full_name ?? 'غير محدد' }}
                                                                @endforeach
                                                            </small>
                                                        </div>
                                                        <div class="progress" style="width: 100px; height: 10px;">
                                                            <div class="progress-bar bg-success" role="progressbar" 
                                                                style="width: 100%;" 
                                                                aria-valuenow="100" 
                                                                aria-valuemin="0" 
                                                                aria-valuemax="100">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            @endforeach
                                        </div>
                                        <div class="text-center mt-3">
                                            <a href="{{ route('hrm.tasks.index', ['status' => 'completed']) }}" class="btn btn-outline-success">عرض كل المهام المكتملة</a>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد مهام مكتملة مؤخراً
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">أكثر الموظفين نشاطاً</h5>
                                </div>
                                <div class="card-body">
                                    @if($topEmployees->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>الموظف</th>
                                                        <th>المهام المكتملة</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($topEmployees as $employee)
                                                        <tr>
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>
                                                                <a href="{{ route('hrm.employees.show', $employee->id) }}">
                                                                    {{ $employee->full_name }}
                                                                </a>
                                                            </td>
                                                            <td>{{ $employee->tasks_count }}</td>
                                                            <td>
                                                                <a href="{{ route('hrm.tasks.employee', $employee->id) }}" class="btn btn-sm btn-primary">
                                                                    <i class="fas fa-tasks"></i> عرض المهام
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد بيانات متاحة
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // رسم بياني لتوزيع المهام حسب الحالة
        var statusCtx = document.getElementById('statusChart').getContext('2d');
        var statusChart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: ['قيد الانتظار', 'قيد التنفيذ', 'مكتملة', 'ملغية'],
                datasets: [{
                    data: [{{ $pendingTasks }}, {{ $inProgressTasks }}, {{ $completedTasks }}, {{ $cancelledTasks }}],
                    backgroundColor: [
                        '#6c757d',
                        '#0d6efd',
                        '#198754',
                        '#dc3545'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });
        
        // رسم بياني لتوزيع المهام حسب الأولوية
        var priorityCtx = document.getElementById('priorityChart').getContext('2d');
        var priorityChart = new Chart(priorityCtx, {
            type: 'bar',
            data: {
                labels: ['منخفضة', 'متوسطة', 'عالية', 'عاجلة'],
                datasets: [{
                    label: 'عدد المهام',
                    data: [{{ $lowPriorityTasks }}, {{ $mediumPriorityTasks }}, {{ $highPriorityTasks }}, {{ $urgentPriorityTasks }}],
                    backgroundColor: [
                        '#198754',
                        '#0dcaf0',
                        '#ffc107',
                        '#dc3545'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
    });
</script>
@endsection