@extends('layouts.modern')

@section('title', 'إضافة مهمة جديدة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">إضافة مهمة جديدة</h3>
                    <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('hrm.tasks.store') }}" method="POST">
                        @csrf
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="title" class="form-label">عنوان المهمة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="description" class="form-label">وصف المهمة</label>
                                    <textarea class="form-control" id="description" name="description" rows="4">{{ old('description') }}</textarea>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="priority" class="form-label">الأولوية <span class="text-danger">*</span></label>
                                    <select class="form-select" id="priority" name="priority" required>
                                        <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>منخفضة</option>
                                        <option value="medium" {{ old('priority') == 'medium' ? 'selected' : '' }} selected>متوسطة</option>
                                        <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>عالية</option>
                                        <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                    </select>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }} selected>قيد الانتظار</option>
                                        <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                        <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                        <option value="on_hold" {{ old('status') == 'on_hold' ? 'selected' : '' }}>معلقة</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', date('Y-m-d')) }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="due_date" class="form-label">تاريخ الاستحقاق <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="due_date" name="due_date" value="{{ old('due_date') }}" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="employees" class="form-label">الموظفين المكلفين <span class="text-danger">*</span></label>
                                    <select class="form-select" id="employees" name="employees[]" multiple required>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ in_array($employee->id, old('employees', [])) ? 'selected' : '' }}>
                                                {{ $employee->full_name }} ({{ $employee->employee_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">اضغط Ctrl للاختيار المتعدد</small>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="notes" class="form-label">ملاحظات</label>
                                    <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group text-center">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                            <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تحقق من تاريخ البدء والاستحقاق
        $('#due_date').change(function() {
            var startDate = new Date($('#start_date').val());
            var dueDate = new Date($(this).val());
            
            if (dueDate < startDate) {
                alert('تاريخ الاستحقاق يجب أن يكون بعد تاريخ البدء');
                $(this).val('');
            }
        });
        
        $('#start_date').change(function() {
            var dueDateField = $('#due_date');
            if (dueDateField.val()) {
                var startDate = new Date($(this).val());
                var dueDate = new Date(dueDateField.val());
                
                if (dueDate < startDate) {
                    alert('تاريخ الاستحقاق يجب أن يكون بعد تاريخ البدء');
                    dueDateField.val('');
                }
            }
        });
    });
</script>
@endsection