@extends('layouts.modern')

@section('title', 'تفاصيل سياسة الرواتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل سياسة الرواتب: {{ $salaryPolicy->name }}</h3>
                    <div>
                        @can('edit_salary_policies')
                        <a href="{{ route('hrm.salary-policies.edit', $salaryPolicy->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <a href="{{ route('hrm.salary-policies.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%">الشركة</th>
                                    <td>{{ $salaryPolicy->company->name }}</td>
                                </tr>
                                <tr>
                                    <th>اسم السياسة</th>
                                    <td>{{ $salaryPolicy->name }}</td>
                                </tr>
                                <tr>
                                    <th>طريقة حساب الضريبة</th>
                                    <td>
                                        @if($salaryPolicy->tax_calculation_method == 'progressive')
                                            تصاعدي
                                        @else
                                            ثابت
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>نسبة التأمينات الاجتماعية</th>
                                    <td>{{ $salaryPolicy->social_insurance_percentage }}%</td>
                                </tr>
                            </table>
                        </div>
                        
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%">معدل العمل الإضافي</th>
                                    <td>{{ $salaryPolicy->overtime_rate }}</td>
                                </tr>
                                <tr>
                                    <th>معدل خصم التأخير</th>
                                    <td>{{ $salaryPolicy->late_deduction_rate }}</td>
                                </tr>
                                <tr>
                                    <th>طريقة خصم الغياب</th>
                                    <td>
                                        @if($salaryPolicy->absence_deduction_method == 'daily')
                                            يومي
                                        @else
                                            بالساعة
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>حساب العمل الإضافي</th>
                                    <td>
                                        @if($salaryPolicy->calculate_overtime)
                                            <span class="badge badge-success">نعم</span>
                                        @else
                                            <span class="badge badge-danger">لا</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات إضافية</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 25%">تاريخ الإنشاء</th>
                                            <td>{{ $salaryPolicy->created_at->format('Y-m-d H:i') }}</td>
                                            <th style="width: 25%">بواسطة</th>
                                            <td>{{ $salaryPolicy->createdBy ? $salaryPolicy->createdBy->name : 'غير معروف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $salaryPolicy->updated_at->format('Y-m-d H:i') }}</td>
                                            <th>بواسطة</th>
                                            <td>{{ $salaryPolicy->updatedBy ? $salaryPolicy->updatedBy->name : 'غير معروف' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection