@extends('layouts.modern')

@section('title', 'سياسات الرواتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">سياسات الرواتب</h3>
                    @can('create_salary_policies')
                    <a href="{{ route('hrm.salary-policies.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة سياسة جديدة
                    </a>
                    @endcan
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>طريقة حساب الضريبة</th>
                                    <th>نسبة التأمينات الاجتماعية</th>
                                    <th>معدل العمل الإضافي</th>
                                    <th>معدل خصم التأخير</th>
                                    <th>طريقة خصم الغياب</th>
                                    <th>حساب العمل الإضافي</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($salaryPolicies as $policy)
                                <tr>
                                    <td>{{ $policy->id }}</td>
                                    <td>{{ $policy->name }}</td>
                                    <td>
                                        @if($policy->tax_calculation_method == 'progressive')
                                            تصاعدي
                                        @else
                                            ثابت
                                        @endif
                                    </td>
                                    <td>{{ $policy->social_insurance_percentage }}%</td>
                                    <td>{{ $policy->overtime_rate }}</td>
                                    <td>{{ $policy->late_deduction_rate }}</td>
                                    <td>
                                        @if($policy->absence_deduction_method == 'daily')
                                            يومي
                                        @else
                                            بالساعة
                                        @endif
                                    </td>
                                    <td>
                                        @if($policy->calculate_overtime)
                                            <span class="badge badge-success">نعم</span>
                                        @else
                                            <span class="badge badge-danger">لا</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('hrm.salary-policies.show', $policy->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @can('edit_salary_policies')
                                            <a href="{{ route('hrm.salary-policies.edit', $policy->id) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('delete_salary_policies')
                                            <form action="{{ route('hrm.salary-policies.destroy', $policy->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه السياسة؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد سياسات رواتب</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $salaryPolicies->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection