@extends('layouts.modern')

@section('title', 'تعديل سياسة الرواتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل سياسة الرواتب: {{ $salaryPolicy->name }}</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('hrm.salary-policies.update', $salaryPolicy->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_id">الشركة</label>
                                    <select name="company_id" id="company_id" class="form-control @error('company_id') is-invalid @enderror" required {{ auth()->user()->hasRole('super-admin') ? '' : 'disabled' }}>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}" {{ old('company_id', $salaryPolicy->company_id) == $company->id ? 'selected' : '' }}>
                                                {{ $company->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @if(!auth()->user()->hasRole('super-admin'))
                                        <input type="hidden" name="company_id" value="{{ $salaryPolicy->company_id }}">
                                    @endif
                                    @error('company_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم السياسة</label>
                                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $salaryPolicy->name) }}" required>
                                    @error('name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tax_calculation_method">طريقة حساب الضريبة</label>
                                    <select name="tax_calculation_method" id="tax_calculation_method" class="form-control @error('tax_calculation_method') is-invalid @enderror" required>
                                        <option value="progressive" {{ old('tax_calculation_method', $salaryPolicy->tax_calculation_method) == 'progressive' ? 'selected' : '' }}>تصاعدي</option>
                                        <option value="flat" {{ old('tax_calculation_method', $salaryPolicy->tax_calculation_method) == 'flat' ? 'selected' : '' }}>ثابت</option>
                                    </select>
                                    @error('tax_calculation_method')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="social_insurance_percentage">نسبة التأمينات الاجتماعية (%)</label>
                                    <input type="number" name="social_insurance_percentage" id="social_insurance_percentage" class="form-control @error('social_insurance_percentage') is-invalid @enderror" value="{{ old('social_insurance_percentage', $salaryPolicy->social_insurance_percentage) }}" min="0" max="100" step="0.01" required>
                                    @error('social_insurance_percentage')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="overtime_rate">معدل العمل الإضافي</label>
                                    <input type="number" name="overtime_rate" id="overtime_rate" class="form-control @error('overtime_rate') is-invalid @enderror" value="{{ old('overtime_rate', $salaryPolicy->overtime_rate) }}" min="0" step="0.01" required>
                                    @error('overtime_rate')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="late_deduction_rate">معدل خصم التأخير</label>
                                    <input type="number" name="late_deduction_rate" id="late_deduction_rate" class="form-control @error('late_deduction_rate') is-invalid @enderror" value="{{ old('late_deduction_rate', $salaryPolicy->late_deduction_rate) }}" min="0" step="0.01" required>
                                    @error('late_deduction_rate')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="absence_deduction_method">طريقة خصم الغياب</label>
                                    <select name="absence_deduction_method" id="absence_deduction_method" class="form-control @error('absence_deduction_method') is-invalid @enderror" required>
                                        <option value="daily" {{ old('absence_deduction_method', $salaryPolicy->absence_deduction_method) == 'daily' ? 'selected' : '' }}>يومي</option>
                                        <option value="hourly" {{ old('absence_deduction_method', $salaryPolicy->absence_deduction_method) == 'hourly' ? 'selected' : '' }}>بالساعة</option>
                                    </select>
                                    @error('absence_deduction_method')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch mt-4">
                                        <input type="checkbox" class="custom-control-input" id="calculate_overtime" name="calculate_overtime" {{ old('calculate_overtime', $salaryPolicy->calculate_overtime) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="calculate_overtime">حساب العمل الإضافي</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">تحديث</button>
                            <a href="{{ route('hrm.salary-policies.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection