@extends('layouts.modern')

@section('title', 'تقرير الإجازات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تقرير الإجازات</h3>
                    <div>
                        <button type="button" class="btn btn-success" id="exportExcel">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </button>
                        <button type="button" class="btn btn-danger" id="exportPdf">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </button>
                        <a href="{{ route('hrm.reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتقارير
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.reports.leaves') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="department_id" class="ml-2">القسم:</label>
                                    <select name="department_id" id="department_id" class="form-control">
                                        <option value="">-- جميع الأقسام --</option>
                                        @foreach($departments as $department)
                                            <option value="{{ $department->id }}" {{ request('department_id') == $department->id ? 'selected' : '' }}>
                                                {{ $department->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="employee_id" class="ml-2">الموظف:</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">-- جميع الموظفين --</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="leave_type_id" class="ml-2">نوع الإجازة:</label>
                                    <select name="leave_type_id" id="leave_type_id" class="form-control">
                                        <option value="">-- جميع الأنواع --</option>
                                        @foreach($leaveTypes as $leaveType)
                                            <option value="{{ $leaveType->id }}" {{ request('leave_type_id') == $leaveType->id ? 'selected' : '' }}>
                                                {{ $leaveType->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="status" class="ml-2">الحالة:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>موافق عليها</option>
                                        <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>مرفوضة</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="date_from" class="ml-2">من تاريخ:</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from', $defaultDateFrom) }}">
                                </div>
                                <div class="form-group mx-1">
                                    <label for="date_to" class="ml-2">إلى تاريخ:</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to', $defaultDateTo) }}">
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.reports.leaves') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <!-- ملخص البيانات -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-calendar-minus"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي الإجازات</span>
                                    <span class="info-box-number">{{ $totalLeaves }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">موافق عليها</span>
                                    <span class="info-box-number">{{ $approvedLeaves }}</span>
                                    <span class="info-box-text">{{ number_format($approvedPercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">قيد الانتظار</span>
                                    <span class="info-box-number">{{ $pendingLeaves }}</span>
                                    <span class="info-box-text">{{ number_format($pendingPercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-times-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مرفوضة</span>
                                    <span class="info-box-number">{{ $rejectedLeaves }}</span>
                                    <span class="info-box-text">{{ number_format($rejectedPercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الرسوم البيانية -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الإجازات حسب النوع</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="leaveTypeChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الإجازات حسب الشهر</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="leaveMonthChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الإجازات حسب القسم</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="departmentLeaveChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الإجازات حسب الحالة</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="leaveStatusChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول البيانات -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">سجل الإجازات</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="leavesTable">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الموظف</th>
                                                    <th>القسم</th>
                                                    <th>نوع الإجازة</th>
                                                    <th>تاريخ البداية</th>
                                                    <th>تاريخ النهاية</th>
                                                    <th>عدد الأيام</th>
                                                    <th>الحالة</th>
                                                    <th>تاريخ الطلب</th>
                                                    <th>السبب</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($leaves as $leave)
                                                    <tr>
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td>
                                                            <a href="{{ route('hrm.employees.show', $leave->employee->id) }}">
                                                                {{ $leave->employee->first_name }} {{ $leave->employee->last_name }}
                                                            </a>
                                                        </td>
                                                        <td>{{ $leave->employee->department ? $leave->employee->department->name : '-' }}</td>
                                                        <td>{{ $leave->leaveType->name }}</td>
                                                        <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                                        <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                                        <td>{{ $leave->total_days }}</td>
                                                        <td>
                                                            @if($leave->status == 'pending')
                                                                <span class="badge badge-warning">قيد الانتظار</span>
                                                            @elseif($leave->status == 'approved')
                                                                <span class="badge badge-success">موافق عليها</span>
                                                            @elseif($leave->status == 'rejected')
                                                                <span class="badge badge-danger">مرفوضة</span>
                                                            @elseif($leave->status == 'cancelled')
                                                                <span class="badge badge-secondary">ملغاة</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ $leave->created_at->format('Y-m-d') }}</td>
                                                        <td>{{ Str::limit($leave->reason, 30) ?: '-' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- أرصدة الإجازات -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">أرصدة الإجازات للموظفين</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="balancesTable">
                                            <thead>
                                                <tr>
                                                    <th>الموظف</th>
                                                    <th>القسم</th>
                                                    <th>نوع الإجازة</th>
                                                    <th>الرصيد الإجمالي</th>
                                                    <th>المستخدم</th>
                                                    <th>المتبقي</th>
                                                    <th>آخر تحديث</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($leaveBalances as $balance)
                                                    <tr>
                                                        <td>{{ $balance->employee->first_name }} {{ $balance->employee->last_name }}</td>
                                                        <td>{{ $balance->employee->department ? $balance->employee->department->name : '-' }}</td>
                                                        <td>{{ $balance->leaveType->name }}</td>
                                                        <td>{{ $balance->total_balance }}</td>
                                                        <td>{{ $balance->used_balance }}</td>
                                                        <td>{{ $balance->balance }}</td>
                                                        <td>{{ $balance->updated_at->format('Y-m-d') }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.3.1/dist/jspdf.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf-autotable@3.5.14/dist/jspdf.plugin.autotable.min.js"></script>

<script>
    $(document).ready(function() {
        // إعداد الرسوم البيانية
        var leaveTypeCtx = document.getElementById('leaveTypeChart').getContext('2d');
        var leaveTypeChart = new Chart(leaveTypeCtx, {
            type: 'pie',
            data: {
                labels: {!! json_encode($leaveTypeStats->pluck('name')) !!},
                datasets: [{
                    data: {!! json_encode($leaveTypeStats->pluck('count')) !!},
                    backgroundColor: [
                        '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#858796', '#5a5c69'
                    ],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });

        var leaveMonthCtx = document.getElementById('leaveMonthChart').getContext('2d');
        var leaveMonthChart = new Chart(leaveMonthCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($leaveMonthStats->pluck('month')) !!},
                datasets: [{
                    label: 'عدد الإجازات',
                    data: {!! json_encode($leaveMonthStats->pluck('count')) !!},
                    backgroundColor: '#4e73df',
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        var departmentLeaveCtx = document.getElementById('departmentLeaveChart').getContext('2d');
        var departmentLeaveChart = new Chart(departmentLeaveCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($departmentLeaveStats->pluck('name')) !!},
                datasets: [{
                    label: 'عدد الإجازات',
                    data: {!! json_encode($departmentLeaveStats->pluck('count')) !!},
                    backgroundColor: '#1cc88a',
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        var leaveStatusCtx = document.getElementById('leaveStatusChart').getContext('2d');
        var leaveStatusChart = new Chart(leaveStatusCtx, {
            type: 'doughnut',
            data: {
                labels: ['قيد الانتظار', 'موافق عليها', 'مرفوضة', 'ملغاة'],
                datasets: [{
                    data: [
                        {{ $pendingLeaves }}, 
                        {{ $approvedLeaves }}, 
                        {{ $rejectedLeaves }}, 
                        {{ $cancelledLeaves }}
                    ],
                    backgroundColor: ['#f6c23e', '#1cc88a', '#e74a3b', '#858796'],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });

        // تصدير البيانات إلى Excel
        $('#exportExcel').click(function() {
            var wb = XLSX.utils.book_new();
            
            // إضافة جدول الإجازات
            var leavesWs = XLSX.utils.table_to_sheet(document.getElementById('leavesTable'));
            XLSX.utils.book_append_sheet(wb, leavesWs, "الإجازات");
            
            // إضافة جدول الأرصدة
            var balancesWs = XLSX.utils.table_to_sheet(document.getElementById('balancesTable'));
            XLSX.utils.book_append_sheet(wb, balancesWs, "أرصدة الإجازات");
            
            XLSX.writeFile(wb, 'تقرير_الإجازات.xlsx');
        });

        // تصدير البيانات إلى PDF
        $('#exportPdf').click(function() {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF('l', 'mm', 'a4');
            
            // إضافة عنوان للتقرير
            doc.setFont("courier", "bold");
            doc.setFontSize(18);
            doc.text("تقرير الإجازات", doc.internal.pageSize.width / 2, 15, { align: "center" });
            
            // إضافة التاريخ
            doc.setFontSize(12);
            doc.text("تاريخ التقرير: " + new Date().toLocaleDateString('ar-SA'), doc.internal.pageSize.width - 15, 15, { align: "right" });
            
            // إضافة فترة التقرير
            doc.text("الفترة: من " + $('#date_from').val() + " إلى " + $('#date_to').val(), 15, 15, { align: "left" });
            
            // إضافة جدول الإجازات
            doc.setFontSize(14);
            doc.text("سجل الإجازات", doc.internal.pageSize.width / 2, 25, { align: "center" });
            
            doc.autoTable({
                html: '#leavesTable',
                startY: 30,
                theme: 'grid',
                headStyles: { fillColor: [66, 135, 245], textColor: 255 },
                styles: { font: "courier", halign: "center" },
                margin: { top: 30 }
            });
            
            // إضافة جدول الأرصدة في صفحة جديدة
            doc.addPage();
            doc.setFontSize(14);
            doc.text("أرصدة الإجازات", doc.internal.pageSize.width / 2, 15, { align: "center" });
            
            doc.autoTable({
                html: '#balancesTable',
                startY: 20,
                theme: 'grid',
                headStyles: { fillColor: [66, 135, 245], textColor: 255 },
                styles: { font: "courier", halign: "center" },
                margin: { top: 20 }
            });
            
            doc.save('تقرير_الإجازات.pdf');
        });
    });
</script>
@endpush
@endsection