@extends('layouts.modern')

@section('title', 'تقارير الموارد البشرية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقارير الموارد البشرية</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-3 col-md-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $employeeCount }}</h3>
                                    <p>إجمالي الموظفين</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <a href="{{ route('hrm.reports.employees') }}" class="small-box-footer">
                                    عرض التقرير <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $attendanceRate }}%</h3>
                                    <p>معدل الحضور</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-check"></i>
                                </div>
                                <a href="{{ route('hrm.reports.attendance') }}" class="small-box-footer">
                                    عرض التقرير <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $leaveCount }}</h3>
                                    <p>الإجازات (هذا الشهر)</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-minus"></i>
                                </div>
                                <a href="{{ route('hrm.reports.leaves') }}" class="small-box-footer">
                                    عرض التقرير <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $turnoverRate }}%</h3>
                                    <p>معدل دوران الموظفين</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-exchange-alt"></i>
                                </div>
                                <a href="{{ route('hrm.reports.turnover') }}" class="small-box-footer">
                                    عرض التقرير <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">اختر التقرير</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body text-center">
                                                    <i class="fas fa-users fa-3x text-primary mb-3"></i>
                                                    <h5>تقرير الموظفين</h5>
                                                    <p class="text-muted">إحصائيات وبيانات تفصيلية عن الموظفين</p>
                                                    <a href="{{ route('hrm.reports.employees') }}" class="btn btn-primary">عرض التقرير</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body text-center">
                                                    <i class="fas fa-calendar-check fa-3x text-success mb-3"></i>
                                                    <h5>تقرير الحضور والانصراف</h5>
                                                    <p class="text-muted">تحليل بيانات الحضور والانصراف للموظفين</p>
                                                    <a href="{{ route('hrm.reports.attendance') }}" class="btn btn-success">عرض التقرير</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body text-center">
                                                    <i class="fas fa-calendar-minus fa-3x text-warning mb-3"></i>
                                                    <h5>تقرير الإجازات</h5>
                                                    <p class="text-muted">تحليل بيانات الإجازات وأرصدة الموظفين</p>
                                                    <a href="{{ route('hrm.reports.leaves') }}" class="btn btn-warning">عرض التقرير</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body text-center">
                                                    <i class="fas fa-exchange-alt fa-3x text-danger mb-3"></i>
                                                    <h5>تقرير دوران الموظفين</h5>
                                                    <p class="text-muted">تحليل معدلات التوظيف وإنهاء الخدمة</p>
                                                    <a href="{{ route('hrm.reports.turnover') }}" class="btn btn-danger">عرض التقرير</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body text-center">
                                                    <i class="fas fa-chart-pie fa-3x text-info mb-3"></i>
                                                    <h5>تقرير التوزيع الديموغرافي</h5>
                                                    <p class="text-muted">تحليل توزيع الموظفين حسب العمر والجنس والجنسية</p>
                                                    <a href="{{ route('hrm.reports.demographics') }}" class="btn btn-info">عرض التقرير</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card">
                                                <div class="card-body text-center">
                                                    <i class="fas fa-money-bill-wave fa-3x text-secondary mb-3"></i>
                                                    <h5>تقرير الرواتب والتعويضات</h5>
                                                    <p class="text-muted">تحليل بيانات الرواتب والبدلات والمكافآت</p>
                                                    <a href="{{ route('hrm.reports.payroll') }}" class="btn btn-secondary">عرض التقرير</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection