@extends('layouts.modern')

@section('title', 'تقرير الموظفين')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تقرير الموظفين</h3>
                    <div>
                        <button type="button" class="btn btn-success" id="exportExcel">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </button>
                        <button type="button" class="btn btn-danger" id="exportPdf">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </button>
                        <a href="{{ route('hrm.reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتقارير
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.reports.employees') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="department_id" class="ml-2">القسم:</label>
                                    <select name="department_id" id="department_id" class="form-control">
                                        <option value="">-- جميع الأقسام --</option>
                                        @foreach($departments as $department)
                                            <option value="{{ $department->id }}" {{ request('department_id') == $department->id ? 'selected' : '' }}>
                                                {{ $department->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="job_title_id" class="ml-2">المسمى الوظيفي:</label>
                                    <select name="job_title_id" id="job_title_id" class="form-control">
                                        <option value="">-- جميع المسميات --</option>
                                        @foreach($jobTitles as $jobTitle)
                                            <option value="{{ $jobTitle->id }}" {{ request('job_title_id') == $jobTitle->id ? 'selected' : '' }}>
                                                {{ $jobTitle->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="employment_status" class="ml-2">حالة التوظيف:</label>
                                    <select name="employment_status" id="employment_status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="full_time" {{ request('employment_status') == 'full_time' ? 'selected' : '' }}>دوام كامل</option>
                                        <option value="part_time" {{ request('employment_status') == 'part_time' ? 'selected' : '' }}>دوام جزئي</option>
                                        <option value="contract" {{ request('employment_status') == 'contract' ? 'selected' : '' }}>عقد مؤقت</option>
                                        <option value="intern" {{ request('employment_status') == 'intern' ? 'selected' : '' }}>متدرب</option>
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="status" class="ml-2">الحالة:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>نشط</option>
                                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>غير نشط</option>
                                        <option value="on_leave" {{ request('status') == 'on_leave' ? 'selected' : '' }}>في إجازة</option>
                                        <option value="terminated" {{ request('status') == 'terminated' ? 'selected' : '' }}>منتهي الخدمة</option>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.reports.employees') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <!-- ملخص البيانات -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي الموظفين</span>
                                    <span class="info-box-number">{{ $totalEmployees }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-user-check"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الموظفين النشطين</span>
                                    <span class="info-box-number">{{ $activeEmployees }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-user-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">في إجازة</span>
                                    <span class="info-box-number">{{ $onLeaveEmployees }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-user-times"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">منتهي الخدمة</span>
                                    <span class="info-box-number">{{ $terminatedEmployees }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الرسوم البيانية -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الموظفين حسب القسم</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="departmentChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الموظفين حسب المسمى الوظيفي</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="jobTitleChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الموظفين حسب الجنس</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="genderChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع الموظفين حسب حالة التوظيف</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="employmentStatusChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول البيانات -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">قائمة الموظفين</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="employeesTable">
                                            <thead>
                                                <tr>
                                                    <th>رقم الموظف</th>
                                                    <th>الاسم</th>
                                                    <th>القسم</th>
                                                    <th>المسمى الوظيفي</th>
                                                    <th>البريد الإلكتروني</th>
                                                    <th>رقم الهاتف</th>
                                                    <th>تاريخ التعيين</th>
                                                    <th>حالة التوظيف</th>
                                                    <th>الحالة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($employees as $employee)
                                                    <tr>
                                                        <td>{{ $employee->employee_number }}</td>
                                                        <td>
                                                            <a href="{{ route('hrm.employees.show', $employee->id) }}">
                                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                                            </a>
                                                        </td>
                                                        <td>{{ $employee->department ? $employee->department->name : '-' }}</td>
                                                        <td>{{ $employee->jobTitle ? $employee->jobTitle->name : '-' }}</td>
                                                        <td>{{ $employee->email }}</td>
                                                        <td>{{ $employee->phone }}</td>
                                                        <td>{{ $employee->join_date->format('Y-m-d') }}</td>
                                                        <td>
                                                            @if($employee->employment_status == 'full_time')
                                                                <span class="badge badge-primary">دوام كامل</span>
                                                            @elseif($employee->employment_status == 'part_time')
                                                                <span class="badge badge-info">دوام جزئي</span>
                                                            @elseif($employee->employment_status == 'contract')
                                                                <span class="badge badge-warning">عقد مؤقت</span>
                                                            @elseif($employee->employment_status == 'intern')
                                                                <span class="badge badge-secondary">متدرب</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if($employee->status == 'active')
                                                                <span class="badge badge-success">نشط</span>
                                                            @elseif($employee->status == 'inactive')
                                                                <span class="badge badge-secondary">غير نشط</span>
                                                            @elseif($employee->status == 'on_leave')
                                                                <span class="badge badge-warning">في إجازة</span>
                                                            @elseif($employee->status == 'terminated')
                                                                <span class="badge badge-danger">منتهي الخدمة</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.3.1/dist/jspdf.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf-autotable@3.5.14/dist/jspdf.plugin.autotable.min.js"></script>

<script>
    $(document).ready(function() {
        // إعداد الرسوم البيانية
        var departmentCtx = document.getElementById('departmentChart').getContext('2d');
        var departmentChart = new Chart(departmentCtx, {
            type: 'pie',
            data: {
                labels: {!! json_encode($departmentStats->pluck('name')) !!},
                datasets: [{
                    data: {!! json_encode($departmentStats->pluck('count')) !!},
                    backgroundColor: [
                        '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#858796', '#5a5c69'
                    ],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });

        var jobTitleCtx = document.getElementById('jobTitleChart').getContext('2d');
        var jobTitleChart = new Chart(jobTitleCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($jobTitleStats->pluck('name')) !!},
                datasets: [{
                    label: 'عدد الموظفين',
                    data: {!! json_encode($jobTitleStats->pluck('count')) !!},
                    backgroundColor: '#4e73df',
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        var genderCtx = document.getElementById('genderChart').getContext('2d');
        var genderChart = new Chart(genderCtx, {
            type: 'doughnut',
            data: {
                labels: ['ذكر', 'أنثى'],
                datasets: [{
                    data: [{{ $maleCount }}, {{ $femaleCount }}],
                    backgroundColor: ['#4e73df', '#e74a3b'],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });

        var employmentStatusCtx = document.getElementById('employmentStatusChart').getContext('2d');
        var employmentStatusChart = new Chart(employmentStatusCtx, {
            type: 'pie',
            data: {
                labels: ['دوام كامل', 'دوام جزئي', 'عقد مؤقت', 'متدرب'],
                datasets: [{
                    data: [
                        {{ $employmentStatusStats['full_time'] ?? 0 }}, 
                        {{ $employmentStatusStats['part_time'] ?? 0 }}, 
                        {{ $employmentStatusStats['contract'] ?? 0 }}, 
                        {{ $employmentStatusStats['intern'] ?? 0 }}
                    ],
                    backgroundColor: ['#4e73df', '#1cc88a', '#f6c23e', '#858796'],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });

        // تصدير البيانات إلى Excel
        $('#exportExcel').click(function() {
            var wb = XLSX.utils.table_to_book(document.getElementById('employeesTable'), {sheet: "تقرير الموظفين"});
            XLSX.writeFile(wb, 'تقرير_الموظفين.xlsx');
        });

        // تصدير البيانات إلى PDF
        $('#exportPdf').click(function() {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF('l', 'mm', 'a4');
            
            // إضافة عنوان للتقرير
            doc.setFont("courier", "bold");
            doc.setFontSize(18);
            doc.text("تقرير الموظفين", doc.internal.pageSize.width / 2, 15, { align: "center" });
            
            // إضافة التاريخ
            doc.setFontSize(12);
            doc.text("تاريخ التقرير: " + new Date().toLocaleDateString('ar-SA'), doc.internal.pageSize.width - 15, 15, { align: "right" });
            
            // إضافة الجدول
            doc.autoTable({
                html: '#employeesTable',
                startY: 25,
                theme: 'grid',
                headStyles: { fillColor: [66, 135, 245], textColor: 255 },
                styles: { font: "courier", halign: "center" },
                margin: { top: 25 }
            });
            
            doc.save('تقرير_الموظفين.pdf');
        });
    });
</script>
@endpush
@endsection