@extends('layouts.modern')

@section('title', 'تقرير الحضور والانصراف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تقرير الحضور والانصراف</h3>
                    <div>
                        <button type="button" class="btn btn-success" id="exportExcel">
                            <i class="fas fa-file-excel"></i> تصدير Excel
                        </button>
                        <button type="button" class="btn btn-danger" id="exportPdf">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </button>
                        <a href="{{ route('hrm.reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتقارير
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.reports.attendance') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="department_id" class="ml-2">القسم:</label>
                                    <select name="department_id" id="department_id" class="form-control">
                                        <option value="">-- جميع الأقسام --</option>
                                        @foreach($departments as $department)
                                            <option value="{{ $department->id }}" {{ request('department_id') == $department->id ? 'selected' : '' }}>
                                                {{ $department->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="employee_id" class="ml-2">الموظف:</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">-- جميع الموظفين --</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="status" class="ml-2">الحالة:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="present" {{ request('status') == 'present' ? 'selected' : '' }}>حاضر</option>
                                        <option value="absent" {{ request('status') == 'absent' ? 'selected' : '' }}>غائب</option>
                                        <option value="late" {{ request('status') == 'late' ? 'selected' : '' }}>متأخر</option>
                                        <option value="half_day" {{ request('status') == 'half_day' ? 'selected' : '' }}>نصف يوم</option>
                                        <option value="on_leave" {{ request('status') == 'on_leave' ? 'selected' : '' }}>في إجازة</option>
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="date_from" class="ml-2">من تاريخ:</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from', $defaultDateFrom) }}">
                                </div>
                                <div class="form-group mx-1">
                                    <label for="date_to" class="ml-2">إلى تاريخ:</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to', $defaultDateTo) }}">
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.reports.attendance') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <!-- ملخص البيانات -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-user-check"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الحضور</span>
                                    <span class="info-box-number">{{ $presentCount }}</span>
                                    <span class="info-box-text">{{ number_format($presentPercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-user-times"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الغياب</span>
                                    <span class="info-box-number">{{ $absentCount }}</span>
                                    <span class="info-box-text">{{ number_format($absentPercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-user-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">التأخير</span>
                                    <span class="info-box-number">{{ $lateCount }}</span>
                                    <span class="info-box-text">{{ number_format($latePercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-calendar-minus"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">في إجازة</span>
                                    <span class="info-box-number">{{ $onLeaveCount }}</span>
                                    <span class="info-box-text">{{ number_format($onLeavePercentage, 1) }}%</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الرسوم البيانية -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توزيع حالات الحضور</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="attendanceStatusChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معدل الحضور اليومي</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="dailyAttendanceChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معدل الحضور حسب القسم</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="departmentAttendanceChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معدل التأخير (بالدقائق)</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="lateMinutesChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول البيانات -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">سجل الحضور والانصراف</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" id="attendanceTable">
                                            <thead>
                                                <tr>
                                                    <th>التاريخ</th>
                                                    <th>الموظف</th>
                                                    <th>القسم</th>
                                                    <th>وقت الحضور</th>
                                                    <th>وقت الانصراف</th>
                                                    <th>الحالة</th>
                                                    <th>دقائق التأخير</th>
                                                    <th>العمل الإضافي</th>
                                                    <th>ملاحظات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($attendanceRecords as $record)
                                                    <tr>
                                                        <td>{{ $record->date->format('Y-m-d') }}</td>
                                                        <td>
                                                            <a href="{{ route('hrm.employees.show', $record->employee->id) }}">
                                                                {{ $record->employee->first_name }} {{ $record->employee->last_name }}
                                                            </a>
                                                        </td>
                                                        <td>{{ $record->employee->department ? $record->employee->department->name : '-' }}</td>
                                                        <td>{{ $record->check_in ? $record->check_in->format('H:i') : '-' }}</td>
                                                        <td>{{ $record->check_out ? $record->check_out->format('H:i') : '-' }}</td>
                                                        <td>
                                                            @if($record->status == 'present')
                                                                <span class="badge badge-success">حاضر</span>
                                                            @elseif($record->status == 'absent')
                                                                <span class="badge badge-danger">غائب</span>
                                                            @elseif($record->status == 'late')
                                                                <span class="badge badge-warning">متأخر</span>
                                                            @elseif($record->status == 'half_day')
                                                                <span class="badge badge-info">نصف يوم</span>
                                                            @elseif($record->status == 'on_leave')
                                                                <span class="badge badge-secondary">في إجازة</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ $record->late_minutes ?: '0' }}</td>
                                                        <td>{{ $record->overtime_minutes ?: '0' }}</td>
                                                        <td>{{ Str::limit($record->notes, 30) ?: '-' }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/xlsx@0.17.0/dist/xlsx.full.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.3.1/dist/jspdf.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf-autotable@3.5.14/dist/jspdf.plugin.autotable.min.js"></script>

<script>
    $(document).ready(function() {
        // إعداد الرسوم البيانية
        var attendanceStatusCtx = document.getElementById('attendanceStatusChart').getContext('2d');
        var attendanceStatusChart = new Chart(attendanceStatusCtx, {
            type: 'pie',
            data: {
                labels: ['حاضر', 'غائب', 'متأخر', 'نصف يوم', 'في إجازة'],
                datasets: [{
                    data: [
                        {{ $presentCount }}, 
                        {{ $absentCount }}, 
                        {{ $lateCount }}, 
                        {{ $halfDayCount }}, 
                        {{ $onLeaveCount }}
                    ],
                    backgroundColor: ['#1cc88a', '#e74a3b', '#f6c23e', '#36b9cc', '#858796'],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });

        var dailyAttendanceCtx = document.getElementById('dailyAttendanceChart').getContext('2d');
        var dailyAttendanceChart = new Chart(dailyAttendanceCtx, {
            type: 'line',
            data: {
                labels: {!! json_encode($dailyStats->pluck('date')) !!},
                datasets: [{
                    label: 'نسبة الحضور',
                    data: {!! json_encode($dailyStats->pluck('percentage')) !!},
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.05)',
                    pointBackgroundColor: '#4e73df',
                    pointBorderColor: '#fff',
                    pointHoverBackgroundColor: '#fff',
                    pointHoverBorderColor: '#4e73df',
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 100,
                        ticks: {
                            callback: function(value) {
                                return value + '%';
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': ' + context.parsed.y + '%';
                            }
                        }
                    }
                }
            }
        });

        var departmentAttendanceCtx = document.getElementById('departmentAttendanceChart').getContext('2d');
        var departmentAttendanceChart = new Chart(departmentAttendanceCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($departmentStats->pluck('name')) !!},
                datasets: [{
                    label: 'نسبة الحضور',
                    data: {!! json_encode($departmentStats->pluck('percentage')) !!},
                    backgroundColor: '#4e73df',
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 100,
                        ticks: {
                            callback: function(value) {
                                return value + '%';
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': ' + context.parsed.y + '%';
                            }
                        }
                    }
                }
            }
        });

        var lateMinutesCtx = document.getElementById('lateMinutesChart').getContext('2d');
        var lateMinutesChart = new Chart(lateMinutesCtx, {
            type: 'line',
            data: {
                labels: {!! json_encode($lateStats->pluck('date')) !!},
                datasets: [{
                    label: 'متوسط دقائق التأخير',
                    data: {!! json_encode($lateStats->pluck('average')) !!},
                    borderColor: '#e74a3b',
                    backgroundColor: 'rgba(231, 74, 59, 0.05)',
                    pointBackgroundColor: '#e74a3b',
                    pointBorderColor: '#fff',
                    pointHoverBackgroundColor: '#fff',
                    pointHoverBorderColor: '#e74a3b',
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value + ' دقيقة';
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': ' + context.parsed.y + ' دقيقة';
                            }
                        }
                    }
                }
            }
        });

        // تصدير البيانات إلى Excel
        $('#exportExcel').click(function() {
            var wb = XLSX.utils.table_to_book(document.getElementById('attendanceTable'), {sheet: "تقرير الحضور"});
            XLSX.writeFile(wb, 'تقرير_الحضور_والانصراف.xlsx');
        });

        // تصدير البيانات إلى PDF
        $('#exportPdf').click(function() {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF('l', 'mm', 'a4');
            
            // إضافة عنوان للتقرير
            doc.setFont("courier", "bold");
            doc.setFontSize(18);
            doc.text("تقرير الحضور والانصراف", doc.internal.pageSize.width / 2, 15, { align: "center" });
            
            // إضافة التاريخ
            doc.setFontSize(12);
            doc.text("تاريخ التقرير: " + new Date().toLocaleDateString('ar-SA'), doc.internal.pageSize.width - 15, 15, { align: "right" });
            
            // إضافة فترة التقرير
            doc.text("الفترة: من " + $('#date_from').val() + " إلى " + $('#date_to').val(), 15, 15, { align: "left" });
            
            // إضافة الجدول
            doc.autoTable({
                html: '#attendanceTable',
                startY: 25,
                theme: 'grid',
                headStyles: { fillColor: [66, 135, 245], textColor: 255 },
                styles: { font: "courier", halign: "center" },
                margin: { top: 25 }
            });
            
            doc.save('تقرير_الحضور_والانصراف.pdf');
        });
    });
</script>
@endpush
@endsection