@extends('layouts.modern')

@section('title', 'تفاصيل كشف الرواتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل كشف الرواتب - {{ $payroll->payroll_period }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('hrm.payroll.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة إلى قائمة الرواتب
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <div class="btn-group">
                                @if ($payroll->status == 'draft')
                                    <a href="{{ route('hrm.payroll.edit', $payroll->id) }}" class="btn btn-primary">
                                        <i class="fas fa-edit"></i> تعديل
                                    </a>
                                    <a href="{{ route('hrm.payroll.generate', $payroll->id) }}" class="btn btn-success" onclick="return confirm('هل أنت متأكد من توليد الرواتب لجميع الموظفين؟')">
                                        <i class="fas fa-cogs"></i> توليد الرواتب
                                    </a>
                                    <form action="{{ route('hrm.payroll.destroy', $payroll->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف كشف الرواتب هذا؟')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">
                                            <i class="fas fa-trash"></i> حذف
                                        </button>
                                    </form>
                                @elseif ($payroll->status == 'processing')
                                    <a href="{{ route('hrm.payroll.approve', $payroll->id) }}" class="btn btn-success" onclick="return confirm('هل أنت متأكد من اعتماد كشف الرواتب هذا؟')">
                                        <i class="fas fa-check"></i> اعتماد
                                    </a>
                                    <a href="{{ route('hrm.payroll.cancel', $payroll->id) }}" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من إلغاء كشف الرواتب هذا؟')">
                                        <i class="fas fa-times"></i> إلغاء
                                    </a>
                                @elseif ($payroll->status == 'approved')
                                    <a href="{{ route('hrm.payroll.mark-as-paid', $payroll->id) }}" class="btn btn-primary" onclick="return confirm('هل أنت متأكد من تحديد كشف الرواتب هذا كمدفوع؟')">
                                        <i class="fas fa-money-bill"></i> تحديد كمدفوع
                                    </a>
                                @endif
                                
                                @if (in_array($payroll->status, ['processing', 'approved', 'paid']))
                                    <a href="{{ route('hrm.payroll.export-pdf', $payroll->id) }}" class="btn btn-info">
                                        <i class="fas fa-file-pdf"></i> تصدير PDF
                                    </a>
                                    <a href="{{ route('hrm.payroll.export-excel', $payroll->id) }}" class="btn btn-info">
                                        <i class="fas fa-file-excel"></i> تصدير Excel
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات كشف الرواتب</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الفترة</th>
                                            <td>{{ $payroll->payroll_period }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البدء</th>
                                            <td>{{ $payroll->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>{{ $payroll->end_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الدفع</th>
                                            <td>{{ $payroll->payment_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if ($payroll->status == 'draft')
                                                    <span class="badge badge-secondary">مسودة</span>
                                                @elseif ($payroll->status == 'processing')
                                                    <span class="badge badge-info">قيد المعالجة</span>
                                                @elseif ($payroll->status == 'approved')
                                                    <span class="badge badge-success">معتمد</span>
                                                @elseif ($payroll->status == 'paid')
                                                    <span class="badge badge-primary">مدفوع</span>
                                                @elseif ($payroll->status == 'cancelled')
                                                    <span class="badge badge-danger">ملغي</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $payroll->notes ?? 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">ملخص الرواتب</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 50%">إجمالي الراتب الأساسي</th>
                                            <td class="text-right">{{ number_format($payroll->total_basic_salary, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي البدلات</th>
                                            <td class="text-right">{{ number_format($payroll->total_allowances, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي الخصومات</th>
                                            <td class="text-right">{{ number_format($payroll->total_deductions, 2) }}</td>
                                        </tr>
                                        <tr class="bg-light">
                                            <th>إجمالي صافي الرواتب</th>
                                            <td class="text-right font-weight-bold">{{ number_format($payroll->total_net_salary, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>عدد الموظفين</th>
                                            <td class="text-right">{{ $payroll->payrollItems->count() }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">تفاصيل رواتب الموظفين</h5>
                                </div>
                                <div class="card-body">
                                    @if ($payroll->payrollItems->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>الرقم</th>
                                                        <th>اسم الموظف</th>
                                                        <th>الراتب الأساسي</th>
                                                        <th>البدلات</th>
                                                        <th>الخصومات</th>
                                                        <th>صافي الراتب</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($payroll->payrollItems as $item)
                                                        <tr>
                                                            <td>{{ $loop->iteration }}</td>
                                                            <td>{{ $item->employee->name }}</td>
                                                            <td>{{ number_format($item->basic_salary, 2) }}</td>
                                                            <td>{{ number_format($item->total_allowances, 2) }}</td>
                                                            <td>{{ number_format($item->total_deductions, 2) }}</td>
                                                            <td>{{ number_format($item->net_salary, 2) }}</td>
                                                            <td>
                                                                <div class="btn-group">
                                                                    <a href="{{ route('hrm.payroll.show-payslip', [$payroll->id, $item->employee_id]) }}" class="btn btn-sm btn-info">
                                                                        <i class="fas fa-eye"></i> عرض قسيمة الراتب
                                                                    </a>
                                                                    @if (in_array($payroll->status, ['processing', 'approved', 'paid']))
                                                                        <a href="{{ route('hrm.payroll.download-payslip', [$payroll->id, $item->employee_id]) }}" class="btn btn-sm btn-secondary">
                                                                            <i class="fas fa-download"></i> تنزيل
                                                                        </a>
                                                                    @endif
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> لم يتم توليد بيانات الرواتب بعد. يرجى النقر على زر "توليد الرواتب" لإنشاء بيانات الرواتب لجميع الموظفين.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection