<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف الرواتب - {{ $payroll->payroll_period }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
            direction: rtl;
        }
        
        .container {
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        
        .header h2 {
            margin: 5px 0 0;
            font-size: 18px;
            font-weight: normal;
        }
        
        .company-info {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .summary {
            margin-bottom: 30px;
        }
        
        .summary-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .summary-table th, .summary-table td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        
        .summary-table th {
            background-color: #f5f5f5;
            text-align: right;
            width: 30%;
        }
        
        .summary-table td {
            text-align: right;
        }
        
        .payroll-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .payroll-table th, .payroll-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        
        .payroll-table th {
            background-color: #f5f5f5;
        }
        
        .payroll-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .font-weight-bold {
            font-weight: bold;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>كشف الرواتب</h1>
            <h2>{{ $payroll->payroll_period }}</h2>
        </div>
        
        <div class="company-info">
            <h3>{{ $payroll->company->name ?? 'الشركة' }}</h3>
            <p>{{ $payroll->company->address ?? '' }}</p>
        </div>
        
        <div class="summary">
            <h3>ملخص كشف الرواتب</h3>
            <table class="summary-table">
                <tr>
                    <th>الفترة</th>
                    <td>{{ $payroll->payroll_period }}</td>
                </tr>
                <tr>
                    <th>تاريخ البدء</th>
                    <td>{{ $payroll->start_date->format('Y-m-d') }}</td>
                </tr>
                <tr>
                    <th>تاريخ الانتهاء</th>
                    <td>{{ $payroll->end_date->format('Y-m-d') }}</td>
                </tr>
                <tr>
                    <th>تاريخ الدفع</th>
                    <td>{{ $payroll->payment_date->format('Y-m-d') }}</td>
                </tr>
                <tr>
                    <th>الحالة</th>
                    <td>
                        @if ($payroll->status == 'draft')
                            مسودة
                        @elseif ($payroll->status == 'processing')
                            قيد المعالجة
                        @elseif ($payroll->status == 'approved')
                            معتمد
                        @elseif ($payroll->status == 'paid')
                            مدفوع
                        @elseif ($payroll->status == 'cancelled')
                            ملغي
                        @endif
                    </td>
                </tr>
                <tr>
                    <th>إجمالي الراتب الأساسي</th>
                    <td>{{ number_format($payroll->total_basic_salary, 2) }}</td>
                </tr>
                <tr>
                    <th>إجمالي البدلات</th>
                    <td>{{ number_format($payroll->total_allowances, 2) }}</td>
                </tr>
                <tr>
                    <th>إجمالي الخصومات</th>
                    <td>{{ number_format($payroll->total_deductions, 2) }}</td>
                </tr>
                <tr>
                    <th>إجمالي صافي الرواتب</th>
                    <td class="font-weight-bold">{{ number_format($payroll->total_net_salary, 2) }}</td>
                </tr>
                <tr>
                    <th>عدد الموظفين</th>
                    <td>{{ $payroll->payrollItems->count() }}</td>
                </tr>
            </table>
        </div>
        
        <h3>تفاصيل رواتب الموظفين</h3>
        <table class="payroll-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>اسم الموظف</th>
                    <th>الرقم الوظيفي</th>
                    <th>الراتب الأساسي</th>
                    <th>البدلات</th>
                    <th>الخصومات</th>
                    <th>صافي الراتب</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($payroll->payrollItems as $item)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $item->employee->name }}</td>
                        <td>{{ $item->employee->employee_id }}</td>
                        <td>{{ number_format($item->basic_salary, 2) }}</td>
                        <td>{{ number_format($item->total_allowances, 2) }}</td>
                        <td>{{ number_format($item->total_deductions, 2) }}</td>
                        <td class="font-weight-bold">{{ number_format($item->net_salary, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="3">الإجمالي</th>
                    <th>{{ number_format($payroll->total_basic_salary, 2) }}</th>
                    <th>{{ number_format($payroll->total_allowances, 2) }}</th>
                    <th>{{ number_format($payroll->total_deductions, 2) }}</th>
                    <th>{{ number_format($payroll->total_net_salary, 2) }}</th>
                </tr>
            </tfoot>
        </table>
        
        <div class="footer">
            <p>تم إنشاء هذا التقرير بواسطة نظام إدارة الموارد البشرية</p>
            <p>تاريخ الطباعة: {{ date('Y-m-d') }}</p>
        </div>
    </div>
</body>
</html>