<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>قسيمة الراتب - {{ $payroll->payroll_period }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
            direction: rtl;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        
        .header h2 {
            margin: 5px 0 0;
            font-size: 18px;
            font-weight: normal;
        }
        
        .company-info {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .row {
            display: flex;
            margin-bottom: 20px;
        }
        
        .col {
            flex: 1;
            padding: 0 10px;
        }
        
        .card {
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 15px;
        }
        
        .card-header {
            background-color: #f5f5f5;
            padding: 10px;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }
        
        .card-body {
            padding: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table, th, td {
            border: 1px solid #ddd;
        }
        
        th, td {
            padding: 8px;
            text-align: right;
        }
        
        th {
            background-color: #f5f5f5;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .font-weight-bold {
            font-weight: bold;
        }
        
        .bg-light {
            background-color: #f5f5f5;
        }
        
        .bg-primary {
            background-color: #007bff;
            color: white;
        }
        
        .net-salary {
            font-size: 20px;
            text-align: center;
            padding: 15px;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            margin-top: 15px;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>قسيمة الراتب</h1>
            <h2>{{ $payroll->payroll_period }}</h2>
        </div>
        
        <div class="company-info">
            <h3>{{ $payroll->company->name ?? 'الشركة' }}</h3>
            <p>{{ $payroll->company->address ?? '' }}</p>
        </div>
        
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">معلومات الموظف</div>
                    <div class="card-body">
                        <table>
                            <tr>
                                <th style="width: 40%">اسم الموظف</th>
                                <td>{{ $payrollItem->employee->name }}</td>
                            </tr>
                            <tr>
                                <th>الرقم الوظيفي</th>
                                <td>{{ $payrollItem->employee->employee_id }}</td>
                            </tr>
                            <tr>
                                <th>القسم</th>
                                <td>{{ $payrollItem->employee->department->name ?? 'غير محدد' }}</td>
                            </tr>
                            <tr>
                                <th>المسمى الوظيفي</th>
                                <td>{{ $payrollItem->employee->designation->name ?? 'غير محدد' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col">
                <div class="card">
                    <div class="card-header">معلومات الراتب</div>
                    <div class="card-body">
                        <table>
                            <tr>
                                <th style="width: 40%">فترة الراتب</th>
                                <td>{{ $payroll->payroll_period }}</td>
                            </tr>
                            <tr>
                                <th>تاريخ الدفع</th>
                                <td>{{ $payroll->payment_date->format('Y-m-d') }}</td>
                            </tr>
                            <tr>
                                <th>أيام العمل</th>
                                <td>{{ $payrollItem->working_days }}</td>
                            </tr>
                            <tr>
                                <th>أيام الحضور</th>
                                <td>{{ $payrollItem->working_days - $payrollItem->absent_days - $payrollItem->leave_days }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">الاستحقاقات</div>
                    <div class="card-body">
                        <table>
                            <tr>
                                <th style="width: 60%">الراتب الأساسي</th>
                                <td class="text-right">{{ number_format($payrollItem->basic_salary, 2) }}</td>
                            </tr>
                            
                            @if (is_array($payrollItem->allowances))
                                @foreach ($payrollItem->allowances as $key => $amount)
                                    @if ($amount > 0)
                                        <tr>
                                            <th>
                                                @if ($key == 'housing')
                                                    بدل سكن
                                                @elseif ($key == 'transportation')
                                                    بدل نقل
                                                @elseif ($key == 'phone')
                                                    بدل هاتف
                                                @elseif ($key == 'other')
                                                    بدلات أخرى
                                                @else
                                                    {{ $key }}
                                                @endif
                                            </th>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                            
                            @if ($payrollItem->overtime_hours > 0)
                                <tr>
                                    <th>العمل الإضافي ({{ $payrollItem->overtime_hours }} ساعة)</th>
                                    <td class="text-right">{{ number_format($payrollItem->overtime_amount, 2) }}</td>
                                </tr>
                            @endif
                            
                            <tr class="bg-light">
                                <th>إجمالي الاستحقاقات</th>
                                <td class="text-right font-weight-bold">{{ number_format($payrollItem->basic_salary + $payrollItem->total_allowances + $payrollItem->overtime_amount, 2) }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col">
                <div class="card">
                    <div class="card-header">الخصومات</div>
                    <div class="card-body">
                        <table>
                            @if (is_array($payrollItem->deductions))
                                @foreach ($payrollItem->deductions as $key => $amount)
                                    @if ($amount > 0)
                                        <tr>
                                            <th style="width: 60%">
                                                @if ($key == 'tax')
                                                    ضريبة الدخل
                                                @elseif ($key == 'insurance')
                                                    التأمينات الاجتماعية
                                                @elseif ($key == 'late')
                                                    خصم التأخير
                                                @elseif ($key == 'absence')
                                                    خصم الغياب
                                                @else
                                                    {{ $key }}
                                                @endif
                                            </th>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                            
                            <tr class="bg-light">
                                <th>إجمالي الخصومات</th>
                                <td class="text-right font-weight-bold">{{ number_format($payrollItem->total_deductions, 2) }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <div class="net-salary">
                    <div>صافي الراتب</div>
                    <div>{{ number_format($payrollItem->net_salary, 2) }}</div>
                </div>
            </div>
        </div>
        
        @if ($payrollItem->notes)
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-header">ملاحظات</div>
                        <div class="card-body">
                            {{ $payrollItem->notes }}
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <div class="footer">
            <p>هذه القسيمة تم إنشاؤها إلكترونياً ولا تحتاج إلى توقيع.</p>
            <p>تاريخ الطباعة: {{ date('Y-m-d') }}</p>
        </div>
    </div>
</body>
</html>