@extends('layouts.modern')

@section('title', 'قسيمة الراتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قسيمة الراتب - {{ $payroll->payroll_period }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('hrm.payroll.show', $payroll->id) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة إلى كشف الرواتب
                        </a>
                        @if (in_array($payroll->status, ['processing', 'approved', 'paid']))
                            <a href="{{ route('hrm.payroll.download-payslip', [$payroll->id, $payrollItem->employee_id]) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-download"></i> تنزيل قسيمة الراتب
                            </a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="payslip-container">
                                <div class="payslip-header text-center mb-4">
                                    <h2>قسيمة الراتب</h2>
                                    <h4>{{ $payroll->payroll_period }}</h4>
                                </div>
                                
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header bg-light">
                                                <h5 class="mb-0">معلومات الموظف</h5>
                                            </div>
                                            <div class="card-body">
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th style="width: 40%">اسم الموظف</th>
                                                        <td>{{ $payrollItem->employee->name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>الرقم الوظيفي</th>
                                                        <td>{{ $payrollItem->employee->employee_id }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>القسم</th>
                                                        <td>{{ $payrollItem->employee->department->name ?? 'غير محدد' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>المسمى الوظيفي</th>
                                                        <td>{{ $payrollItem->employee->designation->name ?? 'غير محدد' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header bg-light">
                                                <h5 class="mb-0">معلومات الراتب</h5>
                                            </div>
                                            <div class="card-body">
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th style="width: 40%">فترة الراتب</th>
                                                        <td>{{ $payroll->payroll_period }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>تاريخ الدفع</th>
                                                        <td>{{ $payroll->payment_date->format('Y-m-d') }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>أيام العمل</th>
                                                        <td>{{ $payrollItem->working_days }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>أيام الحضور</th>
                                                        <td>{{ $payrollItem->working_days - $payrollItem->absent_days - $payrollItem->leave_days }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header bg-light">
                                                <h5 class="mb-0">الاستحقاقات</h5>
                                            </div>
                                            <div class="card-body">
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th style="width: 60%">الراتب الأساسي</th>
                                                        <td class="text-right">{{ number_format($payrollItem->basic_salary, 2) }}</td>
                                                    </tr>
                                                    
                                                    @if (is_array($payrollItem->allowances))
                                                        @foreach ($payrollItem->allowances as $key => $amount)
                                                            @if ($amount > 0)
                                                                <tr>
                                                                    <th>
                                                                        @if ($key == 'housing')
                                                                            بدل سكن
                                                                        @elseif ($key == 'transportation')
                                                                            بدل نقل
                                                                        @elseif ($key == 'phone')
                                                                            بدل هاتف
                                                                        @elseif ($key == 'other')
                                                                            بدلات أخرى
                                                                        @else
                                                                            {{ $key }}
                                                                        @endif
                                                                    </th>
                                                                    <td class="text-right">{{ number_format($amount, 2) }}</td>
                                                                </tr>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                    
                                                    @if ($payrollItem->overtime_hours > 0)
                                                        <tr>
                                                            <th>العمل الإضافي ({{ $payrollItem->overtime_hours }} ساعة)</th>
                                                            <td class="text-right">{{ number_format($payrollItem->overtime_amount, 2) }}</td>
                                                        </tr>
                                                    @endif
                                                    
                                                    <tr class="bg-light">
                                                        <th>إجمالي الاستحقاقات</th>
                                                        <td class="text-right font-weight-bold">{{ number_format($payrollItem->basic_salary + $payrollItem->total_allowances + $payrollItem->overtime_amount, 2) }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header bg-light">
                                                <h5 class="mb-0">الخصومات</h5>
                                            </div>
                                            <div class="card-body">
                                                <table class="table table-bordered">
                                                    @if (is_array($payrollItem->deductions))
                                                        @foreach ($payrollItem->deductions as $key => $amount)
                                                            @if ($amount > 0)
                                                                <tr>
                                                                    <th style="width: 60%">
                                                                        @if ($key == 'tax')
                                                                            ضريبة الدخل
                                                                        @elseif ($key == 'insurance')
                                                                            التأمينات الاجتماعية
                                                                        @elseif ($key == 'late')
                                                                            خصم التأخير
                                                                        @elseif ($key == 'absence')
                                                                            خصم الغياب
                                                                        @else
                                                                            {{ $key }}
                                                                        @endif
                                                                    </th>
                                                                    <td class="text-right">{{ number_format($amount, 2) }}</td>
                                                                </tr>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                    
                                                    <tr class="bg-light">
                                                        <th>إجمالي الخصومات</th>
                                                        <td class="text-right font-weight-bold">{{ number_format($payrollItem->total_deductions, 2) }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        <div class="card mt-3">
                                            <div class="card-header bg-primary text-white">
                                                <h5 class="mb-0">صافي الراتب</h5>
                                            </div>
                                            <div class="card-body">
                                                <h3 class="text-center">{{ number_format($payrollItem->net_salary, 2) }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                @if ($payrollItem->notes)
                                    <div class="row mt-3">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-header bg-light">
                                                    <h5 class="mb-0">ملاحظات</h5>
                                                </div>
                                                <div class="card-body">
                                                    {{ $payrollItem->notes }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                
                                <div class="row mt-4">
                                    <div class="col-md-12">
                                        <div class="text-center">
                                            <p class="text-muted">هذه القسيمة تم إنشاؤها إلكترونياً ولا تحتاج إلى توقيع.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .payslip-container {
        padding: 20px;
        border: 1px solid #ddd;
        background-color: #fff;
    }
    
    .payslip-header {
        border-bottom: 2px solid #333;
        padding-bottom: 15px;
    }
    
    @media print {
        .card-header, .btn, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        
        .content-wrapper {
            margin-left: 0 !important;
            padding: 0 !important;
        }
        
        .payslip-container {
            border: none;
        }
    }
</style>
@endsection