@extends('layouts.modern')

@section('title', 'إدارة الرواتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إدارة الرواتب</h3>
                    <div class="card-tools">
                        <a href="{{ route('hrm.payroll.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إنشاء كشف رواتب جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.payroll.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="status" class="mx-1">الحالة:</label>
                                    <select name="status" id="status" class="form-control form-control-sm">
                                        <option value="">الكل</option>
                                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                        <option value="processing" {{ request('status') == 'processing' ? 'selected' : '' }}>قيد المعالجة</option>
                                        <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>معتمد</option>
                                        <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>مدفوع</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="month" class="mx-1">الشهر:</label>
                                    <select name="month" id="month" class="form-control form-control-sm">
                                        <option value="">الكل</option>
                                        <option value="January" {{ request('month') == 'January' ? 'selected' : '' }}>يناير</option>
                                        <option value="February" {{ request('month') == 'February' ? 'selected' : '' }}>فبراير</option>
                                        <option value="March" {{ request('month') == 'March' ? 'selected' : '' }}>مارس</option>
                                        <option value="April" {{ request('month') == 'April' ? 'selected' : '' }}>أبريل</option>
                                        <option value="May" {{ request('month') == 'May' ? 'selected' : '' }}>مايو</option>
                                        <option value="June" {{ request('month') == 'June' ? 'selected' : '' }}>يونيو</option>
                                        <option value="July" {{ request('month') == 'July' ? 'selected' : '' }}>يوليو</option>
                                        <option value="August" {{ request('month') == 'August' ? 'selected' : '' }}>أغسطس</option>
                                        <option value="September" {{ request('month') == 'September' ? 'selected' : '' }}>سبتمبر</option>
                                        <option value="October" {{ request('month') == 'October' ? 'selected' : '' }}>أكتوبر</option>
                                        <option value="November" {{ request('month') == 'November' ? 'selected' : '' }}>نوفمبر</option>
                                        <option value="December" {{ request('month') == 'December' ? 'selected' : '' }}>ديسمبر</option>
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="year" class="mx-1">السنة:</label>
                                    <select name="year" id="year" class="form-control form-control-sm">
                                        <option value="">الكل</option>
                                        @for ($i = date('Y'); $i >= date('Y') - 5; $i--)
                                            <option value="{{ $i }}" {{ request('year') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary mx-1">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                <a href="{{ route('hrm.payroll.index') }}" class="btn btn-sm btn-secondary">
                                    <i class="fas fa-sync"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الرقم</th>
                                    <th>الفترة</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>تاريخ الدفع</th>
                                    <th>الحالة</th>
                                    <th>إجمالي الراتب الأساسي</th>
                                    <th>إجمالي البدلات</th>
                                    <th>إجمالي الخصومات</th>
                                    <th>إجمالي الصافي</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($payrolls as $payroll)
                                    <tr>
                                        <td>{{ $payroll->id }}</td>
                                        <td>{{ $payroll->payroll_period }}</td>
                                        <td>{{ $payroll->start_date->format('Y-m-d') }}</td>
                                        <td>{{ $payroll->end_date->format('Y-m-d') }}</td>
                                        <td>{{ $payroll->payment_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if ($payroll->status == 'draft')
                                                <span class="badge badge-secondary">مسودة</span>
                                            @elseif ($payroll->status == 'processing')
                                                <span class="badge badge-info">قيد المعالجة</span>
                                            @elseif ($payroll->status == 'approved')
                                                <span class="badge badge-success">معتمد</span>
                                            @elseif ($payroll->status == 'paid')
                                                <span class="badge badge-primary">مدفوع</span>
                                            @elseif ($payroll->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                            @endif
                                        </td>
                                        <td>{{ number_format($payroll->total_basic_salary, 2) }}</td>
                                        <td>{{ number_format($payroll->total_allowances, 2) }}</td>
                                        <td>{{ number_format($payroll->total_deductions, 2) }}</td>
                                        <td>{{ number_format($payroll->total_net_salary, 2) }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('hrm.payroll.show', $payroll->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if ($payroll->status == 'draft')
                                                    <a href="{{ route('hrm.payroll.edit', $payroll->id) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('hrm.payroll.destroy', $payroll->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف كشف الرواتب هذا؟')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="11" class="text-center">لا توجد بيانات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $payrolls->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection