@extends('layouts.modern')

@section('title', 'تعديل كشف الرواتب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل كشف الرواتب - {{ $payroll->payroll_period }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('hrm.payroll.show', $payroll->id) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة إلى تفاصيل كشف الرواتب
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('hrm.payroll.update', $payroll->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>الفترة</label>
                                    <input type="text" class="form-control" value="{{ $payroll->payroll_period }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_date">تاريخ الدفع <span class="text-danger">*</span></label>
                                    <input type="date" name="payment_date" id="payment_date" class="form-control @error('payment_date') is-invalid @enderror" value="{{ old('payment_date', $payroll->payment_date->format('Y-m-d')) }}" required>
                                    @error('payment_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>تاريخ البدء</label>
                                    <input type="text" class="form-control" value="{{ $payroll->start_date->format('Y-m-d') }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>تاريخ الانتهاء</label>
                                    <input type="text" class="form-control" value="{{ $payroll->end_date->format('Y-m-d') }}" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $payroll->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i> يمكن تعديل كشف الرواتب فقط في حالة "مسودة". بمجرد توليد الرواتب، لن تتمكن من تعديل هذه المعلومات.
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('hrm.payroll.show', $payroll->id) }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection