@extends('layouts.modern')

@section('title', 'إنشاء كشف رواتب جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إنشاء كشف رواتب جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('hrm.payroll.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة إلى قائمة الرواتب
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('hrm.payroll.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="month">الشهر <span class="text-danger">*</span></label>
                                    <select name="month" id="month" class="form-control @error('month') is-invalid @enderror" required>
                                        @foreach ($months as $key => $month)
                                            <option value="{{ $key }}" {{ old('month', $currentMonth) == $key ? 'selected' : '' }}>{{ $month }}</option>
                                        @endforeach
                                    </select>
                                    @error('month')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="year">السنة <span class="text-danger">*</span></label>
                                    <select name="year" id="year" class="form-control @error('year') is-invalid @enderror" required>
                                        @foreach ($years as $key => $year)
                                            <option value="{{ $key }}" {{ old('year', $currentYear) == $key ? 'selected' : '' }}>{{ $year }}</option>
                                        @endforeach
                                    </select>
                                    @error('year')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_date">تاريخ الدفع <span class="text-danger">*</span></label>
                                    <input type="date" name="payment_date" id="payment_date" class="form-control @error('payment_date') is-invalid @enderror" value="{{ old('payment_date', date('Y-m-d', strtotime('last day of this month'))) }}" required>
                                    @error('payment_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i> سيتم إنشاء كشف رواتب جديد بحالة "مسودة". يمكنك بعد ذلك إضافة الموظفين وتوليد الرواتب.
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> إنشاء كشف الرواتب
                                </button>
                                <a href="{{ route('hrm.payroll.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection