@extends('layouts.modern')

@section('title', 'تفاصيل القرض')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل القرض #{{ $loan->id }}</h5>
                    <div>
                        <a href="{{ route('hrm.loans.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        
                        @if($loan->status == 'pending')
                            <a href="{{ route('hrm.loans.edit', $loan) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                        @endif
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات القرض</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">رقم القرض:</dt>
                                    <dd class="col-sm-8">{{ $loan->id }}</dd>
                                    
                                    <dt class="col-sm-4">نوع القرض:</dt>
                                    <dd class="col-sm-8">{{ $loan->loan_type_name }}</dd>
                                    
                                    <dt class="col-sm-4">مبلغ القرض:</dt>
                                    <dd class="col-sm-8">{{ number_format($loan->amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">نسبة الفائدة:</dt>
                                    <dd class="col-sm-8">{{ $loan->interest_rate }}%</dd>
                                    
                                    <dt class="col-sm-4">مبلغ الفائدة:</dt>
                                    <dd class="col-sm-8">{{ number_format($loan->interest_amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">المبلغ الإجمالي:</dt>
                                    <dd class="col-sm-8">{{ number_format($loan->total_amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">عدد الأقساط:</dt>
                                    <dd class="col-sm-8">{{ $loan->installment_count }}</dd>
                                    
                                    <dt class="col-sm-4">الأقساط المتبقية:</dt>
                                    <dd class="col-sm-8">{{ $loan->remaining_installments }}</dd>
                                    
                                    <dt class="col-sm-4">مبلغ القسط:</dt>
                                    <dd class="col-sm-8">{{ number_format($loan->installment_amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">تاريخ البدء:</dt>
                                    <dd class="col-sm-8">{{ $loan->start_date->format('Y-m-d') }}</dd>
                                    
                                    <dt class="col-sm-4">تاريخ الانتهاء:</dt>
                                    <dd class="col-sm-8">{{ $loan->end_date->format('Y-m-d') }}</dd>
                                    
                                    <dt class="col-sm-4">الوصف:</dt>
                                    <dd class="col-sm-8">{{ $loan->description }}</dd>
                                    
                                    <dt class="col-sm-4">الحالة:</dt>
                                    <dd class="col-sm-8">
                                        @if($loan->status == 'pending')
                                            <span class="badge bg-warning text-dark">{{ $loan->status_name }}</span>
                                        @elseif($loan->status == 'approved')
                                            <span class="badge bg-success">{{ $loan->status_name }}</span>
                                        @elseif($loan->status == 'rejected')
                                            <span class="badge bg-danger">{{ $loan->status_name }}</span>
                                        @elseif($loan->status == 'active')
                                            <span class="badge bg-primary">{{ $loan->status_name }}</span>
                                        @elseif($loan->status == 'completed')
                                            <span class="badge bg-info">{{ $loan->status_name }}</span>
                                        @elseif($loan->status == 'cancelled')
                                            <span class="badge bg-secondary">{{ $loan->status_name }}</span>
                                        @endif
                                    </dd>
                                    
                                    @if($loan->notes)
                                        <dt class="col-sm-4">ملاحظات:</dt>
                                        <dd class="col-sm-8">{{ $loan->notes }}</dd>
                                    @endif
                                </dl>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات الموظف</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">اسم الموظف:</dt>
                                    <dd class="col-sm-8">
                                        <a href="{{ route('hrm.employees.show', $loan->employee_id) }}">
                                            {{ $loan->employee->full_name }}
                                        </a>
                                    </dd>
                                    
                                    <dt class="col-sm-4">الرقم الوظيفي:</dt>
                                    <dd class="col-sm-8">{{ $loan->employee->employee_number }}</dd>
                                    
                                    <dt class="col-sm-4">القسم:</dt>
                                    <dd class="col-sm-8">{{ $loan->employee->department->name ?? 'غير محدد' }}</dd>
                                    
                                    <dt class="col-sm-4">المسمى الوظيفي:</dt>
                                    <dd class="col-sm-8">{{ $loan->employee->jobTitle->name ?? 'غير محدد' }}</dd>
                                </dl>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات إضافية</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">تاريخ الإنشاء:</dt>
                                    <dd class="col-sm-8">{{ $loan->created_at->format('Y-m-d H:i') }}</dd>
                                    
                                    <dt class="col-sm-4">بواسطة:</dt>
                                    <dd class="col-sm-8">{{ $loan->creator->name ?? 'غير محدد' }}</dd>
                                    
                                    @if($loan->approved_by)
                                        <dt class="col-sm-4">تمت الموافقة بواسطة:</dt>
                                        <dd class="col-sm-8">{{ $loan->approver->name ?? 'غير محدد' }}</dd>
                                        
                                        <dt class="col-sm-4">تاريخ الموافقة:</dt>
                                        <dd class="col-sm-8">{{ $loan->approved_at ? $loan->approved_at->format('Y-m-d H:i') : 'غير محدد' }}</dd>
                                    @endif
                                </dl>
                            </div>
                        </div>
                    </div>
                    
                    <!-- جدول الأقساط -->
                    <div class="mt-4">
                        <h6 class="fw-bold">جدول الأقساط</h6>
                        <hr>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم القسط</th>
                                        <th>المبلغ</th>
                                        <th>تاريخ الاستحقاق</th>
                                        <th>تاريخ الدفع</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($installments as $installment)
                                        <tr>
                                            <td>{{ $installment->id }}</td>
                                            <td>{{ $installment->installment_number }}</td>
                                            <td>{{ number_format($installment->amount, 2) }}</td>
                                            <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                            <td>{{ $installment->payment_date ? $installment->payment_date->format('Y-m-d') : '-' }}</td>
                                            <td>
                                                @if($installment->status == 'pending')
                                                    <span class="badge bg-warning text-dark">{{ $installment->status_name }}</span>
                                                @elseif($installment->status == 'paid')
                                                    <span class="badge bg-success">{{ $installment->status_name }}</span>
                                                @elseif($installment->status == 'overdue')
                                                    <span class="badge bg-danger">{{ $installment->status_name }}</span>
                                                @elseif($installment->status == 'cancelled')
                                                    <span class="badge bg-secondary">{{ $installment->status_name }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('hrm.loan-installments.show', $installment) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    
                                                    @if($installment->status == 'pending' || $installment->status == 'overdue')
                                                        <a href="#" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#markAsPaidModal{{ $installment->id }}">
                                                            <i class="fas fa-check"></i>
                                                        </a>
                                                        
                                                        @if($installment->status == 'pending')
                                                            <form action="{{ route('hrm.loan-installments.mark-as-overdue', $installment) }}" method="POST" class="d-inline">
                                                                @csrf
                                                                <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('هل أنت متأكد من تحديد هذا القسط كمتأخر؟')">
                                                                    <i class="fas fa-exclamation-triangle"></i>
                                                                </button>
                                                            </form>
                                                        @endif
                                                        
                                                        <a href="#" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#cancelInstallmentModal{{ $installment->id }}">
                                                            <i class="fas fa-times"></i>
                                                        </a>
                                                    @endif
                                                </div>
                                                
                                                <!-- Modal تسجيل دفع القسط -->
                                                <div class="modal fade" id="markAsPaidModal{{ $installment->id }}" tabindex="-1" aria-labelledby="markAsPaidModalLabel{{ $installment->id }}" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <form action="{{ route('hrm.loan-installments.mark-as-paid', $installment) }}" method="POST">
                                                                @csrf
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="markAsPaidModalLabel{{ $installment->id }}">تسجيل دفع القسط #{{ $installment->installment_number }}</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="mb-3">
                                                                        <label for="payment_date{{ $installment->id }}" class="form-label">تاريخ الدفع <span class="text-danger">*</span></label>
                                                                        <input type="date" name="payment_date" id="payment_date{{ $installment->id }}" class="form-control" value="{{ date('Y-m-d') }}" required>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="notes{{ $installment->id }}" class="form-label">ملاحظات</label>
                                                                        <textarea name="notes" id="notes{{ $installment->id }}" class="form-control" rows="3"></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-success">تأكيد الدفع</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- Modal إلغاء القسط -->
                                                <div class="modal fade" id="cancelInstallmentModal{{ $installment->id }}" tabindex="-1" aria-labelledby="cancelInstallmentModalLabel{{ $installment->id }}" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <form action="{{ route('hrm.loan-installments.cancel', $installment) }}" method="POST">
                                                                @csrf
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="cancelInstallmentModalLabel{{ $installment->id }}">إلغاء القسط #{{ $installment->installment_number }}</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="mb-3">
                                                                        <label for="cancellation_reason{{ $installment->id }}" class="form-label">سبب الإلغاء <span class="text-danger">*</span></label>
                                                                        <textarea name="cancellation_reason" id="cancellation_reason{{ $installment->id }}" class="form-control" rows="3" required></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">لا توجد أقساط</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <!-- أزرار الإجراءات -->
                    <div class="mt-4 border-top pt-4">
                        <div class="d-flex justify-content-between">
                            <div>
                                @if($loan->status == 'pending')
                                    <form action="{{ route('hrm.loans.destroy', $loan) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا القرض؟')">
                                            <i class="fas fa-trash"></i> حذف القرض
                                        </button>
                                    </form>
                                @endif
                            </div>
                            
                            <div>
                                @if($loan->status == 'pending')
                                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                        <i class="fas fa-times"></i> رفض
                                    </button>
                                    
                                    <form action="{{ route('hrm.loans.approve', $loan) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-success" onclick="return confirm('هل أنت متأكد من الموافقة على هذا القرض؟')">
                                            <i class="fas fa-check"></i> موافقة
                                        </button>
                                    </form>
                                @elseif($loan->status == 'approved')
                                    <form action="{{ route('hrm.loans.activate', $loan) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-primary" onclick="return confirm('هل أنت متأكد من تنشيط هذا القرض؟')">
                                            <i class="fas fa-play"></i> تنشيط
                                        </button>
                                    </form>
                                    
                                    <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#cancelModal">
                                        <i class="fas fa-ban"></i> إلغاء
                                    </button>
                                @elseif($loan->status == 'active')
                                    <form action="{{ route('hrm.loans.complete', $loan) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-info" onclick="return confirm('هل أنت متأكد من إكمال هذا القرض؟')">
                                            <i class="fas fa-check-circle"></i> إكمال
                                        </button>
                                    </form>
                                    
                                    <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#cancelModal">
                                        <i class="fas fa-ban"></i> إلغاء
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal رفض القرض -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('hrm.loans.reject', $loan) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">رفض القرض</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="rejection_reason" class="form-label">سبب الرفض <span class="text-danger">*</span></label>
                        <textarea name="rejection_reason" id="rejection_reason" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الرفض</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal إلغاء القرض -->
<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('hrm.loans.cancel', $loan) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="cancelModalLabel">إلغاء القرض</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="cancellation_reason" class="form-label">سبب الإلغاء <span class="text-danger">*</span></label>
                        <textarea name="cancellation_reason" id="cancellation_reason" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection