@extends('layouts.modern')

@section('title', 'إدارة القروض')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إدارة القروض</h5>
                    <a href="{{ route('hrm.loans.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> إضافة قرض جديد
                    </a>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0">فلترة النتائج</h6>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('hrm.loans.index') }}" method="GET" class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="employee_id">الموظف</label>
                                    <select name="employee_id" id="employee_id" class="form-control select2">
                                        <option value="">جميع الموظفين</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->full_name }} ({{ $employee->employee_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="loan_type">نوع القرض</label>
                                    <select name="loan_type" id="loan_type" class="form-control">
                                        <option value="">جميع الأنواع</option>
                                        @foreach($loanTypes as $key => $value)
                                            <option value="{{ $key }}" {{ request('loan_type') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">جميع الحالات</option>
                                        @foreach($statuses as $key => $value)
                                            <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="start_date_from">من تاريخ</label>
                                    <input type="date" name="start_date_from" id="start_date_from" class="form-control" value="{{ request('start_date_from') }}">
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="start_date_to">إلى تاريخ</label>
                                    <input type="date" name="start_date_to" id="start_date_to" class="form-control" value="{{ request('start_date_to') }}">
                                </div>
                                <div class="col-md-1 mb-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- جدول القروض -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>نوع القرض</th>
                                    <th>المبلغ</th>
                                    <th>الفائدة</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>عدد الأقساط</th>
                                    <th>الأقساط المتبقية</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loans as $loan)
                                    <tr>
                                        <td>{{ $loan->id }}</td>
                                        <td>
                                            <a href="{{ route('hrm.employees.show', $loan->employee_id) }}">
                                                {{ $loan->employee->full_name }}
                                            </a>
                                            <div class="small text-muted">{{ $loan->employee->employee_number }}</div>
                                        </td>
                                        <td>{{ $loan->loan_type_name }}</td>
                                        <td>{{ number_format($loan->amount, 2) }}</td>
                                        <td>{{ $loan->interest_rate }}% ({{ number_format($loan->interest_amount, 2) }})</td>
                                        <td>{{ number_format($loan->total_amount, 2) }}</td>
                                        <td>{{ $loan->installment_count }}</td>
                                        <td>{{ $loan->remaining_installments }}</td>
                                        <td>{{ $loan->start_date->format('Y-m-d') }}</td>
                                        <td>{{ $loan->end_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($loan->status == 'pending')
                                                <span class="badge bg-warning text-dark">{{ $loan->status_name }}</span>
                                            @elseif($loan->status == 'approved')
                                                <span class="badge bg-success">{{ $loan->status_name }}</span>
                                            @elseif($loan->status == 'rejected')
                                                <span class="badge bg-danger">{{ $loan->status_name }}</span>
                                            @elseif($loan->status == 'active')
                                                <span class="badge bg-primary">{{ $loan->status_name }}</span>
                                            @elseif($loan->status == 'completed')
                                                <span class="badge bg-info">{{ $loan->status_name }}</span>
                                            @elseif($loan->status == 'cancelled')
                                                <span class="badge bg-secondary">{{ $loan->status_name }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.loans.show', $loan) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                
                                                @if($loan->status == 'pending')
                                                    <a href="{{ route('hrm.loans.edit', $loan) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    
                                                    <form action="{{ route('hrm.loans.destroy', $loan) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا القرض؟')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="12" class="text-center">لا توجد قروض</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- ترقيم الصفحات -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $loans->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
    });
</script>
@endpush