@extends('layouts.modern')

@section('title', 'تعديل القرض')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تعديل القرض #{{ $loan->id }}</h5>
                    <div>
                        <a href="{{ route('hrm.loans.show', $loan) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> عرض
                        </a>
                        <a href="{{ route('hrm.loans.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('hrm.loans.update', $loan) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="employee_id" class="form-label">الموظف <span class="text-danger">*</span></label>
                                <select name="employee_id" id="employee_id" class="form-control select2 @error('employee_id') is-invalid @enderror" required>
                                    <option value="">اختر الموظف</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ old('employee_id', $loan->employee_id) == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->full_name }} ({{ $employee->employee_number }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="loan_type" class="form-label">نوع القرض <span class="text-danger">*</span></label>
                                <select name="loan_type" id="loan_type" class="form-control @error('loan_type') is-invalid @enderror" required>
                                    <option value="">اختر نوع القرض</option>
                                    @foreach($loanTypes as $key => $value)
                                        <option value="{{ $key }}" {{ old('loan_type', $loan->loan_type) == $key ? 'selected' : '' }}>
                                            {{ $value }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('loan_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="amount" class="form-label">مبلغ القرض <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" step="0.01" min="0" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount', $loan->amount) }}" required>
                                    <span class="input-group-text">ريال</span>
                                </div>
                                @error('amount')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="interest_rate" class="form-label">نسبة الفائدة <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" step="0.01" min="0" max="100" name="interest_rate" id="interest_rate" class="form-control @error('interest_rate') is-invalid @enderror" value="{{ old('interest_rate', $loan->interest_rate) }}" required>
                                    <span class="input-group-text">%</span>
                                </div>
                                @error('interest_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="installment_count" class="form-label">عدد الأقساط <span class="text-danger">*</span></label>
                                <input type="number" min="1" name="installment_count" id="installment_count" class="form-control @error('installment_count') is-invalid @enderror" value="{{ old('installment_count', $loan->installment_count) }}" required>
                                @error('installment_count')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date', $loan->start_date->format('Y-m-d')) }}" required>
                                @error('start_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف <span class="text-danger">*</span></label>
                            <input type="text" name="description" id="description" class="form-control @error('description') is-invalid @enderror" value="{{ old('description', $loan->description) }}" required>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $loan->notes) }}</textarea>
                            @error('notes')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
        
        // حساب مبلغ القسط عند تغيير المبلغ أو نسبة الفائدة أو عدد الأقساط
        $('#amount, #interest_rate, #installment_count').on('change', function() {
            calculateInstallmentAmount();
        });
        
        // حساب مبلغ القسط عند تحميل الصفحة
        calculateInstallmentAmount();
        
        function calculateInstallmentAmount() {
            var amount = parseFloat($('#amount').val()) || 0;
            var interestRate = parseFloat($('#interest_rate').val()) || 0;
            var installmentCount = parseInt($('#installment_count').val()) || 1;
            
            var interestAmount = amount * (interestRate / 100);
            var totalAmount = amount + interestAmount;
            var installmentAmount = totalAmount / installmentCount;
            
            // عرض معلومات القرض
            var loanInfo = 'مبلغ القرض: ' + amount.toFixed(2) + ' ريال<br>';
            loanInfo += 'مبلغ الفائدة: ' + interestAmount.toFixed(2) + ' ريال<br>';
            loanInfo += 'المبلغ الإجمالي: ' + totalAmount.toFixed(2) + ' ريال<br>';
            loanInfo += 'مبلغ القسط الشهري: ' + installmentAmount.toFixed(2) + ' ريال';
            
            // إذا لم يكن هناك عنصر لعرض معلومات القرض، قم بإنشائه
            if ($('#loan-info').length === 0) {
                $('<div id="loan-info" class="alert alert-info mt-3"></div>').insertAfter('#installment_count');
            }
            
            $('#loan-info').html(loanInfo);
        }
    });
</script>
@endpush