@extends('layouts.modern')

@section('title', 'تفاصيل قسط القرض')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل قسط القرض #{{ $installment->id }}</h5>
                    <div>
                        <a href="{{ route('hrm.loans.show', $installment->loan_id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-arrow-right"></i> عرض القرض
                        </a>
                        <a href="{{ route('hrm.loan-installments.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات القسط</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">رقم القسط:</dt>
                                    <dd class="col-sm-8">{{ $installment->installment_number }}</dd>
                                    
                                    <dt class="col-sm-4">المبلغ:</dt>
                                    <dd class="col-sm-8">{{ number_format($installment->amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">تاريخ الاستحقاق:</dt>
                                    <dd class="col-sm-8">{{ $installment->due_date->format('Y-m-d') }}</dd>
                                    
                                    <dt class="col-sm-4">تاريخ الدفع:</dt>
                                    <dd class="col-sm-8">{{ $installment->payment_date ? $installment->payment_date->format('Y-m-d') : 'لم يتم الدفع بعد' }}</dd>
                                    
                                    <dt class="col-sm-4">الحالة:</dt>
                                    <dd class="col-sm-8">
                                        @if($installment->status == 'pending')
                                            <span class="badge bg-warning text-dark">{{ $installment->status_name }}</span>
                                        @elseif($installment->status == 'paid')
                                            <span class="badge bg-success">{{ $installment->status_name }}</span>
                                        @elseif($installment->status == 'overdue')
                                            <span class="badge bg-danger">{{ $installment->status_name }}</span>
                                        @elseif($installment->status == 'cancelled')
                                            <span class="badge bg-secondary">{{ $installment->status_name }}</span>
                                        @endif
                                    </dd>
                                    
                                    @if($installment->notes)
                                        <dt class="col-sm-4">ملاحظات:</dt>
                                        <dd class="col-sm-8">{{ $installment->notes }}</dd>
                                    @endif
                                    
                                    @if($installment->cancellation_reason)
                                        <dt class="col-sm-4">سبب الإلغاء:</dt>
                                        <dd class="col-sm-8">{{ $installment->cancellation_reason }}</dd>
                                    @endif
                                </dl>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات القرض</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">رقم القرض:</dt>
                                    <dd class="col-sm-8">
                                        <a href="{{ route('hrm.loans.show', $installment->loan_id) }}">
                                            #{{ $installment->loan_id }}
                                        </a>
                                    </dd>
                                    
                                    <dt class="col-sm-4">نوع القرض:</dt>
                                    <dd class="col-sm-8">{{ $installment->loan->loan_type_name }}</dd>
                                    
                                    <dt class="col-sm-4">مبلغ القرض:</dt>
                                    <dd class="col-sm-8">{{ number_format($installment->loan->amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">المبلغ الإجمالي:</dt>
                                    <dd class="col-sm-8">{{ number_format($installment->loan->total_amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">عدد الأقساط:</dt>
                                    <dd class="col-sm-8">{{ $installment->loan->installment_count }}</dd>
                                    
                                    <dt class="col-sm-4">الأقساط المتبقية:</dt>
                                    <dd class="col-sm-8">{{ $installment->loan->remaining_installments }}</dd>
                                    
                                    <dt class="col-sm-4">حالة القرض:</dt>
                                    <dd class="col-sm-8">
                                        @if($installment->loan->status == 'pending')
                                            <span class="badge bg-warning text-dark">{{ $installment->loan->status_name }}</span>
                                        @elseif($installment->loan->status == 'approved')
                                            <span class="badge bg-success">{{ $installment->loan->status_name }}</span>
                                        @elseif($installment->loan->status == 'rejected')
                                            <span class="badge bg-danger">{{ $installment->loan->status_name }}</span>
                                        @elseif($installment->loan->status == 'active')
                                            <span class="badge bg-primary">{{ $installment->loan->status_name }}</span>
                                        @elseif($installment->loan->status == 'completed')
                                            <span class="badge bg-info">{{ $installment->loan->status_name }}</span>
                                        @elseif($installment->loan->status == 'cancelled')
                                            <span class="badge bg-secondary">{{ $installment->loan->status_name }}</span>
                                        @endif
                                    </dd>
                                </dl>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات الموظف</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">اسم الموظف:</dt>
                                    <dd class="col-sm-8">
                                        <a href="{{ route('hrm.employees.show', $installment->loan->employee_id) }}">
                                            {{ $installment->loan->employee->full_name }}
                                        </a>
                                    </dd>
                                    
                                    <dt class="col-sm-4">الرقم الوظيفي:</dt>
                                    <dd class="col-sm-8">{{ $installment->loan->employee->employee_number }}</dd>
                                    
                                    <dt class="col-sm-4">القسم:</dt>
                                    <dd class="col-sm-8">{{ $installment->loan->employee->department->name ?? 'غير محدد' }}</dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    
                    <!-- أزرار الإجراءات -->
                    @if($installment->status == 'pending' || $installment->status == 'overdue')
                    <div class="mt-4 border-top pt-4">
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-danger me-2" data-bs-toggle="modal" data-bs-target="#cancelInstallmentModal">
                                <i class="fas fa-times"></i> إلغاء القسط
                            </button>
                            
                            @if($installment->status == 'pending')
                            <form action="{{ route('hrm.loan-installments.mark-as-overdue', $installment) }}" method="POST" class="me-2">
                                @csrf
                                <button type="submit" class="btn btn-warning" onclick="return confirm('هل أنت متأكد من تحديد هذا القسط كمتأخر؟')">
                                    <i class="fas fa-exclamation-triangle"></i> تحديد كمتأخر
                                </button>
                            </form>
                            @endif
                            
                            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#markAsPaidModal">
                                <i class="fas fa-check"></i> تسجيل الدفع
                            </button>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal تسجيل دفع القسط -->
<div class="modal fade" id="markAsPaidModal" tabindex="-1" aria-labelledby="markAsPaidModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('hrm.loan-installments.mark-as-paid', $installment) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="markAsPaidModalLabel">تسجيل دفع القسط #{{ $installment->installment_number }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">تاريخ الدفع <span class="text-danger">*</span></label>
                        <input type="date" name="payment_date" id="payment_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea name="notes" id="notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">تأكيد الدفع</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal إلغاء القسط -->
<div class="modal fade" id="cancelInstallmentModal" tabindex="-1" aria-labelledby="cancelInstallmentModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('hrm.loan-installments.cancel', $installment) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="cancelInstallmentModalLabel">إلغاء القسط #{{ $installment->installment_number }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="cancellation_reason" class="form-label">سبب الإلغاء <span class="text-danger">*</span></label>
                        <textarea name="cancellation_reason" id="cancellation_reason" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection