@extends('layouts.modern')

@section('title', 'إدارة أقساط القروض')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إدارة أقساط القروض</h5>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0">فلترة النتائج</h6>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('hrm.loan-installments.index') }}" method="GET" class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="employee_id">الموظف</label>
                                    <select name="employee_id" id="employee_id" class="form-control select2">
                                        <option value="">جميع الموظفين</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->full_name }} ({{ $employee->employee_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="loan_id">القرض</label>
                                    <select name="loan_id" id="loan_id" class="form-control select2">
                                        <option value="">جميع القروض</option>
                                        @foreach($loans as $loan)
                                            <option value="{{ $loan->id }}" {{ request('loan_id') == $loan->id ? 'selected' : '' }}>
                                                #{{ $loan->id }} - {{ $loan->employee->full_name }} ({{ number_format($loan->amount, 2) }} ريال)
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">جميع الحالات</option>
                                        @foreach($statuses as $key => $value)
                                            <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="due_date_from">من تاريخ الاستحقاق</label>
                                    <input type="date" name="due_date_from" id="due_date_from" class="form-control" value="{{ request('due_date_from') }}">
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="due_date_to">إلى تاريخ الاستحقاق</label>
                                    <input type="date" name="due_date_to" id="due_date_to" class="form-control" value="{{ request('due_date_to') }}">
                                </div>
                                <div class="col-md-12 mb-3 d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- جدول أقساط القروض -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>القرض</th>
                                    <th>رقم القسط</th>
                                    <th>المبلغ</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>تاريخ الدفع</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($installments as $installment)
                                    <tr>
                                        <td>{{ $installment->id }}</td>
                                        <td>
                                            <a href="{{ route('hrm.employees.show', $installment->loan->employee_id) }}">
                                                {{ $installment->loan->employee->full_name }}
                                            </a>
                                            <div class="small text-muted">{{ $installment->loan->employee->employee_number }}</div>
                                        </td>
                                        <td>
                                            <a href="{{ route('hrm.loans.show', $installment->loan_id) }}">
                                                #{{ $installment->loan_id }}
                                            </a>
                                            <div class="small text-muted">{{ $installment->loan->loan_type_name }}</div>
                                        </td>
                                        <td>{{ $installment->installment_number }}</td>
                                        <td>{{ number_format($installment->amount, 2) }}</td>
                                        <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                        <td>{{ $installment->payment_date ? $installment->payment_date->format('Y-m-d') : '-' }}</td>
                                        <td>
                                            @if($installment->status == 'pending')
                                                <span class="badge bg-warning text-dark">{{ $installment->status_name }}</span>
                                            @elseif($installment->status == 'paid')
                                                <span class="badge bg-success">{{ $installment->status_name }}</span>
                                            @elseif($installment->status == 'overdue')
                                                <span class="badge bg-danger">{{ $installment->status_name }}</span>
                                            @elseif($installment->status == 'cancelled')
                                                <span class="badge bg-secondary">{{ $installment->status_name }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.loan-installments.show', $installment) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                
                                                @if($installment->status == 'pending' || $installment->status == 'overdue')
                                                    <a href="#" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#markAsPaidModal{{ $installment->id }}">
                                                        <i class="fas fa-check"></i>
                                                    </a>
                                                    
                                                    @if($installment->status == 'pending')
                                                        <form action="{{ route('hrm.loan-installments.mark-as-overdue', $installment) }}" method="POST" class="d-inline">
                                                            @csrf
                                                            <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('هل أنت متأكد من تحديد هذا القسط كمتأخر؟')">
                                                                <i class="fas fa-exclamation-triangle"></i>
                                                            </button>
                                                        </form>
                                                    @endif
                                                    
                                                    <a href="#" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#cancelInstallmentModal{{ $installment->id }}">
                                                        <i class="fas fa-times"></i>
                                                    </a>
                                                @endif
                                            </div>
                                            
                                            <!-- Modal تسجيل دفع القسط -->
                                            <div class="modal fade" id="markAsPaidModal{{ $installment->id }}" tabindex="-1" aria-labelledby="markAsPaidModalLabel{{ $installment->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <form action="{{ route('hrm.loan-installments.mark-as-paid', $installment) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="markAsPaidModalLabel{{ $installment->id }}">تسجيل دفع القسط #{{ $installment->installment_number }}</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <label for="payment_date{{ $installment->id }}" class="form-label">تاريخ الدفع <span class="text-danger">*</span></label>
                                                                    <input type="date" name="payment_date" id="payment_date{{ $installment->id }}" class="form-control" value="{{ date('Y-m-d') }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="notes{{ $installment->id }}" class="form-label">ملاحظات</label>
                                                                    <textarea name="notes" id="notes{{ $installment->id }}" class="form-control" rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-success">تأكيد الدفع</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Modal إلغاء القسط -->
                                            <div class="modal fade" id="cancelInstallmentModal{{ $installment->id }}" tabindex="-1" aria-labelledby="cancelInstallmentModalLabel{{ $installment->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <form action="{{ route('hrm.loan-installments.cancel', $installment) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="cancelInstallmentModalLabel{{ $installment->id }}">إلغاء القسط #{{ $installment->installment_number }}</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="mb-3">
                                                                    <label for="cancellation_reason{{ $installment->id }}" class="form-label">سبب الإلغاء <span class="text-danger">*</span></label>
                                                                    <textarea name="cancellation_reason" id="cancellation_reason{{ $installment->id }}" class="form-control" rows="3" required></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد أقساط</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- ترقيم الصفحات -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $installments->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
    });
</script>
@endpush