@extends('layouts.modern')

@section('title', 'تفاصيل طلب الإجازة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل طلب الإجازة #{{ $leave->id }}</h3>
                    <div>
                        @if($leave->status == 'pending')
                            <a href="{{ route('hrm.leaves.edit', $leave->id) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <button type="button" class="btn btn-success" data-toggle="modal" data-target="#approveModal">
                                <i class="fas fa-check"></i> موافقة
                            </button>
                            <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#rejectModal">
                                <i class="fas fa-times"></i> رفض
                            </button>
                        @endif
                        <a href="{{ route('hrm.leaves.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">معلومات الطلب</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الطلب</th>
                                            <td>{{ $leave->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الإجازة</th>
                                            <td>{{ $leave->leaveType->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البداية</th>
                                            <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ النهاية</th>
                                            <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>عدد الأيام</th>
                                            <td>{{ $leave->total_days }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($leave->status == 'pending')
                                                    <span class="badge badge-warning">قيد الانتظار</span>
                                                @elseif($leave->status == 'approved')
                                                    <span class="badge badge-success">موافق عليها</span>
                                                @elseif($leave->status == 'rejected')
                                                    <span class="badge badge-danger">مرفوضة</span>
                                                @elseif($leave->status == 'cancelled')
                                                    <span class="badge badge-secondary">ملغاة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الطلب</th>
                                            <td>{{ $leave->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $leave->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">معلومات الموظف</h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center mb-3">
                                        @if($leave->employee->profile_picture)
                                            <img src="{{ asset('storage/' . $leave->employee->profile_picture) }}" alt="Profile Picture" class="img-circle" style="width: 100px; height: 100px;">
                                        @else
                                            <img src="{{ asset('images/default-avatar.png') }}" alt="Default Avatar" class="img-circle" style="width: 100px; height: 100px;">
                                        @endif
                                    </div>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم الموظف</th>
                                            <td>
                                                <a href="{{ route('hrm.employees.show', $leave->employee->id) }}">
                                                    {{ $leave->employee->first_name }} {{ $leave->employee->last_name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>رقم الموظف</th>
                                            <td>{{ $leave->employee->employee_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>القسم</th>
                                            <td>{{ $leave->employee->department ? $leave->employee->department->name : '-' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المسمى الوظيفي</th>
                                            <td>{{ $leave->employee->jobTitle ? $leave->employee->jobTitle->name : '-' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التعيين</th>
                                            <td>{{ $leave->employee->join_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>رصيد الإجازات</th>
                                            <td>
                                                @if($leaveBalance)
                                                    {{ $leaveBalance->balance }} يوم
                                                @else
                                                    -
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="card-title">تفاصيل الطلب</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h6>سبب الإجازة:</h6>
                                            <p class="p-2 bg-light rounded">{{ $leave->reason ?: 'لا يوجد سبب مذكور' }}</p>
                                        </div>
                                        
                                        @if($leave->admin_notes)
                                            <div class="col-md-12 mt-3">
                                                <h6>ملاحظات الإدارة:</h6>
                                                <p class="p-2 bg-light rounded">{{ $leave->admin_notes }}</p>
                                            </div>
                                        @endif
                                        
                                        @if($leave->attachment)
                                            <div class="col-md-12 mt-3">
                                                <h6>المرفقات:</h6>
                                                <div class="p-2 bg-light rounded">
                                                    <a href="{{ asset('storage/' . $leave->attachment) }}" class="btn btn-sm btn-info" target="_blank">
                                                        <i class="fas fa-eye"></i> عرض المرفق
                                                    </a>
                                                    <a href="{{ asset('storage/' . $leave->attachment) }}" class="btn btn-sm btn-success" download>
                                                        <i class="fas fa-download"></i> تحميل المرفق
                                                    </a>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- سجل الإجراءات -->
                    @if($leave->leaveActions && $leave->leaveActions->count() > 0)
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header bg-light">
                                        <h5 class="card-title">سجل الإجراءات</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="timeline">
                                            @foreach($leave->leaveActions as $action)
                                                <div class="time-label">
                                                    <span class="bg-secondary">{{ $action->created_at->format('Y-m-d') }}</span>
                                                </div>
                                                <div>
                                                    @if($action->action == 'created')
                                                        <i class="fas fa-plus bg-info"></i>
                                                    @elseif($action->action == 'updated')
                                                        <i class="fas fa-edit bg-primary"></i>
                                                    @elseif($action->action == 'approved')
                                                        <i class="fas fa-check bg-success"></i>
                                                    @elseif($action->action == 'rejected')
                                                        <i class="fas fa-times bg-danger"></i>
                                                    @elseif($action->action == 'cancelled')
                                                        <i class="fas fa-ban bg-secondary"></i>
                                                    @endif
                                                    <div class="timeline-item">
                                                        <span class="time"><i class="fas fa-clock"></i> {{ $action->created_at->format('H:i') }}</span>
                                                        <h3 class="timeline-header">
                                                            @if($action->action == 'created')
                                                                تم إنشاء الطلب
                                                            @elseif($action->action == 'updated')
                                                                تم تحديث الطلب
                                                            @elseif($action->action == 'approved')
                                                                تمت الموافقة على الطلب
                                                            @elseif($action->action == 'rejected')
                                                                تم رفض الطلب
                                                            @elseif($action->action == 'cancelled')
                                                                تم إلغاء الطلب
                                                            @endif
                                                            بواسطة {{ $action->user ? $action->user->name : 'النظام' }}
                                                        </h3>
                                                        @if($action->notes)
                                                            <div class="timeline-body">
                                                                {{ $action->notes }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endforeach
                                            <div>
                                                <i class="fas fa-clock bg-gray"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1" role="dialog" aria-labelledby="approveModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="approveModalLabel">تأكيد الموافقة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.leaves.approve', $leave->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <p>هل أنت متأكد من رغبتك في الموافقة على طلب إجازة الموظف <strong>{{ $leave->employee->first_name }} {{ $leave->employee->last_name }}</strong>؟</p>
                    <div class="form-group">
                        <label for="admin_notes">ملاحظات (اختياري)</label>
                        <textarea name="admin_notes" id="admin_notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">موافقة</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="rejectModalLabel">تأكيد الرفض</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.leaves.reject', $leave->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <p>هل أنت متأكد من رغبتك في رفض طلب إجازة الموظف <strong>{{ $leave->employee->first_name }} {{ $leave->employee->last_name }}</strong>؟</p>
                    <div class="form-group">
                        <label for="admin_notes">سبب الرفض <span class="text-danger">*</span></label>
                        <textarea name="admin_notes" id="admin_notes" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">رفض</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('styles')
<style>
    .timeline {
        position: relative;
        margin: 0 0 30px 0;
        padding: 0;
        list-style: none;
    }
    .timeline:before {
        content: '';
        position: absolute;
        top: 0;
        bottom: 0;
        width: 4px;
        background: #ddd;
        right: 31px;
        margin: 0;
        border-radius: 2px;
    }
    .timeline > div {
        position: relative;
        margin-right: 10px;
        margin-bottom: 15px;
    }
    .timeline > .time-label > span {
        font-weight: 600;
        padding: 5px;
        display: inline-block;
        background-color: #fff;
        border-radius: 4px;
    }
    .timeline > div > i {
        width: 30px;
        height: 30px;
        font-size: 15px;
        line-height: 30px;
        position: absolute;
        color: #fff;
        background: #6c757d;
        border-radius: 50%;
        text-align: center;
        right: -15px;
        top: 0;
        z-index: 1;
    }
    .timeline > div > .timeline-item {
        box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
        border-radius: 3px;
        margin-right: 60px;
        margin-left: 15px;
        padding: 0;
        position: relative;
        background: #fff;
        color: #444;
    }
    .timeline > div > .timeline-item > .time {
        color: #999;
        float: left;
        padding: 10px;
        font-size: 12px;
    }
    .timeline > div > .timeline-item > .timeline-header {
        margin: 0;
        color: #555;
        border-bottom: 1px solid #f4f4f4;
        padding: 10px;
        font-size: 16px;
        line-height: 1.1;
    }
    .timeline > div > .timeline-item > .timeline-body {
        padding: 10px;
    }
</style>
@endpush
@endsection