@extends('layouts.modern')

@section('title', 'إدارة الإجازات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">طلبات الإجازات</h3>
                    <a href="{{ route('hrm.leaves.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> طلب إجازة جديدة
                    </a>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.leaves.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="employee_id" class="ml-2">الموظف:</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">-- جميع الموظفين --</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="leave_type_id" class="ml-2">نوع الإجازة:</label>
                                    <select name="leave_type_id" id="leave_type_id" class="form-control">
                                        <option value="">-- جميع الأنواع --</option>
                                        @foreach($leaveTypes as $leaveType)
                                            <option value="{{ $leaveType->id }}" {{ request('leave_type_id') == $leaveType->id ? 'selected' : '' }}>
                                                {{ $leaveType->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="status" class="ml-2">الحالة:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>موافق عليها</option>
                                        <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>مرفوضة</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="date_from" class="ml-2">من تاريخ:</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                                <div class="form-group mx-1">
                                    <label for="date_to" class="ml-2">إلى تاريخ:</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.leaves.index') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>نوع الإجازة</th>
                                    <th>تاريخ البداية</th>
                                    <th>تاريخ النهاية</th>
                                    <th>عدد الأيام</th>
                                    <th>السبب</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الطلب</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($leaves as $leave)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            <a href="{{ route('hrm.employees.show', $leave->employee->id) }}">
                                                {{ $leave->employee->first_name }} {{ $leave->employee->last_name }}
                                            </a>
                                        </td>
                                        <td>{{ $leave->leaveType->name }}</td>
                                        <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                        <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                        <td>{{ $leave->total_days }}</td>
                                        <td>{{ Str::limit($leave->reason, 30) ?: '-' }}</td>
                                        <td>
                                            @if($leave->status == 'pending')
                                                <span class="badge badge-warning">قيد الانتظار</span>
                                            @elseif($leave->status == 'approved')
                                                <span class="badge badge-success">موافق عليها</span>
                                            @elseif($leave->status == 'rejected')
                                                <span class="badge badge-danger">مرفوضة</span>
                                            @elseif($leave->status == 'cancelled')
                                                <span class="badge badge-secondary">ملغاة</span>
                                            @endif
                                        </td>
                                        <td>{{ $leave->created_at->format('Y-m-d') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('hrm.leaves.show', $leave->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($leave->status == 'pending')
                                                    <a href="{{ route('hrm.leaves.edit', $leave->id) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#approveModal{{ $leave->id }}">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#rejectModal{{ $leave->id }}">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                @endif
                                            </div>

                                            <!-- Approve Modal -->
                                            <div class="modal fade" id="approveModal{{ $leave->id }}" tabindex="-1" role="dialog" aria-labelledby="approveModalLabel{{ $leave->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="approveModalLabel{{ $leave->id }}">تأكيد الموافقة</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('hrm.leaves.approve', $leave->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <p>هل أنت متأكد من رغبتك في الموافقة على طلب إجازة الموظف <strong>{{ $leave->employee->first_name }} {{ $leave->employee->last_name }}</strong>؟</p>
                                                                <div class="form-group">
                                                                    <label for="admin_notes">ملاحظات (اختياري)</label>
                                                                    <textarea name="admin_notes" id="admin_notes" class="form-control" rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-success">موافقة</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Reject Modal -->
                                            <div class="modal fade" id="rejectModal{{ $leave->id }}" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel{{ $leave->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="rejectModalLabel{{ $leave->id }}">تأكيد الرفض</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('hrm.leaves.reject', $leave->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <p>هل أنت متأكد من رغبتك في رفض طلب إجازة الموظف <strong>{{ $leave->employee->first_name }} {{ $leave->employee->last_name }}</strong>؟</p>
                                                                <div class="form-group">
                                                                    <label for="admin_notes">سبب الرفض <span class="text-danger">*</span></label>
                                                                    <textarea name="admin_notes" id="admin_notes" class="form-control" rows="3" required></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-danger">رفض</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد طلبات إجازات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $leaves->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات الإجازات -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إحصائيات الإجازات</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-calendar-check"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي الإجازات</span>
                                    <span class="info-box-number">{{ $totalLeaves }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">قيد الانتظار</span>
                                    <span class="info-box-number">{{ $pendingLeaves }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">موافق عليها</span>
                                    <span class="info-box-number">{{ $approvedLeaves }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-danger">
                                <span class="info-box-icon"><i class="fas fa-times-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مرفوضة</span>
                                    <span class="info-box-number">{{ $rejectedLeaves }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">الإجازات حسب النوع</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="leaveTypeChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">الإجازات حسب الشهر</h5>
                                </div>
                                <div class="card-body">
                                    <canvas id="leaveMonthChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // إعداد بيانات الرسم البياني للإجازات حسب النوع
        var leaveTypeCtx = document.getElementById('leaveTypeChart').getContext('2d');
        var leaveTypeChart = new Chart(leaveTypeCtx, {
            type: 'pie',
            data: {
                labels: {!! json_encode($leaveTypeStats->pluck('name')) !!},
                datasets: [{
                    data: {!! json_encode($leaveTypeStats->pluck('count')) !!},
                    backgroundColor: [
                        '#4e73df', '#1cc88a', '#36b9cc', '#f6c23e', '#e74a3b', '#858796', '#5a5c69'
                    ],
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });

        // إعداد بيانات الرسم البياني للإجازات حسب الشهر
        var leaveMonthCtx = document.getElementById('leaveMonthChart').getContext('2d');
        var leaveMonthChart = new Chart(leaveMonthCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($leaveMonthStats->pluck('month')) !!},
                datasets: [{
                    label: 'عدد الإجازات',
                    data: {!! json_encode($leaveMonthStats->pluck('count')) !!},
                    backgroundColor: '#4e73df',
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
    });
</script>
@endpush
@endsection