@extends('layouts.modern')

@section('title', 'طلب إجازة جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">طلب إجازة جديدة</h3>
                </div>
                <form action="{{ route('hrm.leaves.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 form-group">
                                <label for="employee_id">الموظف <span class="text-danger">*</span></label>
                                <select name="employee_id" id="employee_id" class="form-control @error('employee_id') is-invalid @enderror" required>
                                    <option value="">-- اختر الموظف --</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}
                                            data-balance="{{ json_encode($employee->leaveBalances) }}">
                                            {{ $employee->first_name }} {{ $employee->last_name }} ({{ $employee->employee_number }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="leave_type_id">نوع الإجازة <span class="text-danger">*</span></label>
                                <select name="leave_type_id" id="leave_type_id" class="form-control @error('leave_type_id') is-invalid @enderror" required>
                                    <option value="">-- اختر نوع الإجازة --</option>
                                    @foreach($leaveTypes as $leaveType)
                                        <option value="{{ $leaveType->id }}" {{ old('leave_type_id') == $leaveType->id ? 'selected' : '' }}
                                            data-requires-attachment="{{ $leaveType->requires_attachment ? 'true' : 'false' }}">
                                            {{ $leaveType->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('leave_type_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="status">الحالة</label>
                                <select name="status" id="status" class="form-control @error('status') is-invalid @enderror">
                                    <option value="pending" {{ old('status', 'pending') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                    @if(auth()->user()->hasRole('admin') || auth()->user()->hasRole('hr_manager'))
                                        <option value="approved" {{ old('status') == 'approved' ? 'selected' : '' }}>موافق عليها</option>
                                        <option value="rejected" {{ old('status') == 'rejected' ? 'selected' : '' }}>مرفوضة</option>
                                    @endif
                                </select>
                                @error('status')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="start_date">تاريخ البداية <span class="text-danger">*</span></label>
                                <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date') }}" required>
                                @error('start_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="end_date">تاريخ النهاية <span class="text-danger">*</span></label>
                                <input type="date" name="end_date" id="end_date" class="form-control @error('end_date') is-invalid @enderror" value="{{ old('end_date') }}" required>
                                @error('end_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="total_days">عدد الأيام</label>
                                <input type="number" name="total_days" id="total_days" class="form-control @error('total_days') is-invalid @enderror" value="{{ old('total_days') }}" readonly>
                                @error('total_days')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-12 form-group">
                                <label for="reason">سبب الإجازة <span class="text-danger">*</span></label>
                                <textarea name="reason" id="reason" class="form-control @error('reason') is-invalid @enderror" rows="3" required>{{ old('reason') }}</textarea>
                                @error('reason')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-12 form-group" id="attachment-group" style="display: none;">
                                <label for="attachment">المرفقات <span class="text-danger attachment-required" style="display: none;">*</span></label>
                                <input type="file" name="attachment" id="attachment" class="form-control-file @error('attachment') is-invalid @enderror">
                                <small class="form-text text-muted">يمكنك رفع ملفات بصيغة PDF أو صور (الحد الأقصى: 5 ميجابايت)</small>
                                @error('attachment')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-12 mt-3">
                                <div class="alert alert-info" id="leave-balance-info" style="display: none;">
                                    <h5><i class="icon fas fa-info"></i> معلومات رصيد الإجازات</h5>
                                    <div id="balance-details"></div>
                                </div>
                            </div>

                            @if(auth()->user()->hasRole('admin') || auth()->user()->hasRole('hr_manager'))
                                <div class="col-md-12 form-group">
                                    <label for="admin_notes">ملاحظات الإدارة</label>
                                    <textarea name="admin_notes" id="admin_notes" class="form-control @error('admin_notes') is-invalid @enderror" rows="3">{{ old('admin_notes') }}</textarea>
                                    @error('admin_notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ</button>
                        <a href="{{ route('hrm.leaves.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // حساب عدد أيام الإجازة
        function calculateDays() {
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            
            if (startDate && endDate) {
                var start = new Date(startDate);
                var end = new Date(endDate);
                
                // التحقق من أن تاريخ البداية قبل تاريخ النهاية
                if (start > end) {
                    $('#end_date').val(startDate);
                    end = new Date(startDate);
                }
                
                // حساب الفرق بالأيام
                var diffTime = Math.abs(end - start);
                var diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)) + 1; // +1 لتضمين يوم البداية والنهاية
                
                $('#total_days').val(diffDays);
                
                // تحديث معلومات الرصيد
                updateBalanceInfo();
            }
        }
        
        // تحديث معلومات رصيد الإجازات
        function updateBalanceInfo() {
            var employeeId = $('#employee_id').val();
            var leaveTypeId = $('#leave_type_id').val();
            var totalDays = parseInt($('#total_days').val() || 0);
            
            if (employeeId && leaveTypeId) {
                var selectedEmployee = $('#employee_id option:selected');
                var balances = selectedEmployee.data('balance');
                
                if (balances) {
                    var balanceInfo = '';
                    var currentBalance = 0;
                    
                    // البحث عن رصيد نوع الإجازة المحدد
                    for (var i = 0; i < balances.length; i++) {
                        if (balances[i].leave_type_id == leaveTypeId) {
                            currentBalance = balances[i].balance;
                            break;
                        }
                    }
                    
                    balanceInfo += '<p>الرصيد المتاح: <strong>' + currentBalance + '</strong> يوم</p>';
                    balanceInfo += '<p>الأيام المطلوبة: <strong>' + totalDays + '</strong> يوم</p>';
                    
                    if (totalDays > currentBalance) {
                        balanceInfo += '<p class="text-danger">تنبيه: عدد الأيام المطلوبة أكبر من الرصيد المتاح!</p>';
                    }
                    
                    $('#balance-details').html(balanceInfo);
                    $('#leave-balance-info').show();
                } else {
                    $('#leave-balance-info').hide();
                }
            } else {
                $('#leave-balance-info').hide();
            }
        }
        
        // التحقق من متطلبات المرفقات
        function checkAttachmentRequirement() {
            var leaveTypeId = $('#leave_type_id').val();
            
            if (leaveTypeId) {
                var requiresAttachment = $('#leave_type_id option:selected').data('requires-attachment') === 'true';
                
                if (requiresAttachment) {
                    $('#attachment-group').show();
                    $('.attachment-required').show();
                    $('#attachment').prop('required', true);
                } else {
                    $('#attachment-group').show(); // نعرض حقل المرفقات دائمًا ولكن بدون إلزام
                    $('.attachment-required').hide();
                    $('#attachment').prop('required', false);
                }
            } else {
                $('#attachment-group').hide();
                $('#attachment').prop('required', false);
            }
        }
        
        // تفعيل الدوال عند تغيير القيم
        $('#start_date, #end_date').change(calculateDays);
        $('#employee_id, #leave_type_id').change(function() {
            updateBalanceInfo();
            checkAttachmentRequirement();
        });
        
        // تشغيل الدوال عند تحميل الصفحة
        calculateDays();
        checkAttachmentRequirement();
    });
</script>
@endpush
@endsection