@extends('layouts.modern')

@section('title', 'تقويم الإجازات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>تقويم الإجازات</h3>
                    <div>
                        <a href="{{ route('hrm.leaves.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> قائمة الإجازات
                        </a>
                        <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-primary">
                            <i class="fas fa-balance-scale"></i> أرصدة الإجازات
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>فلترة التقويم</h5>
                        </div>
                        <div class="card-body">
                            <form method="GET" action="{{ route('hrm.leaves.calendar') }}" class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="month">الشهر</label>
                                    <select name="month" id="month" class="form-control">
                                        @php
                                            $months = [
                                                '01' => 'يناير',
                                                '02' => 'فبراير',
                                                '03' => 'مارس',
                                                '04' => 'أبريل',
                                                '05' => 'مايو',
                                                '06' => 'يونيو',
                                                '07' => 'يوليو',
                                                '08' => 'أغسطس',
                                                '09' => 'سبتمبر',
                                                '10' => 'أكتوبر',
                                                '11' => 'نوفمبر',
                                                '12' => 'ديسمبر'
                                            ];
                                        @endphp
                                        @foreach($months as $key => $value)
                                            <option value="{{ $key }}" {{ $month == $key ? 'selected' : '' }}>{{ $value }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="year">السنة</label>
                                    <select name="year" id="year" class="form-control">
                                        @for($i = date('Y') - 2; $i <= date('Y') + 2; $i++)
                                            <option value="{{ $i }}" {{ $year == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2">
                                        <i class="fas fa-search"></i> عرض
                                    </button>
                                    <a href="{{ route('hrm.leaves.calendar') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- التقويم -->
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">
                                @php
                                    $monthName = $months[$month] ?? '';
                                    echo "{$monthName} {$year}";
                                @endphp
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered calendar-table">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>الأحد</th>
                                            <th>الإثنين</th>
                                            <th>الثلاثاء</th>
                                            <th>الأربعاء</th>
                                            <th>الخميس</th>
                                            <th>الجمعة</th>
                                            <th>السبت</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $date = \Carbon\Carbon::createFromDate($year, $month, 1);
                                            $daysInMonth = $date->daysInMonth;
                                            $firstDayOfMonth = $date->copy()->firstOfMonth();
                                            $lastDayOfMonth = $date->copy()->lastOfMonth();
                                            
                                            // Get the first day of the week (0 = Sunday, 6 = Saturday)
                                            $firstDayOfWeek = $firstDayOfMonth->dayOfWeek;
                                            
                                            // Calculate the number of weeks
                                            $weeksInMonth = ceil(($firstDayOfWeek + $daysInMonth) / 7);
                                            
                                            // Current day counter
                                            $currentDay = 1;
                                            
                                            // Today's date for highlighting
                                            $today = \Carbon\Carbon::today();
                                        @endphp
                                        
                                        @for($week = 0; $week < $weeksInMonth; $week++)
                                            <tr>
                                                @for($day = 0; $day < 7; $day++)
                                                    @php
                                                        $isCurrentMonth = false;
                                                        $dateString = '';
                                                        
                                                        // Check if we're in the current month
                                                        if (($week == 0 && $day < $firstDayOfWeek) || $currentDay > $daysInMonth) {
                                                            // Empty cell
                                                            $cellContent = '';
                                                        } else {
                                                            $isCurrentMonth = true;
                                                            $dateObj = \Carbon\Carbon::createFromDate($year, $month, $currentDay);
                                                            $dateString = $dateObj->format('Y-m-d');
                                                            $isToday = $dateObj->isSameDay($today);
                                                            
                                                            // Cell content
                                                            $cellContent = '<div class="calendar-day ' . ($isToday ? 'today' : '') . '">';
                                                            $cellContent .= '<div class="day-number">' . $currentDay . '</div>';
                                                            
                                                            // Add leave events
                                                            if (isset($calendarData[$dateString]) && count($calendarData[$dateString]) > 0) {
                                                                $cellContent .= '<div class="leave-events">';
                                                                foreach($calendarData[$dateString] as $leave) {
                                                                    $cellContent .= '<div class="leave-event" data-toggle="tooltip" title="' . $leave['employee'] . ' - ' . $leave['type'] . '">';
                                                                    $cellContent .= '<a href="' . route('hrm.leaves.show', $leave['id']) . '">';
                                                                    $cellContent .= $leave['employee'] . ' (' . $leave['type'] . ')';
                                                                    $cellContent .= '</a>';
                                                                    $cellContent .= '</div>';
                                                                }
                                                                $cellContent .= '</div>';
                                                            }
                                                            
                                                            $cellContent .= '</div>';
                                                            $currentDay++;
                                                        }
                                                    @endphp
                                                    
                                                    <td class="{{ $isCurrentMonth ? 'current-month' : 'other-month' }} {{ isset($calendarData[$dateString]) ? 'has-events' : '' }}">
                                                        {!! $cellContent !!}
                                                    </td>
                                                @endfor
                                            </tr>
                                        @endfor
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- ملخص الإجازات -->
                    <div class="card mt-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">ملخص الإجازات</h5>
                        </div>
                        <div class="card-body">
                            @php
                                $leavesByEmployee = [];
                                $leavesByType = [];
                                
                                foreach($calendarData as $date => $leaves) {
                                    foreach($leaves as $leave) {
                                        // Count by employee
                                        if (!isset($leavesByEmployee[$leave['employee']])) {
                                            $leavesByEmployee[$leave['employee']] = 0;
                                        }
                                        $leavesByEmployee[$leave['employee']]++;
                                        
                                        // Count by type
                                        if (!isset($leavesByType[$leave['type']])) {
                                            $leavesByType[$leave['type']] = 0;
                                        }
                                        $leavesByType[$leave['type']]++;
                                    }
                                }
                                
                                // Sort by count
                                arsort($leavesByEmployee);
                                arsort($leavesByType);
                            @endphp
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>الإجازات حسب الموظف</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped">
                                            <thead>
                                                <tr>
                                                    <th>الموظف</th>
                                                    <th>عدد الإجازات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($leavesByEmployee as $employee => $count)
                                                    <tr>
                                                        <td>{{ $employee }}</td>
                                                        <td>{{ $count }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="2" class="text-center">لا توجد إجازات</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>الإجازات حسب النوع</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped">
                                            <thead>
                                                <tr>
                                                    <th>نوع الإجازة</th>
                                                    <th>عدد الإجازات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($leavesByType as $type => $count)
                                                    <tr>
                                                        <td>{{ $type }}</td>
                                                        <td>{{ $count }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="2" class="text-center">لا توجد إجازات</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .calendar-table {
        table-layout: fixed;
    }
    
    .calendar-table th, .calendar-table td {
        width: 14.28%;
        height: 100px;
        vertical-align: top;
        padding: 5px;
    }
    
    .calendar-day {
        min-height: 90px;
        position: relative;
    }
    
    .day-number {
        font-weight: bold;
        font-size: 1.2em;
        margin-bottom: 5px;
    }
    
    .today .day-number {
        background-color: #007bff;
        color: white;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .other-month {
        background-color: #f8f9fa;
    }
    
    .has-events {
        background-color: #e8f4ff;
    }
    
    .leave-events {
        font-size: 0.85em;
    }
    
    .leave-event {
        margin-bottom: 3px;
        padding: 2px 4px;
        background-color: #e3f2fd;
        border-left: 3px solid #007bff;
        border-radius: 2px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .leave-event a {
        color: #0056b3;
        text-decoration: none;
    }
    
    .leave-event a:hover {
        text-decoration: underline;
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>
@endpush
@endsection