@extends('layouts.modern')

@section('title', 'تفاصيل رصيد الإجازة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>تفاصيل رصيد الإجازة</h3>
                    <div>
                        <a href="{{ route('hrm.leave-balances.edit', $leaveBalance->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل الرصيد
                        </a>
                        <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- معلومات الرصيد -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">معلومات الرصيد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">الموظف</th>
                                            <td>{{ $leaveBalance->employee->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الإجازة</th>
                                            <td>{{ $leaveBalance->leaveType->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>السنة</th>
                                            <td>{{ $leaveBalance->year }}</td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي أيام الإجازة</th>
                                            <td>{{ $leaveBalance->total_days }}</td>
                                        </tr>
                                        <tr>
                                            <th>الأيام المرحلة</th>
                                            <td>{{ $leaveBalance->carried_over_days }}</td>
                                        </tr>
                                        <tr>
                                            <th>الأيام المستخدمة</th>
                                            <td>{{ $leaveBalance->used_days }}</td>
                                        </tr>
                                        <tr>
                                            <th>الأيام المعلقة</th>
                                            <td>{{ $leaveBalance->pending_days }}</td>
                                        </tr>
                                        <tr>
                                            <th>الأيام المتبقية</th>
                                            <td>
                                                <span class="badge {{ $leaveBalance->remaining_days > 0 ? 'badge-success' : 'badge-danger' }} p-2">
                                                    {{ $leaveBalance->remaining_days }}
                                                </span>
                                            </td>
                                        </tr>
                                        @if($leaveBalance->notes)
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $leaveBalance->notes }}</td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- ملخص الرصيد -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">ملخص الرصيد</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-light">
                                                <div class="card-body text-center">
                                                    <h6>إجمالي الرصيد</h6>
                                                    <h3 class="text-primary">{{ $leaveBalance->total_days + $leaveBalance->carried_over_days }}</h3>
                                                    <small class="text-muted">الرصيد الأساسي + المرحل</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-light">
                                                <div class="card-body text-center">
                                                    <h6>الرصيد المستخدم</h6>
                                                    <h3 class="text-danger">{{ $leaveBalance->used_days }}</h3>
                                                    <small class="text-muted">الإجازات المعتمدة</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-light">
                                                <div class="card-body text-center">
                                                    <h6>الرصيد المعلق</h6>
                                                    <h3 class="text-warning">{{ $leaveBalance->pending_days }}</h3>
                                                    <small class="text-muted">الإجازات قيد الموافقة</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-light">
                                                <div class="card-body text-center">
                                                    <h6>الرصيد المتبقي</h6>
                                                    <h3 class="{{ $leaveBalance->remaining_days > 0 ? 'text-success' : 'text-danger' }}">
                                                        {{ $leaveBalance->remaining_days }}
                                                    </h3>
                                                    <small class="text-muted">الرصيد المتاح حالياً</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- مخطط توضيحي للرصيد -->
                                    <div class="mt-3">
                                        <h6>توزيع الرصيد</h6>
                                        <div class="progress" style="height: 25px;">
                                            @php
                                                $totalBalance = $leaveBalance->total_days + $leaveBalance->carried_over_days;
                                                $usedPercentage = $totalBalance > 0 ? ($leaveBalance->used_days / $totalBalance) * 100 : 0;
                                                $pendingPercentage = $totalBalance > 0 ? ($leaveBalance->pending_days / $totalBalance) * 100 : 0;
                                                $remainingPercentage = 100 - $usedPercentage - $pendingPercentage;
                                            @endphp
                                            <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $usedPercentage }}%" 
                                                aria-valuenow="{{ $usedPercentage }}" aria-valuemin="0" aria-valuemax="100" 
                                                title="الأيام المستخدمة: {{ $leaveBalance->used_days }}">
                                                {{ $leaveBalance->used_days }}
                                            </div>
                                            <div class="progress-bar bg-warning" role="progressbar" style="width: {{ $pendingPercentage }}%" 
                                                aria-valuenow="{{ $pendingPercentage }}" aria-valuemin="0" aria-valuemax="100"
                                                title="الأيام المعلقة: {{ $leaveBalance->pending_days }}">
                                                {{ $leaveBalance->pending_days }}
                                            </div>
                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $remainingPercentage }}%" 
                                                aria-valuenow="{{ $remainingPercentage }}" aria-valuemin="0" aria-valuemax="100"
                                                title="الأيام المتبقية: {{ $leaveBalance->remaining_days }}">
                                                {{ $leaveBalance->remaining_days }}
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between mt-2">
                                            <small><span class="badge badge-danger">■</span> مستخدم</small>
                                            <small><span class="badge badge-warning">■</span> معلق</small>
                                            <small><span class="badge badge-success">■</span> متبقي</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- سجل الإجازات -->
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">سجل الإجازات</h5>
                        </div>
                        <div class="card-body">
                            @if(count($leaves) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>#</th>
                                                <th>تاريخ البداية</th>
                                                <th>تاريخ النهاية</th>
                                                <th>عدد الأيام</th>
                                                <th>السبب</th>
                                                <th>الحالة</th>
                                                <th>تاريخ الطلب</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($leaves as $index => $leave)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                                    <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                                    <td>{{ $leave->total_days }}</td>
                                                    <td>{{ Str::limit($leave->reason, 30) }}</td>
                                                    <td>
                                                        @if($leave->status == 'pending')
                                                            <span class="badge badge-warning">قيد الانتظار</span>
                                                        @elseif($leave->status == 'approved')
                                                            <span class="badge badge-success">معتمدة</span>
                                                        @elseif($leave->status == 'rejected')
                                                            <span class="badge badge-danger">مرفوضة</span>
                                                        @elseif($leave->status == 'cancelled')
                                                            <span class="badge badge-secondary">ملغاة</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ $leave->created_at->format('Y-m-d') }}</td>
                                                    <td>
                                                        <a href="{{ route('hrm.leaves.show', $leave->id) }}" class="btn btn-sm btn-info" title="عرض">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-info">
                                    <p class="mb-0">لا توجد إجازات مسجلة لهذا الموظف في هذه السنة.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection