@extends('layouts.modern')

@section('title', 'أرصدة الإجازات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>أرصدة الإجازات</h3>
                    <div>
                        <a href="{{ route('hrm.leave-balances.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة رصيد إجازة
                        </a>
                        <a href="{{ route('hrm.leaves.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> قائمة الإجازات
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>فلترة النتائج</h5>
                        </div>
                        <div class="card-body">
                            <form method="GET" action="{{ route('hrm.leave-balances.index') }}" class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="employee_id">الموظف</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">جميع الموظفين</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="leave_type_id">نوع الإجازة</label>
                                    <select name="leave_type_id" id="leave_type_id" class="form-control">
                                        <option value="">جميع أنواع الإجازات</option>
                                        @foreach($leaveTypes as $leaveType)
                                            <option value="{{ $leaveType->id }}" {{ request('leave_type_id') == $leaveType->id ? 'selected' : '' }}>
                                                {{ $leaveType->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="year">السنة</label>
                                    <select name="year" id="year" class="form-control">
                                        @foreach($years as $year)
                                            <option value="{{ $year }}" {{ request('year', date('Y')) == $year ? 'selected' : '' }}>
                                                {{ $year }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mb-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                    <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- أدوات إدارة الأرصدة -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>أدوات إدارة الأرصدة</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-header bg-info text-white">
                                            <h6 class="mb-0">تحديث جميع الأرصدة</h6>
                                        </div>
                                        <div class="card-body">
                                            <p>تحديث جميع أرصدة الإجازات بناءً على الإجازات المعتمدة والمعلقة.</p>
                                            <form method="POST" action="{{ route('hrm.leave-balances.update-all') }}">
                                                @csrf
                                                <input type="hidden" name="year" value="{{ request('year', date('Y')) }}">
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fas fa-sync"></i> تحديث جميع الأرصدة
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-header bg-success text-white">
                                            <h6 class="mb-0">إنشاء أرصدة للسنة الجديدة</h6>
                                        </div>
                                        <div class="card-body">
                                            <form method="POST" action="{{ route('hrm.leave-balances.create-new-year') }}">
                                                @csrf
                                                <div class="row">
                                                    <div class="col-md-4 mb-2">
                                                        <label for="from_year">من سنة</label>
                                                        <select name="from_year" id="from_year" class="form-control" required>
                                                            @foreach($years as $year)
                                                                <option value="{{ $year }}" {{ $year == date('Y') - 1 ? 'selected' : '' }}>
                                                                    {{ $year }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4 mb-2">
                                                        <label for="to_year">إلى سنة</label>
                                                        <select name="to_year" id="to_year" class="form-control" required>
                                                            @foreach($years as $year)
                                                                <option value="{{ $year }}" {{ $year == date('Y') ? 'selected' : '' }}>
                                                                    {{ $year }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4 mb-2">
                                                        <label for="carry_over_percentage">نسبة الترحيل (%)</label>
                                                        <input type="number" name="carry_over_percentage" id="carry_over_percentage" class="form-control" min="0" max="100" value="50" required>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-success mt-2">
                                                    <i class="fas fa-calendar-plus"></i> إنشاء أرصدة السنة الجديدة
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول أرصدة الإجازات -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>نوع الإجازة</th>
                                    <th>السنة</th>
                                    <th>إجمالي الأيام</th>
                                    <th>الأيام المستخدمة</th>
                                    <th>الأيام المعلقة</th>
                                    <th>الأيام المتبقية</th>
                                    <th>الأيام المرحلة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($leaveBalances as $index => $balance)
                                    <tr>
                                        <td>{{ $leaveBalances->firstItem() + $index }}</td>
                                        <td>{{ $balance->employee->name }}</td>
                                        <td>{{ $balance->leaveType->name }}</td>
                                        <td>{{ $balance->year }}</td>
                                        <td>{{ $balance->total_days }}</td>
                                        <td>{{ $balance->used_days }}</td>
                                        <td>{{ $balance->pending_days }}</td>
                                        <td>
                                            <span class="badge {{ $balance->remaining_days > 0 ? 'badge-success' : 'badge-danger' }}">
                                                {{ $balance->remaining_days }}
                                            </span>
                                        </td>
                                        <td>{{ $balance->carried_over_days }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('hrm.leave-balances.show', $balance->id) }}" class="btn btn-sm btn-info" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.leave-balances.edit', $balance->id) }}" class="btn btn-sm btn-primary" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="if(confirm('هل أنت متأكد من حذف هذا الرصيد؟')) { document.getElementById('delete-form-{{ $balance->id }}').submit(); }" title="حذف">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                <form id="delete-form-{{ $balance->id }}" action="{{ route('hrm.leave-balances.destroy', $balance->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد أرصدة إجازات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- ترقيم الصفحات -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $leaveBalances->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection