@extends('layouts.modern')

@section('title', 'تعديل رصيد الإجازة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>تعديل رصيد الإجازة</h3>
                    <div>
                        <a href="{{ route('hrm.leave-balances.show', $leaveBalance->id) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> عرض التفاصيل
                        </a>
                        <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('hrm.leave-balances.update', $leaveBalance->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="employee_id" class="form-label">الموظف</label>
                                <input type="text" class="form-control" value="{{ $leaveBalance->employee->name }}" readonly>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="leave_type_id" class="form-label">نوع الإجازة</label>
                                <input type="text" class="form-control" value="{{ $leaveBalance->leaveType->name }}" readonly>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="year" class="form-label">السنة</label>
                                <input type="text" class="form-control" value="{{ $leaveBalance->year }}" readonly>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="total_days" class="form-label">إجمالي أيام الإجازة <span class="text-danger">*</span></label>
                                <input type="number" name="total_days" id="total_days" class="form-control @error('total_days') is-invalid @enderror" value="{{ old('total_days', $leaveBalance->total_days) }}" min="0" step="0.5" required>
                                <small class="form-text text-muted">عدد أيام الإجازة المستحقة للموظف خلال السنة</small>
                                @error('total_days')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="carried_over_days" class="form-label">الأيام المرحلة من السنة السابقة</label>
                                <input type="number" name="carried_over_days" id="carried_over_days" class="form-control @error('carried_over_days') is-invalid @enderror" value="{{ old('carried_over_days', $leaveBalance->carried_over_days) }}" min="0" step="0.5">
                                <small class="form-text text-muted">عدد أيام الإجازة المرحلة من السنة السابقة</small>
                                @error('carried_over_days')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="used_days" class="form-label">الأيام المستخدمة</label>
                                <input type="number" class="form-control" value="{{ $leaveBalance->used_days }}" readonly>
                                <small class="form-text text-muted">يتم حسابها تلقائياً من الإجازات المعتمدة</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="pending_days" class="form-label">الأيام المعلقة</label>
                                <input type="number" class="form-control" value="{{ $leaveBalance->pending_days }}" readonly>
                                <small class="form-text text-muted">يتم حسابها تلقائياً من الإجازات قيد الموافقة</small>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="remaining_days" class="form-label">الأيام المتبقية</label>
                                <input type="number" class="form-control" value="{{ $leaveBalance->remaining_days }}" readonly>
                                <small class="form-text text-muted">يتم حسابها تلقائياً (الإجمالي + المرحل - المستخدم - المعلق)</small>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="notes" class="form-label">ملاحظات</label>
                                <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $leaveBalance->notes) }}</textarea>
                                @error('notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-12 mt-3">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i> سيتم إعادة حساب الأيام المتبقية تلقائياً بناءً على التغييرات.
                                </div>
                            </div>

                            <div class="col-md-12 mt-3 text-center">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-save"></i> حفظ التعديلات
                                </button>
                                <a href="{{ route('hrm.leave-balances.show', $leaveBalance->id) }}" class="btn btn-secondary btn-lg">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection