@extends('layouts.modern')

@section('title', 'إضافة رصيد إجازة جديد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>إضافة رصيد إجازة جديد</h3>
                    <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('hrm.leave-balances.store') }}">
                        @csrf

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="employee_id" class="form-label">الموظف <span class="text-danger">*</span></label>
                                <select name="employee_id" id="employee_id" class="form-control @error('employee_id') is-invalid @enderror" required>
                                    <option value="">اختر الموظف</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="leave_type_id" class="form-label">نوع الإجازة <span class="text-danger">*</span></label>
                                <select name="leave_type_id" id="leave_type_id" class="form-control @error('leave_type_id') is-invalid @enderror" required>
                                    <option value="">اختر نوع الإجازة</option>
                                    @foreach($leaveTypes as $leaveType)
                                        <option value="{{ $leaveType->id }}" {{ old('leave_type_id') == $leaveType->id ? 'selected' : '' }}>
                                            {{ $leaveType->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('leave_type_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="year" class="form-label">السنة <span class="text-danger">*</span></label>
                                <select name="year" id="year" class="form-control @error('year') is-invalid @enderror" required>
                                    @foreach($years as $year => $yearLabel)
                                        <option value="{{ $year }}" {{ old('year', date('Y')) == $year ? 'selected' : '' }}>
                                            {{ $yearLabel }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('year')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="total_days" class="form-label">إجمالي أيام الإجازة <span class="text-danger">*</span></label>
                                <input type="number" name="total_days" id="total_days" class="form-control @error('total_days') is-invalid @enderror" value="{{ old('total_days') }}" min="0" step="0.5" required>
                                <small class="form-text text-muted">عدد أيام الإجازة المستحقة للموظف خلال السنة</small>
                                @error('total_days')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="carried_over_days" class="form-label">الأيام المرحلة من السنة السابقة</label>
                                <input type="number" name="carried_over_days" id="carried_over_days" class="form-control @error('carried_over_days') is-invalid @enderror" value="{{ old('carried_over_days', 0) }}" min="0" step="0.5">
                                <small class="form-text text-muted">عدد أيام الإجازة المرحلة من السنة السابقة (إن وجدت)</small>
                                @error('carried_over_days')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="notes" class="form-label">ملاحظات</label>
                                <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                @error('notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-12 mt-3">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i> سيتم حساب الأيام المستخدمة والمعلقة تلقائياً بناءً على طلبات الإجازة الموجودة.
                                </div>
                            </div>

                            <div class="col-md-12 mt-3 text-center">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-save"></i> حفظ رصيد الإجازة
                                </button>
                                <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-secondary btn-lg">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection