@extends('layouts.modern')

@section('title', 'أنواع الإجازات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">أنواع الإجازات</h3>
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createLeaveTypeModal">
                        <i class="fas fa-plus"></i> إضافة نوع إجازة جديد
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>الاسم (بالإنجليزية)</th>
                                    <th>عدد الأيام السنوية</th>
                                    <th>يتطلب مرفقات</th>
                                    <th>يتطلب موافقة</th>
                                    <th>الوصف</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($leaveTypes as $leaveType)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $leaveType->name }}</td>
                                        <td>{{ $leaveType->name_en ?: '-' }}</td>
                                        <td>{{ $leaveType->days_per_year }}</td>
                                        <td>
                                            @if($leaveType->requires_attachment)
                                                <span class="badge badge-success">نعم</span>
                                            @else
                                                <span class="badge badge-secondary">لا</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($leaveType->requires_approval)
                                                <span class="badge badge-success">نعم</span>
                                            @else
                                                <span class="badge badge-secondary">لا</span>
                                            @endif
                                        </td>
                                        <td>{{ Str::limit($leaveType->description, 30) ?: '-' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#editLeaveTypeModal{{ $leaveType->id }}">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteLeaveTypeModal{{ $leaveType->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Edit Modal -->
                                            <div class="modal fade" id="editLeaveTypeModal{{ $leaveType->id }}" tabindex="-1" role="dialog" aria-labelledby="editLeaveTypeModalLabel{{ $leaveType->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="editLeaveTypeModalLabel{{ $leaveType->id }}">تعديل نوع الإجازة</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('hrm.leave-types.update', $leaveType->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="name{{ $leaveType->id }}">الاسم <span class="text-danger">*</span></label>
                                                                    <input type="text" name="name" id="name{{ $leaveType->id }}" class="form-control" value="{{ $leaveType->name }}" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="name_en{{ $leaveType->id }}">الاسم (بالإنجليزية)</label>
                                                                    <input type="text" name="name_en" id="name_en{{ $leaveType->id }}" class="form-control" value="{{ $leaveType->name_en }}">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="days_per_year{{ $leaveType->id }}">عدد الأيام السنوية <span class="text-danger">*</span></label>
                                                                    <input type="number" name="days_per_year" id="days_per_year{{ $leaveType->id }}" class="form-control" value="{{ $leaveType->days_per_year }}" min="0" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="custom-control custom-switch">
                                                                        <input type="checkbox" name="requires_attachment" class="custom-control-input" id="requires_attachment{{ $leaveType->id }}" {{ $leaveType->requires_attachment ? 'checked' : '' }}>
                                                                        <label class="custom-control-label" for="requires_attachment{{ $leaveType->id }}">يتطلب مرفقات</label>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="custom-control custom-switch">
                                                                        <input type="checkbox" name="requires_approval" class="custom-control-input" id="requires_approval{{ $leaveType->id }}" {{ $leaveType->requires_approval ? 'checked' : '' }}>
                                                                        <label class="custom-control-label" for="requires_approval{{ $leaveType->id }}">يتطلب موافقة</label>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="description{{ $leaveType->id }}">الوصف</label>
                                                                    <textarea name="description" id="description{{ $leaveType->id }}" class="form-control" rows="3">{{ $leaveType->description }}</textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deleteLeaveTypeModal{{ $leaveType->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteLeaveTypeModalLabel{{ $leaveType->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteLeaveTypeModalLabel{{ $leaveType->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <p>هل أنت متأكد من رغبتك في حذف نوع الإجازة <strong>{{ $leaveType->name }}</strong>؟</p>
                                                            <p class="text-danger">
                                                                <strong>تنبيه:</strong> سيؤدي حذف نوع الإجازة إلى حذف جميع طلبات الإجازة المرتبطة به وأرصدة الإجازات للموظفين.
                                                            </p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('hrm.leave-types.destroy', $leaveType->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد أنواع إجازات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Create Modal -->
<div class="modal fade" id="createLeaveTypeModal" tabindex="-1" role="dialog" aria-labelledby="createLeaveTypeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createLeaveTypeModalLabel">إضافة نوع إجازة جديد</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.leave-types.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name">الاسم <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="name_en">الاسم (بالإنجليزية)</label>
                        <input type="text" name="name_en" id="name_en" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="days_per_year">عدد الأيام السنوية <span class="text-danger">*</span></label>
                        <input type="number" name="days_per_year" id="days_per_year" class="form-control" value="0" min="0" required>
                    </div>
                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" name="requires_attachment" class="custom-control-input" id="requires_attachment">
                            <label class="custom-control-label" for="requires_attachment">يتطلب مرفقات</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="custom-control custom-switch">
                            <input type="checkbox" name="requires_approval" class="custom-control-input" id="requires_approval" checked>
                            <label class="custom-control-label" for="requires_approval">يتطلب موافقة</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description">الوصف</label>
                        <textarea name="description" id="description" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection