@extends('layouts.modern')

@section('title', 'أرصدة الإجازات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">أرصدة الإجازات للموظفين</h3>
                    <div>
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#adjustBalanceModal">
                            <i class="fas fa-plus"></i> تعديل رصيد إجازة
                        </button>
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#bulkAdjustModal">
                            <i class="fas fa-users"></i> تعديل جماعي
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.leave-balances.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="employee_id" class="ml-2">الموظف:</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">-- جميع الموظفين --</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="leave_type_id" class="ml-2">نوع الإجازة:</label>
                                    <select name="leave_type_id" id="leave_type_id" class="form-control">
                                        <option value="">-- جميع الأنواع --</option>
                                        @foreach($leaveTypes as $leaveType)
                                            <option value="{{ $leaveType->id }}" {{ request('leave_type_id') == $leaveType->id ? 'selected' : '' }}>
                                                {{ $leaveType->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="department_id" class="ml-2">القسم:</label>
                                    <select name="department_id" id="department_id" class="form-control">
                                        <option value="">-- جميع الأقسام --</option>
                                        @foreach($departments as $department)
                                            <option value="{{ $department->id }}" {{ request('department_id') == $department->id ? 'selected' : '' }}>
                                                {{ $department->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.leave-balances.index') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الموظف</th>
                                    <th>رقم الموظف</th>
                                    <th>القسم</th>
                                    <th>نوع الإجازة</th>
                                    <th>الرصيد</th>
                                    <th>المستخدم</th>
                                    <th>المتبقي</th>
                                    <th>آخر تحديث</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($leaveBalances as $balance)
                                    <tr>
                                        <td>
                                            <a href="{{ route('hrm.employees.show', $balance->employee->id) }}">
                                                {{ $balance->employee->first_name }} {{ $balance->employee->last_name }}
                                            </a>
                                        </td>
                                        <td>{{ $balance->employee->employee_number }}</td>
                                        <td>{{ $balance->employee->department ? $balance->employee->department->name : '-' }}</td>
                                        <td>{{ $balance->leaveType->name }}</td>
                                        <td>{{ $balance->total_balance }}</td>
                                        <td>{{ $balance->used_balance }}</td>
                                        <td>{{ $balance->balance }}</td>
                                        <td>{{ $balance->updated_at->format('Y-m-d') }}</td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#editBalanceModal{{ $balance->id }}">
                                                <i class="fas fa-edit"></i> تعديل
                                            </button>

                                            <!-- Edit Balance Modal -->
                                            <div class="modal fade" id="editBalanceModal{{ $balance->id }}" tabindex="-1" role="dialog" aria-labelledby="editBalanceModalLabel{{ $balance->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="editBalanceModalLabel{{ $balance->id }}">تعديل رصيد الإجازة</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('hrm.leave-balances.adjust', $balance->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label>الموظف:</label>
                                                                    <input type="text" class="form-control" value="{{ $balance->employee->first_name }} {{ $balance->employee->last_name }}" readonly>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label>نوع الإجازة:</label>
                                                                    <input type="text" class="form-control" value="{{ $balance->leaveType->name }}" readonly>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label>الرصيد الحالي:</label>
                                                                    <input type="text" class="form-control" value="{{ $balance->balance }}" readonly>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="adjustment_type{{ $balance->id }}">نوع التعديل <span class="text-danger">*</span></label>
                                                                    <select name="adjustment_type" id="adjustment_type{{ $balance->id }}" class="form-control" required>
                                                                        <option value="add">إضافة رصيد</option>
                                                                        <option value="subtract">خصم رصيد</option>
                                                                        <option value="set">تعيين رصيد جديد</option>
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="amount{{ $balance->id }}">القيمة <span class="text-danger">*</span></label>
                                                                    <input type="number" name="amount" id="amount{{ $balance->id }}" class="form-control" min="0" step="0.5" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="reason{{ $balance->id }}">سبب التعديل <span class="text-danger">*</span></label>
                                                                    <textarea name="reason" id="reason{{ $balance->id }}" class="form-control" rows="3" required></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد أرصدة إجازات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $leaveBalances->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- سجل تعديلات الأرصدة -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">سجل تعديلات الأرصدة</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>نوع الإجازة</th>
                                    <th>نوع التعديل</th>
                                    <th>القيمة</th>
                                    <th>الرصيد قبل</th>
                                    <th>الرصيد بعد</th>
                                    <th>السبب</th>
                                    <th>بواسطة</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($adjustments as $adjustment)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $adjustment->employee->first_name }} {{ $adjustment->employee->last_name }}</td>
                                        <td>{{ $adjustment->leaveType->name }}</td>
                                        <td>
                                            @if($adjustment->adjustment_type == 'add')
                                                <span class="badge badge-success">إضافة</span>
                                            @elseif($adjustment->adjustment_type == 'subtract')
                                                <span class="badge badge-danger">خصم</span>
                                            @elseif($adjustment->adjustment_type == 'set')
                                                <span class="badge badge-info">تعيين</span>
                                            @endif
                                        </td>
                                        <td>{{ $adjustment->amount }}</td>
                                        <td>{{ $adjustment->balance_before }}</td>
                                        <td>{{ $adjustment->balance_after }}</td>
                                        <td>{{ Str::limit($adjustment->reason, 30) }}</td>
                                        <td>{{ $adjustment->user ? $adjustment->user->name : 'النظام' }}</td>
                                        <td>{{ $adjustment->created_at->format('Y-m-d H:i') }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد تعديلات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Adjust Balance Modal -->
<div class="modal fade" id="adjustBalanceModal" tabindex="-1" role="dialog" aria-labelledby="adjustBalanceModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustBalanceModalLabel">تعديل رصيد إجازة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.leave-balances.adjust-single') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id_modal">الموظف <span class="text-danger">*</span></label>
                        <select name="employee_id" id="employee_id_modal" class="form-control" required>
                            <option value="">-- اختر الموظف --</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">
                                    {{ $employee->first_name }} {{ $employee->last_name }} ({{ $employee->employee_number }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="leave_type_id_modal">نوع الإجازة <span class="text-danger">*</span></label>
                        <select name="leave_type_id" id="leave_type_id_modal" class="form-control" required>
                            <option value="">-- اختر نوع الإجازة --</option>
                            @foreach($leaveTypes as $leaveType)
                                <option value="{{ $leaveType->id }}">
                                    {{ $leaveType->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="adjustment_type_modal">نوع التعديل <span class="text-danger">*</span></label>
                        <select name="adjustment_type" id="adjustment_type_modal" class="form-control" required>
                            <option value="add">إضافة رصيد</option>
                            <option value="subtract">خصم رصيد</option>
                            <option value="set">تعيين رصيد جديد</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="amount_modal">القيمة <span class="text-danger">*</span></label>
                        <input type="number" name="amount" id="amount_modal" class="form-control" min="0" step="0.5" required>
                    </div>
                    <div class="form-group">
                        <label for="reason_modal">سبب التعديل <span class="text-danger">*</span></label>
                        <textarea name="reason" id="reason_modal" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Bulk Adjust Modal -->
<div class="modal fade" id="bulkAdjustModal" tabindex="-1" role="dialog" aria-labelledby="bulkAdjustModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bulkAdjustModalLabel">تعديل جماعي لأرصدة الإجازات</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.leave-balances.adjust-bulk') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="bulk_department_id">القسم</label>
                                <select name="department_id" id="bulk_department_id" class="form-control">
                                    <option value="">-- جميع الأقسام --</option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}">
                                            {{ $department->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">اختر القسم لتطبيق التعديل على جميع موظفي القسم</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="bulk_leave_type_id">نوع الإجازة <span class="text-danger">*</span></label>
                                <select name="leave_type_id" id="bulk_leave_type_id" class="form-control" required>
                                    <option value="">-- اختر نوع الإجازة --</option>
                                    @foreach($leaveTypes as $leaveType)
                                        <option value="{{ $leaveType->id }}">
                                            {{ $leaveType->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="bulk_adjustment_type">نوع التعديل <span class="text-danger">*</span></label>
                                <select name="adjustment_type" id="bulk_adjustment_type" class="form-control" required>
                                    <option value="add">إضافة رصيد</option>
                                    <option value="subtract">خصم رصيد</option>
                                    <option value="set">تعيين رصيد جديد</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="bulk_amount">القيمة <span class="text-danger">*</span></label>
                                <input type="number" name="amount" id="bulk_amount" class="form-control" min="0" step="0.5" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="bulk_apply_to">تطبيق على</label>
                                <select name="apply_to" id="bulk_apply_to" class="form-control">
                                    <option value="all">جميع الموظفين</option>
                                    <option value="active">الموظفين النشطين فقط</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="bulk_reason">سبب التعديل <span class="text-danger">*</span></label>
                        <textarea name="reason" id="bulk_reason" class="form-control" rows="3" required></textarea>
                    </div>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> تنبيه: سيتم تطبيق هذا التعديل على جميع الموظفين المحددين. يرجى التأكد من صحة البيانات قبل الحفظ.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تطبيق التعديل</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection