@extends('layouts.modern')

@section('title', 'تفاصيل التقييم')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>تفاصيل التقييم</h3>
                    <div>
                        <a href="{{ route('hrm.evaluations.export-pdf', $evaluation->id) }}" class="btn btn-secondary">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </a>
                        @if($evaluation->status != 'acknowledged')
                            <a href="{{ route('hrm.evaluations.edit', $evaluation->id) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                        @endif
                        <a href="{{ route('hrm.evaluations.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    @if (session('info'))
                        <div class="alert alert-info">
                            {{ session('info') }}
                        </div>
                    @endif

                    <div class="row">
                        <!-- معلومات التقييم الأساسية -->
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">معلومات التقييم الأساسية</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3 mb-3">
                                            <strong>الموظف:</strong>
                                            <p>{{ $evaluation->employee->name ?? 'غير محدد' }}</p>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <strong>المقيم:</strong>
                                            <p>{{ $evaluation->evaluator->name ?? 'غير محدد' }}</p>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <strong>تاريخ التقييم:</strong>
                                            <p>{{ $evaluation->evaluation_date->format('Y-m-d') }}</p>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <strong>فترة التقييم:</strong>
                                            <p>{{ $evaluation->evaluation_period }}</p>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <strong>حالة التقييم:</strong>
                                            <p>
                                                @if($evaluation->status == 'draft')
                                                    <span class="badge badge-secondary">مسودة</span>
                                                @elseif($evaluation->status == 'completed')
                                                    <span class="badge badge-primary">مكتمل</span>
                                                @elseif($evaluation->status == 'acknowledged')
                                                    <span class="badge badge-success">تم الاطلاع</span>
                                                @endif
                                            </p>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <strong>الدرجة الإجمالية:</strong>
                                            <p>
                                                <span class="badge {{ $evaluation->total_score >= 7 ? 'badge-success' : ($evaluation->total_score >= 5 ? 'badge-warning' : 'badge-danger') }}">
                                                    {{ number_format($evaluation->total_score, 1) }} / 10
                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- درجات التقييم -->
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">درجات التقييم</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <canvas id="evaluationRadarChart" width="400" height="300"></canvas>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="table-responsive">
                                                <table class="table table-bordered">
                                                    <thead class="thead-light">
                                                        <tr>
                                                            <th>المجال</th>
                                                            <th>الدرجة</th>
                                                            <th>التقييم</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الأداء الوظيفي</td>
                                                            <td>{{ number_format($evaluation->performance_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->performance_score >= 7 ? 'bg-success' : ($evaluation->performance_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->performance_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->performance_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>الحضور والانضباط</td>
                                                            <td>{{ number_format($evaluation->attendance_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->attendance_score >= 7 ? 'bg-success' : ($evaluation->attendance_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->attendance_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->attendance_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>جودة العمل</td>
                                                            <td>{{ number_format($evaluation->quality_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->quality_score >= 7 ? 'bg-success' : ($evaluation->quality_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->quality_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->quality_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>العمل الجماعي</td>
                                                            <td>{{ number_format($evaluation->teamwork_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->teamwork_score >= 7 ? 'bg-success' : ($evaluation->teamwork_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->teamwork_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->teamwork_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>المبادرة والابتكار</td>
                                                            <td>{{ number_format($evaluation->initiative_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->initiative_score >= 7 ? 'bg-success' : ($evaluation->initiative_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->initiative_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->initiative_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>مهارات الاتصال</td>
                                                            <td>{{ number_format($evaluation->communication_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->communication_score >= 7 ? 'bg-success' : ($evaluation->communication_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->communication_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->communication_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>القيادة</td>
                                                            <td>{{ number_format($evaluation->leadership_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->leadership_score >= 7 ? 'bg-success' : ($evaluation->leadership_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->leadership_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->leadership_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>المهارات الفنية</td>
                                                            <td>{{ number_format($evaluation->technical_score, 1) }}</td>
                                                            <td>
                                                                <div class="progress">
                                                                    <div class="progress-bar {{ $evaluation->technical_score >= 7 ? 'bg-success' : ($evaluation->technical_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                        role="progressbar" 
                                                                        style="width: {{ $evaluation->technical_score * 10 }}%" 
                                                                        aria-valuenow="{{ $evaluation->technical_score }}" 
                                                                        aria-valuemin="0" 
                                                                        aria-valuemax="10">
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- ملاحظات التقييم -->
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">ملاحظات التقييم</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <div class="card h-100">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0">نقاط القوة</h6>
                                                </div>
                                                <div class="card-body">
                                                    @if(is_array($evaluation->strengths) && count($evaluation->strengths) > 0)
                                                        <ul class="list-group list-group-flush">
                                                            @foreach($evaluation->strengths as $strength)
                                                                <li class="list-group-item">{{ $strength }}</li>
                                                            @endforeach
                                                        </ul>
                                                    @else
                                                        <p class="text-muted">لا توجد نقاط قوة مسجلة</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="card h-100">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0">مجالات التحسين</h6>
                                                </div>
                                                <div class="card-body">
                                                    @if(is_array($evaluation->areas_for_improvement) && count($evaluation->areas_for_improvement) > 0)
                                                        <ul class="list-group list-group-flush">
                                                            @foreach($evaluation->areas_for_improvement as $area)
                                                                <li class="list-group-item">{{ $area }}</li>
                                                            @endforeach
                                                        </ul>
                                                    @else
                                                        <p class="text-muted">لا توجد مجالات تحسين مسجلة</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="card h-100">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0">الأهداف المستقبلية</h6>
                                                </div>
                                                <div class="card-body">
                                                    @if(is_array($evaluation->goals) && count($evaluation->goals) > 0)
                                                        <ul class="list-group list-group-flush">
                                                            @foreach($evaluation->goals as $goal)
                                                                <li class="list-group-item">{{ $goal }}</li>
                                                            @endforeach
                                                        </ul>
                                                    @else
                                                        <p class="text-muted">لا توجد أهداف مستقبلية مسجلة</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12 mt-3">
                                            <div class="card">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0">ملاحظات إضافية</h6>
                                                </div>
                                                <div class="card-body">
                                                    @if($evaluation->comments)
                                                        <p>{{ $evaluation->comments }}</p>
                                                    @else
                                                        <p class="text-muted">لا توجد ملاحظات إضافية</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- تعليقات الموظف -->
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">تعليقات الموظف</h5>
                                </div>
                                <div class="card-body">
                                    @if($evaluation->status == 'acknowledged')
                                        <div class="alert alert-info">
                                            <p>{{ $evaluation->employee_comments }}</p>
                                        </div>
                                    @elseif($evaluation->status == 'completed')
                                        <form method="POST" action="{{ route('hrm.evaluations.employee-comments', $evaluation->id) }}">
                                            @csrf
                                            <div class="form-group">
                                                <label for="employee_comments">أضف تعليقاتك على التقييم</label>
                                                <textarea name="employee_comments" id="employee_comments" class="form-control @error('employee_comments') is-invalid @enderror" rows="4" required>{{ old('employee_comments') }}</textarea>
                                                @error('employee_comments')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save"></i> حفظ التعليقات
                                            </button>
                                        </form>
                                    @else
                                        <div class="alert alert-warning">
                                            <p>لا يمكن إضافة تعليقات الموظف حتى يتم اكتمال التقييم.</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // إنشاء مخطط الرادار للتقييم
        var ctx = document.getElementById('evaluationRadarChart').getContext('2d');
        var evaluationRadarChart = new Chart(ctx, {
            type: 'radar',
            data: {
                labels: [
                    'الأداء الوظيفي',
                    'الحضور والانضباط',
                    'جودة العمل',
                    'العمل الجماعي',
                    'المبادرة والابتكار',
                    'مهارات الاتصال',
                    'القيادة',
                    'المهارات الفنية'
                ],
                datasets: [{
                    label: 'درجات التقييم',
                    data: [
                        {{ $evaluation->performance_score }},
                        {{ $evaluation->attendance_score }},
                        {{ $evaluation->quality_score }},
                        {{ $evaluation->teamwork_score }},
                        {{ $evaluation->initiative_score }},
                        {{ $evaluation->communication_score }},
                        {{ $evaluation->leadership_score }},
                        {{ $evaluation->technical_score }}
                    ],
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 2,
                    pointBackgroundColor: 'rgba(54, 162, 235, 1)',
                    pointBorderColor: '#fff',
                    pointHoverBackgroundColor: '#fff',
                    pointHoverBorderColor: 'rgba(54, 162, 235, 1)'
                }]
            },
            options: {
                scales: {
                    r: {
                        angleLines: {
                            display: true
                        },
                        suggestedMin: 0,
                        suggestedMax: 10
                    }
                }
            }
        });
    });
</script>
@endpush
@endsection