@extends('layouts.modern')

@section('title', 'تقرير تقييمات الموظفين')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>تقرير تقييمات الموظفين</h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-secondary">
                            <i class="fas fa-print"></i> طباعة التقرير
                        </button>
                        <a href="{{ route('hrm.evaluations.index') }}" class="btn btn-primary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="card mb-4 no-print">
                        <div class="card-header">
                            <h5>فلترة التقرير</h5>
                        </div>
                        <div class="card-body">
                            <form method="GET" action="{{ route('hrm.evaluations.report') }}" class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="employee_id">الموظف</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">جميع الموظفين</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ $employeeId == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="period">الفترة</label>
                                    <input type="text" name="period" id="period" class="form-control" value="{{ $period }}" placeholder="مثال: الربع الأول">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="year">السنة</label>
                                    <select name="year" id="year" class="form-control">
                                        <option value="">جميع السنوات</option>
                                        @for($i = date('Y'); $i >= date('Y') - 5; $i--)
                                            <option value="{{ $i }}" {{ $year == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-12 text-center">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> عرض التقرير
                                    </button>
                                    <a href="{{ route('hrm.evaluations.report') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- ملخص التقرير -->
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">ملخص التقرير</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <h5>عدد الموظفين المقيمين</h5>
                                            <h2 class="text-primary">{{ count($reportData) }}</h2>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <h5>عدد التقييمات</h5>
                                            <h2 class="text-info">{{ array_sum(array_column($reportData, 'evaluations_count')) }}</h2>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div class="card">
                                        <div class="card-body text-center">
                                            <h5>متوسط التقييم العام</h5>
                                            @php
                                                $totalScore = 0;
                                                $totalCount = 0;
                                                foreach ($reportData as $data) {
                                                    $totalScore += $data['total_score'];
                                                    $totalCount += $data['evaluations_count'];
                                                }
                                                $avgScore = $totalCount > 0 ? $totalScore / $totalCount : 0;
                                            @endphp
                                            <h2 class="{{ $avgScore >= 7 ? 'text-success' : ($avgScore >= 5 ? 'text-warning' : 'text-danger') }}">
                                                {{ number_format($avgScore, 1) }}
                                            </h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- مخطط المقارنة -->
                    <div class="card mb-4">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">مقارنة أداء الموظفين</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <canvas id="employeesComparisonChart" width="400" height="200"></canvas>
                                </div>
                                <div class="col-md-4">
                                    <h5 class="border-bottom pb-2">أعلى 5 موظفين أداءً</h5>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>الموظف</th>
                                                    <th>متوسط التقييم</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $sortedData = collect($reportData)->sortByDesc(function ($data) {
                                                        return $data['average_score'];
                                                    })->take(5);
                                                @endphp
                                                @foreach($sortedData as $data)
                                                    <tr>
                                                        <td>{{ $data['employee']->name }}</td>
                                                        <td>
                                                            <span class="badge {{ $data['average_score'] >= 7 ? 'badge-success' : ($data['average_score'] >= 5 ? 'badge-warning' : 'badge-danger') }}">
                                                                {{ number_format($data['average_score'], 1) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تفاصيل التقييمات حسب الموظف -->
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">تفاصيل التقييمات حسب الموظف</h5>
                        </div>
                        <div class="card-body">
                            @if(count($reportData) > 0)
                                <div class="accordion" id="employeeEvaluationsAccordion">
                                    @foreach($reportData as $employeeId => $data)
                                        <div class="card mb-3">
                                            <div class="card-header" id="heading{{ $employeeId }}">
                                                <h2 class="mb-0">
                                                    <button class="btn btn-link btn-block text-right" type="button" data-toggle="collapse" data-target="#collapse{{ $employeeId }}" aria-expanded="true" aria-controls="collapse{{ $employeeId }}">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <span>{{ $data['employee']->name }} ({{ $data['evaluations_count'] }} تقييم)</span>
                                                            <span class="badge {{ $data['average_score'] >= 7 ? 'badge-success' : ($data['average_score'] >= 5 ? 'badge-warning' : 'badge-danger') }}">
                                                                {{ number_format($data['average_score'], 1) }}
                                                            </span>
                                                        </div>
                                                    </button>
                                                </h2>
                                            </div>

                                            <div id="collapse{{ $employeeId }}" class="collapse" aria-labelledby="heading{{ $employeeId }}" data-parent="#employeeEvaluationsAccordion">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <canvas id="employeeRadarChart{{ $employeeId }}" width="400" height="300"></canvas>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="table-responsive">
                                                                <table class="table table-bordered">
                                                                    <thead class="thead-light">
                                                                        <tr>
                                                                            <th>المجال</th>
                                                                            <th>متوسط الدرجة</th>
                                                                            <th>التقييم</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr>
                                                                            <td>الأداء الوظيفي</td>
                                                                            <td>{{ number_format($data['performance_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['performance_avg'] >= 7 ? 'bg-success' : ($data['performance_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['performance_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['performance_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>الحضور والانضباط</td>
                                                                            <td>{{ number_format($data['attendance_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['attendance_avg'] >= 7 ? 'bg-success' : ($data['attendance_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['attendance_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['attendance_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>جودة العمل</td>
                                                                            <td>{{ number_format($data['quality_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['quality_avg'] >= 7 ? 'bg-success' : ($data['quality_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['quality_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['quality_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>العمل الجماعي</td>
                                                                            <td>{{ number_format($data['teamwork_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['teamwork_avg'] >= 7 ? 'bg-success' : ($data['teamwork_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['teamwork_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['teamwork_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>المبادرة والابتكار</td>
                                                                            <td>{{ number_format($data['initiative_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['initiative_avg'] >= 7 ? 'bg-success' : ($data['initiative_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['initiative_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['initiative_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>مهارات الاتصال</td>
                                                                            <td>{{ number_format($data['communication_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['communication_avg'] >= 7 ? 'bg-success' : ($data['communication_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['communication_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['communication_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>القيادة</td>
                                                                            <td>{{ number_format($data['leadership_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['leadership_avg'] >= 7 ? 'bg-success' : ($data['leadership_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['leadership_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['leadership_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>المهارات الفنية</td>
                                                                            <td>{{ number_format($data['technical_avg'], 1) }}</td>
                                                                            <td>
                                                                                <div class="progress">
                                                                                    <div class="progress-bar {{ $data['technical_avg'] >= 7 ? 'bg-success' : ($data['technical_avg'] >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                                                        role="progressbar" 
                                                                                        style="width: {{ $data['technical_avg'] * 10 }}%" 
                                                                                        aria-valuenow="{{ $data['technical_avg'] }}" 
                                                                                        aria-valuemin="0" 
                                                                                        aria-valuemax="10">
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <h5 class="mt-4 border-bottom pb-2">تفاصيل التقييمات</h5>
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered table-striped">
                                                            <thead class="thead-dark">
                                                                <tr>
                                                                    <th>تاريخ التقييم</th>
                                                                    <th>الفترة</th>
                                                                    <th>المقيم</th>
                                                                    <th>الدرجة الإجمالية</th>
                                                                    <th>الحالة</th>
                                                                    <th>الإجراءات</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($data['evaluations'] as $evaluation)
                                                                    <tr>
                                                                        <td>{{ $evaluation->evaluation_date->format('Y-m-d') }}</td>
                                                                        <td>{{ $evaluation->evaluation_period }}</td>
                                                                        <td>{{ $evaluation->evaluator->name ?? 'غير محدد' }}</td>
                                                                        <td>
                                                                            <span class="badge {{ $evaluation->total_score >= 7 ? 'badge-success' : ($evaluation->total_score >= 5 ? 'badge-warning' : 'badge-danger') }}">
                                                                                {{ number_format($evaluation->total_score, 1) }}
                                                                            </span>
                                                                        </td>
                                                                        <td>
                                                                            @if($evaluation->status == 'draft')
                                                                                <span class="badge badge-secondary">مسودة</span>
                                                                            @elseif($evaluation->status == 'completed')
                                                                                <span class="badge badge-primary">مكتمل</span>
                                                                            @elseif($evaluation->status == 'acknowledged')
                                                                                <span class="badge badge-success">تم الاطلاع</span>
                                                                            @endif
                                                                        </td>
                                                                        <td>
                                                                            <a href="{{ route('hrm.evaluations.show', $evaluation->id) }}" class="btn btn-sm btn-info" title="عرض">
                                                                                <i class="fas fa-eye"></i>
                                                                            </a>
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="alert alert-info">
                                    <p class="mb-0">لا توجد بيانات تقييم متاحة للفترة المحددة.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            border: none !important;
        }
        .card-header {
            background-color: #f8f9fa !important;
            color: #000 !important;
            border-bottom: 1px solid #ddd !important;
        }
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // مخطط مقارنة الموظفين
        var employeesComparisonCtx = document.getElementById('employeesComparisonChart').getContext('2d');
        var employeesComparisonChart = new Chart(employeesComparisonCtx, {
            type: 'bar',
            data: {
                labels: [
                    @foreach($reportData as $employeeId => $data)
                        '{{ $data['employee']->name }}',
                    @endforeach
                ],
                datasets: [{
                    label: 'متوسط التقييم',
                    data: [
                        @foreach($reportData as $employeeId => $data)
                            {{ $data['average_score'] }},
                        @endforeach
                    ],
                    backgroundColor: [
                        @foreach($reportData as $employeeId => $data)
                            '{{ $data['average_score'] >= 7 ? 'rgba(40, 167, 69, 0.7)' : ($data['average_score'] >= 5 ? 'rgba(255, 193, 7, 0.7)' : 'rgba(220, 53, 69, 0.7)') }}',
                        @endforeach
                    ],
                    borderColor: [
                        @foreach($reportData as $employeeId => $data)
                            '{{ $data['average_score'] >= 7 ? 'rgba(40, 167, 69, 1)' : ($data['average_score'] >= 5 ? 'rgba(255, 193, 7, 1)' : 'rgba(220, 53, 69, 1)') }}',
                        @endforeach
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 10
                    }
                }
            }
        });

        // مخططات الرادار لكل موظف
        @foreach($reportData as $employeeId => $data)
            var employeeRadarCtx{{ $employeeId }} = document.getElementById('employeeRadarChart{{ $employeeId }}').getContext('2d');
            var employeeRadarChart{{ $employeeId }} = new Chart(employeeRadarCtx{{ $employeeId }}, {
                type: 'radar',
                data: {
                    labels: [
                        'الأداء الوظيفي',
                        'الحضور والانضباط',
                        'جودة العمل',
                        'العمل الجماعي',
                        'المبادرة والابتكار',
                        'مهارات الاتصال',
                        'القيادة',
                        'المهارات الفنية'
                    ],
                    datasets: [{
                        label: 'متوسط الدرجات',
                        data: [
                            {{ $data['performance_avg'] }},
                            {{ $data['attendance_avg'] }},
                            {{ $data['quality_avg'] }},
                            {{ $data['teamwork_avg'] }},
                            {{ $data['initiative_avg'] }},
                            {{ $data['communication_avg'] }},
                            {{ $data['leadership_avg'] }},
                            {{ $data['technical_avg'] }}
                        ],
                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 2,
                        pointBackgroundColor: 'rgba(54, 162, 235, 1)',
                        pointBorderColor: '#fff',
                        pointHoverBackgroundColor: '#fff',
                        pointHoverBorderColor: 'rgba(54, 162, 235, 1)'
                    }]
                },
                options: {
                    scales: {
                        r: {
                            angleLines: {
                                display: true
                            },
                            suggestedMin: 0,
                            suggestedMax: 10
                        }
                    }
                }
            });
        @endforeach
    });
</script>
@endpush
@endsection