@extends('layouts.modern')

@section('title', 'تقييمات الموظفين')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>تقييمات الموظفين</h3>
                    <div>
                        <a href="{{ route('hrm.evaluations.report') }}" class="btn btn-info">
                            <i class="fas fa-chart-bar"></i> تقرير التقييمات
                        </a>
                        <a href="{{ route('hrm.evaluations.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة تقييم جديد
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>فلترة النتائج</h5>
                        </div>
                        <div class="card-body">
                            <form method="GET" action="{{ route('hrm.evaluations.index') }}" class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="employee_id">الموظف</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">جميع الموظفين</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">جميع الحالات</option>
                                        @foreach($statuses as $key => $value)
                                            <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="period">الفترة</label>
                                    <input type="text" name="period" id="period" class="form-control" value="{{ request('period') }}" placeholder="مثال: الربع الأول 2023">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="date_from">من تاريخ</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="date_to">إلى تاريخ</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                                <div class="col-md-12 text-center">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                    <a href="{{ route('hrm.evaluations.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- جدول التقييمات -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>المقيم</th>
                                    <th>تاريخ التقييم</th>
                                    <th>الفترة</th>
                                    <th>الدرجة الإجمالية</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($evaluations as $evaluation)
                                    <tr>
                                        <td>{{ $evaluation->id }}</td>
                                        <td>{{ $evaluation->employee->name ?? 'غير محدد' }}</td>
                                        <td>{{ $evaluation->evaluator->name ?? 'غير محدد' }}</td>
                                        <td>{{ $evaluation->evaluation_date->format('Y-m-d') }}</td>
                                        <td>{{ $evaluation->evaluation_period }}</td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar {{ $evaluation->total_score >= 7 ? 'bg-success' : ($evaluation->total_score >= 5 ? 'bg-warning' : 'bg-danger') }}" 
                                                    role="progressbar" 
                                                    style="width: {{ $evaluation->total_score * 10 }}%" 
                                                    aria-valuenow="{{ $evaluation->total_score }}" 
                                                    aria-valuemin="0" 
                                                    aria-valuemax="10">
                                                    {{ number_format($evaluation->total_score, 1) }}
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @if($evaluation->status == 'draft')
                                                <span class="badge badge-secondary">مسودة</span>
                                            @elseif($evaluation->status == 'completed')
                                                <span class="badge badge-primary">مكتمل</span>
                                            @elseif($evaluation->status == 'acknowledged')
                                                <span class="badge badge-success">تم الاطلاع</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.evaluations.show', $evaluation->id) }}" class="btn btn-sm btn-info" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($evaluation->status != 'acknowledged')
                                                    <a href="{{ route('hrm.evaluations.edit', $evaluation->id) }}" class="btn btn-sm btn-primary" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('hrm.evaluations.destroy', $evaluation->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا التقييم؟')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                <a href="{{ route('hrm.evaluations.export-pdf', $evaluation->id) }}" class="btn btn-sm btn-secondary" title="تصدير PDF">
                                                    <i class="fas fa-file-pdf"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد تقييمات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- ترقيم الصفحات -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $evaluations->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection