@extends('layouts.modern')

@section('title', 'إضافة تقييم جديد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3>إضافة تقييم جديد</h3>
                    <a href="{{ route('hrm.evaluations.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('hrm.evaluations.store') }}">
                        @csrf

                        <div class="row">
                            <!-- معلومات التقييم الأساسية -->
                            <div class="col-md-12 mb-4">
                                <h4 class="border-bottom pb-2">معلومات التقييم الأساسية</h4>
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="employee_id" class="form-label">الموظف <span class="text-danger">*</span></label>
                                <select name="employee_id" id="employee_id" class="form-control @error('employee_id') is-invalid @enderror" required>
                                    <option value="">اختر الموظف</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="evaluator_id" class="form-label">المقيم <span class="text-danger">*</span></label>
                                <select name="evaluator_id" id="evaluator_id" class="form-control @error('evaluator_id') is-invalid @enderror" required>
                                    <option value="">اختر المقيم</option>
                                    @foreach($evaluators as $evaluator)
                                        <option value="{{ $evaluator->id }}" {{ old('evaluator_id') == $evaluator->id ? 'selected' : '' }}>
                                            {{ $evaluator->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('evaluator_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="evaluation_date" class="form-label">تاريخ التقييم <span class="text-danger">*</span></label>
                                <input type="date" name="evaluation_date" id="evaluation_date" class="form-control @error('evaluation_date') is-invalid @enderror" value="{{ old('evaluation_date', date('Y-m-d')) }}" required>
                                @error('evaluation_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="evaluation_period" class="form-label">فترة التقييم <span class="text-danger">*</span></label>
                                <input type="text" name="evaluation_period" id="evaluation_period" class="form-control @error('evaluation_period') is-invalid @enderror" value="{{ old('evaluation_period') }}" placeholder="مثال: الربع الأول 2023" required>
                                @error('evaluation_period')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">حالة التقييم <span class="text-danger">*</span></label>
                                <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                    <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                    <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- درجات التقييم -->
                            <div class="col-md-12 mt-4 mb-3">
                                <h4 class="border-bottom pb-2">درجات التقييم</h4>
                                <p class="text-muted">قم بتقييم الموظف في كل مجال من المجالات التالية (من 0 إلى 10)</p>
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="performance_score" class="form-label">الأداء الوظيفي <span class="text-danger">*</span></label>
                                <input type="number" name="performance_score" id="performance_score" class="form-control @error('performance_score') is-invalid @enderror" value="{{ old('performance_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('performance_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="attendance_score" class="form-label">الحضور والانضباط <span class="text-danger">*</span></label>
                                <input type="number" name="attendance_score" id="attendance_score" class="form-control @error('attendance_score') is-invalid @enderror" value="{{ old('attendance_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('attendance_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="quality_score" class="form-label">جودة العمل <span class="text-danger">*</span></label>
                                <input type="number" name="quality_score" id="quality_score" class="form-control @error('quality_score') is-invalid @enderror" value="{{ old('quality_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('quality_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="teamwork_score" class="form-label">العمل الجماعي <span class="text-danger">*</span></label>
                                <input type="number" name="teamwork_score" id="teamwork_score" class="form-control @error('teamwork_score') is-invalid @enderror" value="{{ old('teamwork_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('teamwork_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="initiative_score" class="form-label">المبادرة والابتكار <span class="text-danger">*</span></label>
                                <input type="number" name="initiative_score" id="initiative_score" class="form-control @error('initiative_score') is-invalid @enderror" value="{{ old('initiative_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('initiative_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="communication_score" class="form-label">مهارات الاتصال <span class="text-danger">*</span></label>
                                <input type="number" name="communication_score" id="communication_score" class="form-control @error('communication_score') is-invalid @enderror" value="{{ old('communication_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('communication_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="leadership_score" class="form-label">القيادة <span class="text-danger">*</span></label>
                                <input type="number" name="leadership_score" id="leadership_score" class="form-control @error('leadership_score') is-invalid @enderror" value="{{ old('leadership_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('leadership_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-3 mb-3">
                                <label for="technical_score" class="form-label">المهارات الفنية <span class="text-danger">*</span></label>
                                <input type="number" name="technical_score" id="technical_score" class="form-control @error('technical_score') is-invalid @enderror" value="{{ old('technical_score', 0) }}" min="0" max="10" step="0.1" required>
                                @error('technical_score')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- ملاحظات التقييم -->
                            <div class="col-md-12 mt-4 mb-3">
                                <h4 class="border-bottom pb-2">ملاحظات التقييم</h4>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="strengths" class="form-label">نقاط القوة</label>
                                <div class="strength-inputs">
                                    <div class="input-group mb-2">
                                        <input type="text" name="strengths[]" class="form-control" placeholder="أدخل نقطة قوة">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-success add-strength">+</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="areas_for_improvement" class="form-label">مجالات التحسين</label>
                                <div class="improvement-inputs">
                                    <div class="input-group mb-2">
                                        <input type="text" name="areas_for_improvement[]" class="form-control" placeholder="أدخل مجال للتحسين">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-success add-improvement">+</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="goals" class="form-label">الأهداف المستقبلية</label>
                                <div class="goal-inputs">
                                    <div class="input-group mb-2">
                                        <input type="text" name="goals[]" class="form-control" placeholder="أدخل هدفاً مستقبلياً">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-success add-goal">+</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label for="comments" class="form-label">ملاحظات إضافية</label>
                                <textarea name="comments" id="comments" class="form-control @error('comments') is-invalid @enderror" rows="4">{{ old('comments') }}</textarea>
                                @error('comments')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-12 mt-4 text-center">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-save"></i> حفظ التقييم
                                </button>
                                <a href="{{ route('hrm.evaluations.index') }}" class="btn btn-secondary btn-lg">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // إضافة نقاط قوة جديدة
        $('.add-strength').click(function() {
            $('.strength-inputs').append(`
                <div class="input-group mb-2">
                    <input type="text" name="strengths[]" class="form-control" placeholder="أدخل نقطة قوة">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-item">-</button>
                    </div>
                </div>
            `);
        });

        // إضافة مجالات تحسين جديدة
        $('.add-improvement').click(function() {
            $('.improvement-inputs').append(`
                <div class="input-group mb-2">
                    <input type="text" name="areas_for_improvement[]" class="form-control" placeholder="أدخل مجال للتحسين">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-item">-</button>
                    </div>
                </div>
            `);
        });

        // إضافة أهداف جديدة
        $('.add-goal').click(function() {
            $('.goal-inputs').append(`
                <div class="input-group mb-2">
                    <input type="text" name="goals[]" class="form-control" placeholder="أدخل هدفاً مستقبلياً">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-item">-</button>
                    </div>
                </div>
            `);
        });

        // حذف عنصر
        $(document).on('click', '.remove-item', function() {
            $(this).closest('.input-group').remove();
        });
    });
</script>
@endpush
@endsection