@extends('layouts.modern')

@section('title', 'تفاصيل الموظف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل الموظف: {{ $employee->first_name }} {{ $employee->last_name }}</h3>
                    <div>
                        <a href="{{ route('hrm.employees.edit', $employee->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('hrm.employees.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 text-center mb-4">
                            @if($employee->profile_picture)
                                <img src="{{ asset('storage/' . $employee->profile_picture) }}" alt="Profile Picture" class="img-thumbnail" style="max-width: 200px; max-height: 200px;">
                            @else
                                <img src="{{ asset('images/default-avatar.png') }}" alt="Default Avatar" class="img-thumbnail" style="max-width: 200px; max-height: 200px;">
                            @endif
                            <h4 class="mt-2">{{ $employee->first_name }} {{ $employee->last_name }}</h4>
                            <p class="text-muted">{{ $employee->jobTitle ? $employee->jobTitle->name : 'بدون مسمى وظيفي' }}</p>
                            <div class="mt-2">
                                @if($employee->status == 'active')
                                    <span class="badge badge-success">نشط</span>
                                @elseif($employee->status == 'inactive')
                                    <span class="badge badge-secondary">غير نشط</span>
                                @elseif($employee->status == 'on_leave')
                                    <span class="badge badge-info">في إجازة</span>
                                @elseif($employee->status == 'terminated')
                                    <span class="badge badge-danger">منتهي</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-9">
                            <ul class="nav nav-tabs" id="employeeTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="personal-tab" data-toggle="tab" href="#personal" role="tab" aria-controls="personal" aria-selected="true">المعلومات الشخصية</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="employment-tab" data-toggle="tab" href="#employment" role="tab" aria-controls="employment" aria-selected="false">معلومات العمل</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="financial-tab" data-toggle="tab" href="#financial" role="tab" aria-controls="financial" aria-selected="false">المعلومات المالية</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="documents-tab" data-toggle="tab" href="#documents" role="tab" aria-controls="documents" aria-selected="false">الوثائق</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="attendance-tab" data-toggle="tab" href="#attendance" role="tab" aria-controls="attendance" aria-selected="false">الحضور</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="leaves-tab" data-toggle="tab" href="#leaves" role="tab" aria-controls="leaves" aria-selected="false">الإجازات</a>
                                </li>
                            </ul>
                            <div class="tab-content mt-3" id="employeeTabContent">
                                <!-- المعلومات الشخصية -->
                                <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 40%">رقم الموظف</th>
                                                    <td>{{ $employee->employee_number }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الاسم بالعربية</th>
                                                    <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الاسم بالإنجليزية</th>
                                                    <td>{{ $employee->first_name_en }} {{ $employee->last_name_en }}</td>
                                                </tr>
                                                <tr>
                                                    <th>البريد الإلكتروني</th>
                                                    <td>{{ $employee->email ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>رقم الهاتف</th>
                                                    <td>{{ $employee->phone ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>رقم الطوارئ</th>
                                                    <td>{{ $employee->emergency_contact ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>العنوان</th>
                                                    <td>{{ $employee->address ?: '-' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 40%">رقم الهوية الوطنية</th>
                                                    <td>{{ $employee->national_id ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>رقم جواز السفر</th>
                                                    <td>{{ $employee->passport_number ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>تاريخ انتهاء جواز السفر</th>
                                                    <td>{{ $employee->passport_expiry ? $employee->passport_expiry->format('Y-m-d') : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الجنسية</th>
                                                    <td>{{ $employee->nationality ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>تاريخ الميلاد</th>
                                                    <td>{{ $employee->birth_date ? $employee->birth_date->format('Y-m-d') : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الجنس</th>
                                                    <td>
                                                        @if($employee->gender == 'male')
                                                            ذكر
                                                        @elseif($employee->gender == 'female')
                                                            أنثى
                                                        @elseif($employee->gender == 'other')
                                                            آخر
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>الحالة الاجتماعية</th>
                                                    <td>
                                                        @if($employee->marital_status == 'single')
                                                            أعزب
                                                        @elseif($employee->marital_status == 'married')
                                                            متزوج
                                                        @elseif($employee->marital_status == 'divorced')
                                                            مطلق
                                                        @elseif($employee->marital_status == 'widowed')
                                                            أرمل
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- معلومات العمل -->
                                <div class="tab-pane fade" id="employment" role="tabpanel" aria-labelledby="employment-tab">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 40%">القسم</th>
                                                    <td>{{ $employee->department ? $employee->department->name : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>المسمى الوظيفي</th>
                                                    <td>{{ $employee->jobTitle ? $employee->jobTitle->name : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الفرع</th>
                                                    <td>{{ $employee->branch ? $employee->branch->name : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>حساب المستخدم</th>
                                                    <td>{{ $employee->user ? $employee->user->name : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>المستوى التعليمي</th>
                                                    <td>{{ $employee->education_level ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>مجال الدراسة</th>
                                                    <td>{{ $employee->education_field ?: '-' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 40%">تاريخ التعيين</th>
                                                    <td>{{ $employee->join_date->format('Y-m-d') }}</td>
                                                </tr>
                                                <tr>
                                                    <th>تاريخ انتهاء فترة التجربة</th>
                                                    <td>{{ $employee->probation_end_date ? $employee->probation_end_date->format('Y-m-d') : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>تاريخ انتهاء العقد</th>
                                                    <td>{{ $employee->contract_end_date ? $employee->contract_end_date->format('Y-m-d') : '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>الحالة</th>
                                                    <td>
                                                        @if($employee->status == 'active')
                                                            <span class="badge badge-success">نشط</span>
                                                        @elseif($employee->status == 'inactive')
                                                            <span class="badge badge-secondary">غير نشط</span>
                                                        @elseif($employee->status == 'on_leave')
                                                            <span class="badge badge-info">في إجازة</span>
                                                        @elseif($employee->status == 'terminated')
                                                            <span class="badge badge-danger">منتهي</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>المهارات</th>
                                                    <td>
                                                        @if($employee->skills)
                                                            @foreach(json_decode($employee->skills) as $skill)
                                                                <span class="badge badge-info">{{ $skill }}</span>
                                                            @endforeach
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>ملاحظات</th>
                                                    <td>{{ $employee->notes ?: '-' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- المعلومات المالية -->
                                <div class="tab-pane fade" id="financial" role="tabpanel" aria-labelledby="financial-tab">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 40%">الراتب الأساسي</th>
                                                    <td>{{ number_format($employee->basic_salary, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th>بدل السكن</th>
                                                    <td>{{ number_format($employee->housing_allowance, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th>بدل النقل</th>
                                                    <td>{{ number_format($employee->transportation_allowance, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th>بدلات أخرى</th>
                                                    <td>{{ number_format($employee->other_allowances, 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <th>إجمالي الراتب</th>
                                                    <td>{{ number_format($employee->total_salary, 2) }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th style="width: 40%">اسم البنك</th>
                                                    <td>{{ $employee->bank_name ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>رقم الحساب</th>
                                                    <td>{{ $employee->bank_account ?: '-' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>رقم الآيبان</th>
                                                    <td>{{ $employee->iban ?: '-' }}</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- الوثائق -->
                                <div class="tab-pane fade" id="documents" role="tabpanel" aria-labelledby="documents-tab">
                                    <div class="mb-3">
                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#uploadDocumentModal">
                                            <i class="fas fa-upload"></i> رفع وثيقة جديدة
                                        </button>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>نوع الوثيقة</th>
                                                    <th>العنوان</th>
                                                    <th>تاريخ الانتهاء</th>
                                                    <th>ملاحظات</th>
                                                    <th>تاريخ الرفع</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($employee->documents as $document)
                                                    <tr>
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td>{{ $document->document_type }}</td>
                                                        <td>{{ $document->title }}</td>
                                                        <td>{{ $document->expiry_date ? $document->expiry_date->format('Y-m-d') : '-' }}</td>
                                                        <td>{{ $document->notes ?: '-' }}</td>
                                                        <td>{{ $document->created_at->format('Y-m-d') }}</td>
                                                        <td>
                                                            <div class="btn-group">
                                                                <a href="{{ asset('storage/' . $document->file_path) }}" class="btn btn-sm btn-info" target="_blank">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                                <a href="{{ asset('storage/' . $document->file_path) }}" class="btn btn-sm btn-success" download>
                                                                    <i class="fas fa-download"></i>
                                                                </a>
                                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteDocumentModal{{ $document->id }}">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>

                                                            <!-- Delete Document Modal -->
                                                            <div class="modal fade" id="deleteDocumentModal{{ $document->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteDocumentModalLabel{{ $document->id }}" aria-hidden="true">
                                                                <div class="modal-dialog" role="document">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title" id="deleteDocumentModalLabel{{ $document->id }}">تأكيد الحذف</h5>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            هل أنت متأكد من رغبتك في حذف الوثيقة <strong>{{ $document->title }}</strong>؟
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                            <form action="{{ route('hrm.employees.documents.delete', $document->id) }}" method="POST">
                                                                                @csrf
                                                                                @method('DELETE')
                                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="7" class="text-center">لا توجد وثائق</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!-- الحضور -->
                                <div class="tab-pane fade" id="attendance" role="tabpanel" aria-labelledby="attendance-tab">
                                    <div class="mb-3">
                                        <a href="{{ route('hrm.attendance.index', ['employee_id' => $employee->id]) }}" class="btn btn-primary">
                                            <i class="fas fa-calendar-check"></i> عرض سجل الحضور الكامل
                                        </a>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>التاريخ</th>
                                                    <th>وقت الحضور</th>
                                                    <th>وقت الانصراف</th>
                                                    <th>إجمالي الساعات</th>
                                                    <th>التأخير (دقائق)</th>
                                                    <th>الإضافي (دقائق)</th>
                                                    <th>الحالة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($employee->attendances()->orderBy('date', 'desc')->take(5)->get() as $attendance)
                                                    <tr>
                                                        <td>{{ $attendance->date->format('Y-m-d') }}</td>
                                                        <td>{{ $attendance->check_in ? $attendance->check_in->format('H:i') : '-' }}</td>
                                                        <td>{{ $attendance->check_out ? $attendance->check_out->format('H:i') : '-' }}</td>
                                                        <td>{{ $attendance->total_hours }}</td>
                                                        <td>{{ $attendance->late_minutes }}</td>
                                                        <td>{{ $attendance->overtime_minutes }}</td>
                                                        <td>
                                                            @if($attendance->status == 'present')
                                                                <span class="badge badge-success">حاضر</span>
                                                            @elseif($attendance->status == 'absent')
                                                                <span class="badge badge-danger">غائب</span>
                                                            @elseif($attendance->status == 'late')
                                                                <span class="badge badge-warning">متأخر</span>
                                                            @elseif($attendance->status == 'half_day')
                                                                <span class="badge badge-info">نصف يوم</span>
                                                            @elseif($attendance->status == 'on_leave')
                                                                <span class="badge badge-secondary">في إجازة</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="7" class="text-center">لا يوجد سجلات حضور</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!-- الإجازات -->
                                <div class="tab-pane fade" id="leaves" role="tabpanel" aria-labelledby="leaves-tab">
                                    <div class="mb-3">
                                        <a href="{{ route('hrm.leaves.index', ['employee_id' => $employee->id]) }}" class="btn btn-primary">
                                            <i class="fas fa-calendar-minus"></i> عرض سجل الإجازات الكامل
                                        </a>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>نوع الإجازة</th>
                                                    <th>تاريخ البداية</th>
                                                    <th>تاريخ النهاية</th>
                                                    <th>عدد الأيام</th>
                                                    <th>السبب</th>
                                                    <th>الحالة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($employee->leaves()->orderBy('start_date', 'desc')->take(5)->get() as $leave)
                                                    <tr>
                                                        <td>{{ $leave->leaveType->name }}</td>
                                                        <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                                        <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                                        <td>{{ $leave->total_days }}</td>
                                                        <td>{{ $leave->reason ?: '-' }}</td>
                                                        <td>
                                                            @if($leave->status == 'pending')
                                                                <span class="badge badge-warning">قيد الانتظار</span>
                                                            @elseif($leave->status == 'approved')
                                                                <span class="badge badge-success">موافق عليها</span>
                                                            @elseif($leave->status == 'rejected')
                                                                <span class="badge badge-danger">مرفوضة</span>
                                                            @elseif($leave->status == 'cancelled')
                                                                <span class="badge badge-secondary">ملغاة</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="6" class="text-center">لا يوجد سجلات إجازات</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Upload Document Modal -->
<div class="modal fade" id="uploadDocumentModal" tabindex="-1" role="dialog" aria-labelledby="uploadDocumentModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="uploadDocumentModalLabel">رفع وثيقة جديدة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.employees.documents.upload', $employee->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="document_type">نوع الوثيقة <span class="text-danger">*</span></label>
                        <input type="text" name="document_type" id="document_type" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="title">العنوان <span class="text-danger">*</span></label>
                        <input type="text" name="title" id="title" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="file">الملف <span class="text-danger">*</span></label>
                        <input type="file" name="file" id="file" class="form-control-file" required>
                        <small class="form-text text-muted">الحد الأقصى لحجم الملف: 10 ميجابايت</small>
                    </div>
                    <div class="form-group">
                        <label for="expiry_date">تاريخ الانتهاء</label>
                        <input type="date" name="expiry_date" id="expiry_date" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="notes">ملاحظات</label>
                        <textarea name="notes" id="notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">رفع</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection