@extends('layouts.modern')

@section('title', 'إدارة الموظفين')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">قائمة الموظفين</h3>
                    <div>
                        <a href="{{ route('hrm.employees.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة موظف جديد
                        </a>
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#importModal">
                            <i class="fas fa-file-import"></i> استيراد
                        </button>
                        <a href="{{ route('hrm.employees.export') }}" class="btn btn-info">
                            <i class="fas fa-file-export"></i> تصدير
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.employees.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <input type="text" name="search" class="form-control" placeholder="بحث..." value="{{ request('search') }}">
                                </div>
                                <div class="form-group mx-1">
                                    <select name="department_id" class="form-control">
                                        <option value="">-- جميع الأقسام --</option>
                                        @foreach($departments as $department)
                                            <option value="{{ $department->id }}" {{ request('department_id') == $department->id ? 'selected' : '' }}>
                                                {{ $department->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <select name="branch_id" class="form-control">
                                        <option value="">-- جميع الفروع --</option>
                                        @foreach($branches as $branch)
                                            <option value="{{ $branch->id }}" {{ request('branch_id') == $branch->id ? 'selected' : '' }}>
                                                {{ $branch->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <select name="status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>نشط</option>
                                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>غير نشط</option>
                                        <option value="on_leave" {{ request('status') == 'on_leave' ? 'selected' : '' }}>في إجازة</option>
                                        <option value="terminated" {{ request('status') == 'terminated' ? 'selected' : '' }}>منتهي</option>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.employees.index') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم الموظف</th>
                                    <th>الصورة</th>
                                    <th>الاسم</th>
                                    <th>القسم</th>
                                    <th>المسمى الوظيفي</th>
                                    <th>الفرع</th>
                                    <th>تاريخ التعيين</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($employees as $employee)
                                    <tr>
                                        <td>{{ $employee->employee_number }}</td>
                                        <td>
                                            @if($employee->profile_picture)
                                                <img src="{{ asset('storage/' . $employee->profile_picture) }}" alt="Profile Picture" class="img-thumbnail" width="50">
                                            @else
                                                <img src="{{ asset('images/default-avatar.png') }}" alt="Default Avatar" class="img-thumbnail" width="50">
                                            @endif
                                        </td>
                                        <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
                                        <td>{{ $employee->department ? $employee->department->name : '-' }}</td>
                                        <td>{{ $employee->jobTitle ? $employee->jobTitle->name : '-' }}</td>
                                        <td>{{ $employee->branch ? $employee->branch->name : '-' }}</td>
                                        <td>{{ $employee->join_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($employee->status == 'active')
                                                <span class="badge badge-success">نشط</span>
                                            @elseif($employee->status == 'inactive')
                                                <span class="badge badge-secondary">غير نشط</span>
                                            @elseif($employee->status == 'on_leave')
                                                <span class="badge badge-info">في إجازة</span>
                                            @elseif($employee->status == 'terminated')
                                                <span class="badge badge-danger">منتهي</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('hrm.employees.show', $employee->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.employees.edit', $employee->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $employee->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deleteModal{{ $employee->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $employee->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $employee->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف الموظف <strong>{{ $employee->first_name }} {{ $employee->last_name }}</strong>؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('hrm.employees.destroy', $employee->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا يوجد موظفين</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-3">
                        {{ $employees->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" role="dialog" aria-labelledby="importModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="importModalLabel">استيراد الموظفين</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.employees.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="importFile">ملف Excel</label>
                        <input type="file" name="file" id="importFile" class="form-control" required>
                        <small class="form-text text-muted">يرجى تحميل ملف Excel (.xlsx)</small>
                    </div>
                    <div class="mt-3">
                        <a href="{{ asset('templates/employees_import_template.xlsx') }}" class="btn btn-sm btn-info">
                            <i class="fas fa-download"></i> تحميل قالب الاستيراد
                        </a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">استيراد</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection