@extends('layouts.modern')

@section('title', 'تعديل بيانات الموظف')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل بيانات الموظف: {{ $employee->first_name }} {{ $employee->last_name }}</h3>
                </div>
                <form action="{{ route('hrm.employees.update', $employee->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12 mb-4">
                                <div class="text-center">
                                    <div class="img-thumbnail mb-2" style="width: 150px; height: 150px; overflow: hidden; margin: 0 auto;">
                                        <img id="profile-preview" src="{{ $employee->profile_picture ? asset('storage/' . $employee->profile_picture) : asset('images/default-avatar.png') }}" alt="Profile Picture" style="width: 100%; height: 100%; object-fit: cover;">
                                    </div>
                                    <div class="custom-file" style="max-width: 300px; margin: 0 auto;">
                                        <input type="file" class="custom-file-input" id="profile_picture" name="profile_picture" onchange="previewImage()">
                                        <label class="custom-file-label" for="profile_picture">تغيير الصورة</label>
                                    </div>
                                </div>
                            </div>

                            <!-- المعلومات الأساسية -->
                            <div class="col-md-12">
                                <h4 class="mb-3">المعلومات الأساسية</h4>
                                <hr>
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="employee_number">رقم الموظف <span class="text-danger">*</span></label>
                                <input type="text" name="employee_number" id="employee_number" class="form-control @error('employee_number') is-invalid @enderror" value="{{ old('employee_number', $employee->employee_number) }}" required>
                                @error('employee_number')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="first_name">الاسم الأول <span class="text-danger">*</span></label>
                                <input type="text" name="first_name" id="first_name" class="form-control @error('first_name') is-invalid @enderror" value="{{ old('first_name', $employee->first_name) }}" required>
                                @error('first_name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="last_name">الاسم الأخير <span class="text-danger">*</span></label>
                                <input type="text" name="last_name" id="last_name" class="form-control @error('last_name') is-invalid @enderror" value="{{ old('last_name', $employee->last_name) }}" required>
                                @error('last_name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="user_id">حساب المستخدم</label>
                                <select name="user_id" id="user_id" class="form-control @error('user_id') is-invalid @enderror">
                                    <option value="">-- اختر حساب المستخدم --</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}" {{ old('user_id', $employee->user_id) == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }} ({{ $user->email }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('user_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="first_name_en">الاسم الأول (بالإنجليزية)</label>
                                <input type="text" name="first_name_en" id="first_name_en" class="form-control @error('first_name_en') is-invalid @enderror" value="{{ old('first_name_en', $employee->first_name_en) }}">
                                @error('first_name_en')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="last_name_en">الاسم الأخير (بالإنجليزية)</label>
                                <input type="text" name="last_name_en" id="last_name_en" class="form-control @error('last_name_en') is-invalid @enderror" value="{{ old('last_name_en', $employee->last_name_en) }}">
                                @error('last_name_en')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="email">البريد الإلكتروني</label>
                                <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $employee->email) }}">
                                @error('email')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="phone">رقم الهاتف</label>
                                <input type="text" name="phone" id="phone" class="form-control @error('phone') is-invalid @enderror" value="{{ old('phone', $employee->phone) }}">
                                @error('phone')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- معلومات الهوية -->
                            <div class="col-md-12 mt-3">
                                <h4 class="mb-3">معلومات الهوية</h4>
                                <hr>
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="national_id">رقم الهوية الوطنية</label>
                                <input type="text" name="national_id" id="national_id" class="form-control @error('national_id') is-invalid @enderror" value="{{ old('national_id', $employee->national_id) }}">
                                @error('national_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="passport_number">رقم جواز السفر</label>
                                <input type="text" name="passport_number" id="passport_number" class="form-control @error('passport_number') is-invalid @enderror" value="{{ old('passport_number', $employee->passport_number) }}">
                                @error('passport_number')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="passport_expiry">تاريخ انتهاء جواز السفر</label>
                                <input type="date" name="passport_expiry" id="passport_expiry" class="form-control @error('passport_expiry') is-invalid @enderror" value="{{ old('passport_expiry', $employee->passport_expiry ? $employee->passport_expiry->format('Y-m-d') : '') }}">
                                @error('passport_expiry')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="nationality">الجنسية</label>
                                <input type="text" name="nationality" id="nationality" class="form-control @error('nationality') is-invalid @enderror" value="{{ old('nationality', $employee->nationality) }}">
                                @error('nationality')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="birth_date">تاريخ الميلاد</label>
                                <input type="date" name="birth_date" id="birth_date" class="form-control @error('birth_date') is-invalid @enderror" value="{{ old('birth_date', $employee->birth_date ? $employee->birth_date->format('Y-m-d') : '') }}">
                                @error('birth_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="gender">الجنس</label>
                                <select name="gender" id="gender" class="form-control @error('gender') is-invalid @enderror">
                                    <option value="">-- اختر الجنس --</option>
                                    <option value="male" {{ old('gender', $employee->gender) == 'male' ? 'selected' : '' }}>ذكر</option>
                                    <option value="female" {{ old('gender', $employee->gender) == 'female' ? 'selected' : '' }}>أنثى</option>
                                    <option value="other" {{ old('gender', $employee->gender) == 'other' ? 'selected' : '' }}>آخر</option>
                                </select>
                                @error('gender')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="marital_status">الحالة الاجتماعية</label>
                                <select name="marital_status" id="marital_status" class="form-control @error('marital_status') is-invalid @enderror">
                                    <option value="">-- اختر الحالة --</option>
                                    <option value="single" {{ old('marital_status', $employee->marital_status) == 'single' ? 'selected' : '' }}>أعزب</option>
                                    <option value="married" {{ old('marital_status', $employee->marital_status) == 'married' ? 'selected' : '' }}>متزوج</option>
                                    <option value="divorced" {{ old('marital_status', $employee->marital_status) == 'divorced' ? 'selected' : '' }}>مطلق</option>
                                    <option value="widowed" {{ old('marital_status', $employee->marital_status) == 'widowed' ? 'selected' : '' }}>أرمل</option>
                                </select>
                                @error('marital_status')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="emergency_contact">رقم الطوارئ</label>
                                <input type="text" name="emergency_contact" id="emergency_contact" class="form-control @error('emergency_contact') is-invalid @enderror" value="{{ old('emergency_contact', $employee->emergency_contact) }}">
                                @error('emergency_contact')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- معلومات العمل -->
                            <div class="col-md-12 mt-3">
                                <h4 class="mb-3">معلومات العمل</h4>
                                <hr>
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="department_id">القسم</label>
                                <select name="department_id" id="department_id" class="form-control @error('department_id') is-invalid @enderror">
                                    <option value="">-- اختر القسم --</option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}" {{ old('department_id', $employee->department_id) == $department->id ? 'selected' : '' }}>
                                            {{ $department->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('department_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="job_title_id">المسمى الوظيفي</label>
                                <select name="job_title_id" id="job_title_id" class="form-control @error('job_title_id') is-invalid @enderror">
                                    <option value="">-- اختر المسمى الوظيفي --</option>
                                    @foreach($jobTitles as $jobTitle)
                                        <option value="{{ $jobTitle->id }}" {{ old('job_title_id', $employee->job_title_id) == $jobTitle->id ? 'selected' : '' }}>
                                            {{ $jobTitle->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('job_title_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="branch_id">الفرع</label>
                                <select name="branch_id" id="branch_id" class="form-control @error('branch_id') is-invalid @enderror">
                                    <option value="">-- اختر الفرع --</option>
                                    @foreach($branches as $branch)
                                        <option value="{{ $branch->id }}" {{ old('branch_id', $employee->branch_id) == $branch->id ? 'selected' : '' }}>
                                            {{ $branch->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('branch_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="join_date">تاريخ التعيين <span class="text-danger">*</span></label>
                                <input type="date" name="join_date" id="join_date" class="form-control @error('join_date') is-invalid @enderror" value="{{ old('join_date', $employee->join_date->format('Y-m-d')) }}" required>
                                @error('join_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="probation_end_date">تاريخ انتهاء فترة التجربة</label>
                                <input type="date" name="probation_end_date" id="probation_end_date" class="form-control @error('probation_end_date') is-invalid @enderror" value="{{ old('probation_end_date', $employee->probation_end_date ? $employee->probation_end_date->format('Y-m-d') : '') }}">
                                @error('probation_end_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="contract_end_date">تاريخ انتهاء العقد</label>
                                <input type="date" name="contract_end_date" id="contract_end_date" class="form-control @error('contract_end_date') is-invalid @enderror" value="{{ old('contract_end_date', $employee->contract_end_date ? $employee->contract_end_date->format('Y-m-d') : '') }}">
                                @error('contract_end_date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="status">الحالة</label>
                                <select name="status" id="status" class="form-control @error('status') is-invalid @enderror">
                                    <option value="active" {{ old('status', $employee->status) == 'active' ? 'selected' : '' }}>نشط</option>
                                    <option value="inactive" {{ old('status', $employee->status) == 'inactive' ? 'selected' : '' }}>غير نشط</option>
                                    <option value="on_leave" {{ old('status', $employee->status) == 'on_leave' ? 'selected' : '' }}>في إجازة</option>
                                    <option value="terminated" {{ old('status', $employee->status) == 'terminated' ? 'selected' : '' }}>منتهي</option>
                                </select>
                                @error('status')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- معلومات الراتب -->
                            <div class="col-md-12 mt-3">
                                <h4 class="mb-3">معلومات الراتب</h4>
                                <hr>
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="basic_salary">الراتب الأساسي</label>
                                <input type="number" step="0.01" name="basic_salary" id="basic_salary" class="form-control @error('basic_salary') is-invalid @enderror" value="{{ old('basic_salary', $employee->basic_salary) }}">
                                @error('basic_salary')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="housing_allowance">بدل السكن</label>
                                <input type="number" step="0.01" name="housing_allowance" id="housing_allowance" class="form-control @error('housing_allowance') is-invalid @enderror" value="{{ old('housing_allowance', $employee->housing_allowance) }}">
                                @error('housing_allowance')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="transportation_allowance">بدل النقل</label>
                                <input type="number" step="0.01" name="transportation_allowance" id="transportation_allowance" class="form-control @error('transportation_allowance') is-invalid @enderror" value="{{ old('transportation_allowance', $employee->transportation_allowance) }}">
                                @error('transportation_allowance')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="other_allowances">بدلات أخرى</label>
                                <input type="number" step="0.01" name="other_allowances" id="other_allowances" class="form-control @error('other_allowances') is-invalid @enderror" value="{{ old('other_allowances', $employee->other_allowances) }}">
                                @error('other_allowances')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- معلومات البنك -->
                            <div class="col-md-12 mt-3">
                                <h4 class="mb-3">معلومات البنك</h4>
                                <hr>
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="bank_name">اسم البنك</label>
                                <input type="text" name="bank_name" id="bank_name" class="form-control @error('bank_name') is-invalid @enderror" value="{{ old('bank_name', $employee->bank_name) }}">
                                @error('bank_name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="bank_account">رقم الحساب</label>
                                <input type="text" name="bank_account" id="bank_account" class="form-control @error('bank_account') is-invalid @enderror" value="{{ old('bank_account', $employee->bank_account) }}">
                                @error('bank_account')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="iban">رقم الآيبان</label>
                                <input type="text" name="iban" id="iban" class="form-control @error('iban') is-invalid @enderror" value="{{ old('iban', $employee->iban) }}">
                                @error('iban')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- معلومات إضافية -->
                            <div class="col-md-12 mt-3">
                                <h4 class="mb-3">معلومات إضافية</h4>
                                <hr>
                            </div>

                            <div class="col-md-6 form-group">
                                <label for="address">العنوان</label>
                                <textarea name="address" id="address" class="form-control @error('address') is-invalid @enderror" rows="3">{{ old('address', $employee->address) }}</textarea>
                                @error('address')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-6 form-group">
                                <label for="notes">ملاحظات</label>
                                <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $employee->notes) }}</textarea>
                                @error('notes')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="education_level">المستوى التعليمي</label>
                                <input type="text" name="education_level" id="education_level" class="form-control @error('education_level') is-invalid @enderror" value="{{ old('education_level', $employee->education_level) }}">
                                @error('education_level')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-3 form-group">
                                <label for="education_field">مجال الدراسة</label>
                                <input type="text" name="education_field" id="education_field" class="form-control @error('education_field') is-invalid @enderror" value="{{ old('education_field', $employee->education_field) }}">
                                @error('education_field')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-6 form-group">
                                <label for="skills">المهارات</label>
                                <input type="text" name="skills" id="skills" class="form-control @error('skills') is-invalid @enderror" value="{{ old('skills', $employee->skills ? implode(',', json_decode($employee->skills)) : '') }}" placeholder="أدخل المهارات مفصولة بفواصل">
                                @error('skills')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">أدخل المهارات مفصولة بفواصل (مثال: Excel, Word, PowerPoint)</small>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        <a href="{{ route('hrm.employees.show', $employee->id) }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function previewImage() {
        var preview = document.getElementById('profile-preview');
        var file = document.getElementById('profile_picture').files[0];
        var reader = new FileReader();

        reader.onloadend = function () {
            preview.src = reader.result;
        }

        if (file) {
            reader.readAsDataURL(file);
        } else {
            preview.src = "{{ $employee->profile_picture ? asset('storage/' . $employee->profile_picture) : asset('images/default-avatar.png') }}";
        }
    }
</script>
@endpush
@endsection