@extends('layouts.modern')

@section('title', 'تفاصيل القسم')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل القسم: {{ $department->name }}</h3>
                    <div>
                        <a href="{{ route('hrm.departments.edit', $department->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('hrm.departments.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 30%">اسم القسم</th>
                                    <td>{{ $department->name }}</td>
                                </tr>
                                <tr>
                                    <th>اسم القسم (بالإنجليزية)</th>
                                    <td>{{ $department->name_en ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <th>كود القسم</th>
                                    <td>{{ $department->code ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <th>القسم الرئيسي</th>
                                    <td>
                                        @if($department->parent)
                                            <a href="{{ route('hrm.departments.show', $department->parent->id) }}">
                                                {{ $department->parent->name }}
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>مدير القسم</th>
                                    <td>
                                        @if($department->manager)
                                            <a href="{{ route('hrm.employees.show', $department->manager->id) }}">
                                                {{ $department->manager->first_name }} {{ $department->manager->last_name }}
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>الحالة</th>
                                    <td>
                                        @if($department->status == 'active')
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-secondary">غير نشط</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>وصف القسم</th>
                                    <td>{{ $department->description ?: '-' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">الأقسام الفرعية</h5>
                                </div>
                                <div class="card-body">
                                    @if($department->children && $department->children->count() > 0)
                                        <ul class="list-group">
                                            @foreach($department->children as $child)
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <a href="{{ route('hrm.departments.show', $child->id) }}">
                                                        {{ $child->name }}
                                                    </a>
                                                    <span class="badge badge-primary badge-pill">
                                                        {{ $child->employees_count ?? $child->employees->count() }} موظف
                                                    </span>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <p class="text-muted">لا توجد أقسام فرعية</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- موظفي القسم -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title">موظفي القسم</h5>
                                    <a href="{{ route('hrm.employees.create', ['department_id' => $department->id]) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-plus"></i> إضافة موظف
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>رقم الموظف</th>
                                                    <th>الاسم</th>
                                                    <th>المسمى الوظيفي</th>
                                                    <th>البريد الإلكتروني</th>
                                                    <th>رقم الهاتف</th>
                                                    <th>تاريخ التعيين</th>
                                                    <th>الحالة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($department->employees as $employee)
                                                    <tr>
                                                        <td>{{ $employee->employee_number }}</td>
                                                        <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
                                                        <td>{{ $employee->jobTitle ? $employee->jobTitle->name : '-' }}</td>
                                                        <td>{{ $employee->email ?: '-' }}</td>
                                                        <td>{{ $employee->phone ?: '-' }}</td>
                                                        <td>{{ $employee->join_date->format('Y-m-d') }}</td>
                                                        <td>
                                                            @if($employee->status == 'active')
                                                                <span class="badge badge-success">نشط</span>
                                                            @elseif($employee->status == 'inactive')
                                                                <span class="badge badge-secondary">غير نشط</span>
                                                            @elseif($employee->status == 'on_leave')
                                                                <span class="badge badge-info">في إجازة</span>
                                                            @elseif($employee->status == 'terminated')
                                                                <span class="badge badge-danger">منتهي</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('hrm.employees.show', $employee->id) }}" class="btn btn-sm btn-info">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="8" class="text-center">لا يوجد موظفين في هذا القسم</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- المسميات الوظيفية في القسم -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">المسميات الوظيفية في القسم</h5>
                                </div>
                                <div class="card-body">
                                    @if($department->jobTitles && $department->jobTitles->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>المسمى الوظيفي</th>
                                                        <th>الوصف</th>
                                                        <th>عدد الموظفين</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($department->jobTitles as $jobTitle)
                                                        <tr>
                                                            <td>{{ $jobTitle->name }}</td>
                                                            <td>{{ $jobTitle->description ?: '-' }}</td>
                                                            <td>{{ $jobTitle->employees->where('department_id', $department->id)->count() }}</td>
                                                            <td>
                                                                <a href="{{ route('hrm.job-titles.show', $jobTitle->id) }}" class="btn btn-sm btn-info">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <p class="text-muted">لا توجد مسميات وظيفية مرتبطة بهذا القسم</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection