<li>
    <div class="department-node {{ $department->status == 'active' ? '' : 'inactive' }}">
        <a href="{{ route('hrm.departments.show', $department->id) }}">{{ $department->name }}</a>
        @if($department->code)
            <span class="badge badge-secondary">{{ $department->code }}</span>
        @endif
        @if($department->manager)
            <span class="badge badge-info" title="المدير">
                <i class="fas fa-user-tie"></i> {{ $department->manager->first_name }} {{ $department->manager->last_name }}
            </span>
        @endif
        <span class="badge badge-primary" title="عدد الموظفين">
            <i class="fas fa-users"></i> {{ $department->employees_count ?? ($department->employees ? $department->employees->count() : 0) }}
        </span>
        @if($department->status == 'inactive')
            <span class="badge badge-secondary">غير نشط</span>
        @endif
    </div>
    @if($department->children && $department->children->count() > 0)
        <div class="department-children">
            <ul>
                @foreach($department->children as $child)
                    @include('hrm.departments.partials.department_tree_item', ['department' => $child])
                @endforeach
            </ul>
        </div>
    @endif
</li>