@extends('layouts.modern')

@section('title', 'إدارة الأقسام')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">قائمة الأقسام</h3>
                    <a href="{{ route('hrm.departments.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة قسم جديد
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الكود</th>
                                    <th>اسم القسم</th>
                                    <th>القسم الرئيسي</th>
                                    <th>المدير</th>
                                    <th>عدد الموظفين</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($departments as $department)
                                    <tr>
                                        <td>{{ $department->code ?: '-' }}</td>
                                        <td>{{ $department->name }}</td>
                                        <td>{{ $department->parent ? $department->parent->name : '-' }}</td>
                                        <td>{{ $department->manager ? $department->manager->first_name . ' ' . $department->manager->last_name : '-' }}</td>
                                        <td>{{ $department->employees_count ?? ($department->employees ? $department->employees->count() : 0) }}</td>
                                        <td>
                                            @if($department->status == 'active')
                                                <span class="badge badge-success">نشط</span>
                                            @else
                                                <span class="badge badge-secondary">غير نشط</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('hrm.departments.show', $department->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.departments.edit', $department->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $department->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deleteModal{{ $department->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $department->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $department->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف القسم <strong>{{ $department->name }}</strong>؟
                                                            <p class="text-danger mt-2">
                                                                <strong>تنبيه:</strong> لا يمكن حذف القسم إذا كان يحتوي على أقسام فرعية أو موظفين.
                                                            </p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('hrm.departments.destroy', $department->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا توجد أقسام</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Department Hierarchy -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">الهيكل التنظيمي للأقسام</h3>
                </div>
                <div class="card-body">
                    <div id="department-tree">
                        <ul>
                            @foreach($departments->whereNull('parent_id') as $department)
                                @include('hrm.departments.partials.department_tree_item', ['department' => $department])
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    #department-tree ul {
        list-style-type: none;
        padding-right: 20px;
    }
    #department-tree > ul {
        padding-right: 0;
    }
    #department-tree li {
        margin: 10px 0;
    }
    .department-node {
        padding: 8px 15px;
        border-radius: 5px;
        background-color: #f8f9fa;
        border-right: 3px solid #007bff;
        display: inline-block;
    }
    .department-node.inactive {
        border-right-color: #6c757d;
        opacity: 0.7;
    }
    .department-node .badge {
        margin-right: 5px;
    }
    .department-children {
        margin-right: 20px;
        border-right: 1px dashed #ccc;
        padding-right: 15px;
    }
</style>
@endpush
@endsection