@extends('layouts.modern')

@section('title', 'تفاصيل الشهادة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تفاصيل الشهادة: {{ $certificate->title }}</h3>
                    <div>
                        <a href="{{ route('hrm.certificates.edit', $certificate->id) }}" class="btn btn-primary me-2">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @if($certificate->file_path)
                            <a href="{{ route('hrm.certificates.download', $certificate->id) }}" class="btn btn-success me-2">
                                <i class="fas fa-download"></i> تنزيل الشهادة
                            </a>
                        @endif
                        <a href="{{ route('hrm.certificates.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">معلومات الشهادة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">العنوان</th>
                                            <td>{{ $certificate->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>الموظف</th>
                                            <td>{{ $certificate->employee->full_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>نوع الشهادة</th>
                                            <td>{{ $certificate->certificate_type }}</td>
                                        </tr>
                                        <tr>
                                            <th>الجهة المانحة</th>
                                            <td>{{ $certificate->issuing_organization }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الشهادة</th>
                                            <td>{{ $certificate->certificate_number ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإصدار</th>
                                            <td>{{ $certificate->issue_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>
                                                @if($certificate->expiry_date)
                                                    @if($certificate->is_expired)
                                                        <span class="text-danger fw-bold">{{ $certificate->expiry_date->format('Y-m-d') }} (منتهية)</span>
                                                    @elseif($certificate->days_until_expiry <= 30 && $certificate->days_until_expiry > 0)
                                                        <span class="text-warning fw-bold">{{ $certificate->expiry_date->format('Y-m-d') }} (تنتهي خلال {{ $certificate->days_until_expiry }} يوم)</span>
                                                    @else
                                                        {{ $certificate->expiry_date->format('Y-m-d') }}
                                                    @endif
                                                @else
                                                    غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($certificate->status == 'active')
                                                    @if($certificate->is_expired)
                                                        <span class="badge bg-danger">منتهية</span>
                                                    @else
                                                        <span class="badge bg-success">سارية</span>
                                                    @endif
                                                @elseif($certificate->status == 'expired')
                                                    <span class="badge bg-danger">منتهية</span>
                                                @elseif($certificate->status == 'revoked')
                                                    <span class="badge bg-secondary">ملغاة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        @if($certificate->verification_link)
                                        <tr>
                                            <th>رابط التحقق</th>
                                            <td>
                                                <a href="{{ $certificate->verification_link }}" target="_blank">{{ $certificate->verification_link }}</a>
                                            </td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>

                            @if($certificate->description)
                            <div class="card mb-4">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">وصف الشهادة</h5>
                                </div>
                                <div class="card-body">
                                    <p>{!! nl2br(e($certificate->description)) !!}</p>
                                </div>
                            </div>
                            @endif

                            @if($certificate->notes)
                            <div class="card mb-4">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    <p>{!! nl2br(e($certificate->notes)) !!}</p>
                                </div>
                            </div>
                            @endif
                        </div>

                        <div class="col-md-6">
                            @if($certificate->file_path)
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">ملف الشهادة</h5>
                                </div>
                                <div class="card-body text-center">
                                    @php
                                        $extension = pathinfo(storage_path('app/public/' . $certificate->file_path), PATHINFO_EXTENSION);
                                    @endphp

                                    @if(in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']))
                                        <img src="{{ asset('storage/' . $certificate->file_path) }}" alt="صورة الشهادة" class="img-fluid mb-3" style="max-height: 400px;">
                                    @else
                                        <div class="mb-3">
                                            <i class="fas fa-file-pdf fa-5x text-danger"></i>
                                            <p class="mt-2">{{ basename($certificate->file_path) }}</p>
                                        </div>
                                    @endif

                                    <a href="{{ route('hrm.certificates.download', $certificate->id) }}" class="btn btn-success">
                                        <i class="fas fa-download"></i> تنزيل الشهادة
                                    </a>
                                </div>
                            </div>
                            @endif

                            <div class="card mb-4">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">معلومات إضافية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">تاريخ الإنشاء</th>
                                            <td>{{ $certificate->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $certificate->creator->name ?? 'غير معروف' }}</td>
                                        </tr>
                                        @if($certificate->updated_at && $certificate->updated_at->ne($certificate->created_at))
                                        <tr>
                                            <th>تاريخ آخر تحديث</th>
                                            <td>{{ $certificate->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم التحديث بواسطة</th>
                                            <td>{{ $certificate->updater->name ?? 'غير معروف' }}</td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection