@extends('layouts.modern')

@section('title', 'إدارة الشهادات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">إدارة الشهادات</h3>
                    <div>
                        <a href="{{ route('hrm.certificates.expiring') }}" class="btn btn-warning me-2">
                            <i class="fas fa-exclamation-triangle"></i> الشهادات المنتهية أو قاربت على الانتهاء
                        </a>
                        <a href="{{ route('hrm.certificates.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة شهادة جديدة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="mb-4">
                        <form action="{{ route('hrm.certificates.index') }}" method="GET" class="row g-3">
                            <div class="col-md-3">
                                <input type="text" name="search" class="form-control" placeholder="بحث..." value="{{ request('search') }}">
                            </div>
                            <div class="col-md-2">
                                <select name="status" class="form-select">
                                    <option value="">-- الحالة --</option>
                                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>سارية</option>
                                    <option value="expired" {{ request('status') == 'expired' ? 'selected' : '' }}>منتهية</option>
                                    <option value="revoked" {{ request('status') == 'revoked' ? 'selected' : '' }}>ملغاة</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="employee_id" class="form-select">
                                    <option value="">-- الموظف --</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="certificate_type" class="form-select">
                                    <option value="">-- نوع الشهادة --</option>
                                    @foreach($certificateTypes as $type)
                                        <option value="{{ $type }}" {{ request('certificate_type') == $type ? 'selected' : '' }}>
                                            {{ $type }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                <a href="{{ route('hrm.certificates.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> إعادة تعيين
                                </a>
                            </div>
                        </form>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الموظف</th>
                                    <th>نوع الشهادة</th>
                                    <th>الجهة المانحة</th>
                                    <th>تاريخ الإصدار</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($certificates as $certificate)
                                    <tr>
                                        <td>{{ $loop->iteration + ($certificates->currentPage() - 1) * $certificates->perPage() }}</td>
                                        <td>{{ $certificate->title }}</td>
                                        <td>{{ $certificate->employee->full_name }}</td>
                                        <td>{{ $certificate->certificate_type }}</td>
                                        <td>{{ $certificate->issuing_organization }}</td>
                                        <td>{{ $certificate->issue_date->format('Y-m-d') }}</td>
                                        <td>{{ $certificate->expiry_date ? $certificate->expiry_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        <td>
                                            @if($certificate->status == 'active')
                                                @if($certificate->is_expired)
                                                    <span class="badge bg-danger">منتهية</span>
                                                @elseif($certificate->days_until_expiry <= 30 && $certificate->days_until_expiry > 0)
                                                    <span class="badge bg-warning">تنتهي قريباً ({{ $certificate->days_until_expiry }} يوم)</span>
                                                @else
                                                    <span class="badge bg-success">سارية</span>
                                                @endif
                                            @elseif($certificate->status == 'expired')
                                                <span class="badge bg-danger">منتهية</span>
                                            @elseif($certificate->status == 'revoked')
                                                <span class="badge bg-secondary">ملغاة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.certificates.show', $certificate->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($certificate->file_path)
                                                    <a href="{{ route('hrm.certificates.download', $certificate->id) }}" class="btn btn-sm btn-success">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                @endif
                                                <a href="{{ route('hrm.certificates.edit', $certificate->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $certificate->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Modal for Delete Confirmation -->
                                            <div class="modal fade" id="deleteModal{{ $certificate->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $certificate->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $certificate->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف الشهادة "{{ $certificate->title }}"؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('hrm.certificates.destroy', $certificate->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد شهادات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $certificates->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection