@extends('layouts.modern')

@section('title', 'الشهادات المنتهية أو قاربت على الانتهاء')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">الشهادات المنتهية أو قاربت على الانتهاء</h3>
                    <a href="{{ route('hrm.certificates.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- الشهادات التي ستنتهي قريباً -->
                    <h4 class="mb-3">الشهادات التي ستنتهي خلال 30 يوم</h4>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> هذه الشهادات ستنتهي قريباً، يرجى اتخاذ الإجراءات اللازمة لتجديدها.
                    </div>

                    <div class="table-responsive mb-5">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الموظف</th>
                                    <th>نوع الشهادة</th>
                                    <th>الجهة المانحة</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>المدة المتبقية</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($expiringCertificates as $certificate)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $certificate->title }}</td>
                                        <td>{{ $certificate->employee->full_name }}</td>
                                        <td>{{ $certificate->certificate_type }}</td>
                                        <td>{{ $certificate->issuing_organization }}</td>
                                        <td class="text-warning fw-bold">{{ $certificate->expiry_date->format('Y-m-d') }}</td>
                                        <td class="text-warning fw-bold">{{ $certificate->days_until_expiry }} يوم</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.certificates.show', $certificate->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.certificates.edit', $certificate->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @if($certificate->file_path)
                                                    <a href="{{ route('hrm.certificates.download', $certificate->id) }}" class="btn btn-sm btn-success">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد شهادات ستنتهي قريباً</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- الشهادات المنتهية -->
                    <h4 class="mb-3">الشهادات المنتهية</h4>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i> هذه الشهادات منتهية، يرجى تجديدها أو تحديث حالتها.
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الموظف</th>
                                    <th>نوع الشهادة</th>
                                    <th>الجهة المانحة</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>مدة الانتهاء</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($expiredCertificates as $certificate)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $certificate->title }}</td>
                                        <td>{{ $certificate->employee->full_name }}</td>
                                        <td>{{ $certificate->certificate_type }}</td>
                                        <td>{{ $certificate->issuing_organization }}</td>
                                        <td class="text-danger fw-bold">{{ $certificate->expiry_date->format('Y-m-d') }}</td>
                                        <td class="text-danger fw-bold">{{ $certificate->expiry_date->diffForHumans() }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.certificates.show', $certificate->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.certificates.edit', $certificate->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @if($certificate->file_path)
                                                    <a href="{{ route('hrm.certificates.download', $certificate->id) }}" class="btn btn-sm btn-success">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد شهادات منتهية</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection