@extends('layouts.modern')

@section('title', 'إضافة شهادة جديدة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">إضافة شهادة جديدة</h3>
                    <a href="{{ route('hrm.certificates.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('hrm.certificates.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="employee_id" class="form-label">الموظف <span class="text-danger">*</span></label>
                                    <select class="form-select" id="employee_id" name="employee_id" required>
                                        <option value="">-- اختر الموظف --</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->full_name }} ({{ $employee->employee_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="title" class="form-label">عنوان الشهادة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="certificate_type" class="form-label">نوع الشهادة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="certificate_type" name="certificate_type" value="{{ old('certificate_type') }}" required>
                                    <small class="form-text text-muted">مثال: شهادة فنية، شهادة مهنية، شهادة أكاديمية، إلخ.</small>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="issuing_organization" class="form-label">الجهة المانحة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="issuing_organization" name="issuing_organization" value="{{ old('issuing_organization') }}" required>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="certificate_number" class="form-label">رقم الشهادة</label>
                                    <input type="text" class="form-control" id="certificate_number" name="certificate_number" value="{{ old('certificate_number') }}">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="issue_date" class="form-label">تاريخ الإصدار <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="issue_date" name="issue_date" value="{{ old('issue_date') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="expiry_date" class="form-label">تاريخ الانتهاء</label>
                                            <input type="date" class="form-control" id="expiry_date" name="expiry_date" value="{{ old('expiry_date') }}">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="verification_link" class="form-label">رابط التحقق</label>
                                    <input type="url" class="form-control" id="verification_link" name="verification_link" value="{{ old('verification_link') }}">
                                    <small class="form-text text-muted">رابط للتحقق من صحة الشهادة (إن وجد)</small>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>سارية</option>
                                        <option value="expired" {{ old('status') == 'expired' ? 'selected' : '' }}>منتهية</option>
                                        <option value="revoked" {{ old('status') == 'revoked' ? 'selected' : '' }}>ملغاة</option>
                                    </select>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="certificate_file" class="form-label">ملف الشهادة</label>
                                    <input type="file" class="form-control" id="certificate_file" name="certificate_file">
                                    <small class="form-text text-muted">الملفات المسموحة: PDF, JPG, JPEG, PNG (الحد الأقصى: 5 ميجابايت)</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="description" class="form-label">وصف الشهادة</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control" id="notes" name="notes" rows="2">{{ old('notes') }}</textarea>
                        </div>
                        
                        <div class="form-group text-center">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                            <a href="{{ route('hrm.certificates.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تحقق من تاريخ الإصدار والانتهاء
        $('#expiry_date').change(function() {
            var issueDate = new Date($('#issue_date').val());
            var expiryDate = new Date($(this).val());
            
            if (expiryDate < issueDate) {
                alert('تاريخ الانتهاء يجب أن يكون بعد تاريخ الإصدار');
                $(this).val('');
            }
        });
        
        $('#issue_date').change(function() {
            var expiryDateField = $('#expiry_date');
            if (expiryDateField.val()) {
                var issueDate = new Date($(this).val());
                var expiryDate = new Date(expiryDateField.val());
                
                if (expiryDate < issueDate) {
                    alert('تاريخ الانتهاء يجب أن يكون بعد تاريخ الإصدار');
                    expiryDateField.val('');
                }
            }
        });
    });
</script>
@endsection