@extends('layouts.modern')

@section('title', 'تفاصيل المكافأة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل المكافأة #{{ $bonus->id }}</h5>
                    <div>
                        <a href="{{ route('hrm.bonuses.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        
                        @if($bonus->status == 'pending')
                            <a href="{{ route('hrm.bonuses.edit', $bonus) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                        @endif
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات المكافأة</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">رقم المكافأة:</dt>
                                    <dd class="col-sm-8">{{ $bonus->id }}</dd>
                                    
                                    <dt class="col-sm-4">نوع المكافأة:</dt>
                                    <dd class="col-sm-8">{{ $bonus->bonus_type_name }}</dd>
                                    
                                    <dt class="col-sm-4">المبلغ:</dt>
                                    <dd class="col-sm-8">{{ number_format($bonus->amount, 2) }} ريال</dd>
                                    
                                    <dt class="col-sm-4">التاريخ:</dt>
                                    <dd class="col-sm-8">{{ $bonus->date->format('Y-m-d') }}</dd>
                                    
                                    <dt class="col-sm-4">الوصف:</dt>
                                    <dd class="col-sm-8">{{ $bonus->description }}</dd>
                                    
                                    <dt class="col-sm-4">الحالة:</dt>
                                    <dd class="col-sm-8">
                                        @if($bonus->status == 'pending')
                                            <span class="badge bg-warning text-dark">{{ $bonus->status_name }}</span>
                                        @elseif($bonus->status == 'approved')
                                            <span class="badge bg-success">{{ $bonus->status_name }}</span>
                                        @elseif($bonus->status == 'rejected')
                                            <span class="badge bg-danger">{{ $bonus->status_name }}</span>
                                        @elseif($bonus->status == 'paid')
                                            <span class="badge bg-info">{{ $bonus->status_name }}</span>
                                        @endif
                                    </dd>
                                    
                                    @if($bonus->notes)
                                        <dt class="col-sm-4">ملاحظات:</dt>
                                        <dd class="col-sm-8">{{ $bonus->notes }}</dd>
                                    @endif
                                </dl>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات الموظف</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">اسم الموظف:</dt>
                                    <dd class="col-sm-8">
                                        <a href="{{ route('hrm.employees.show', $bonus->employee_id) }}">
                                            {{ $bonus->employee->full_name }}
                                        </a>
                                    </dd>
                                    
                                    <dt class="col-sm-4">الرقم الوظيفي:</dt>
                                    <dd class="col-sm-8">{{ $bonus->employee->employee_number }}</dd>
                                    
                                    <dt class="col-sm-4">القسم:</dt>
                                    <dd class="col-sm-8">{{ $bonus->employee->department->name ?? 'غير محدد' }}</dd>
                                    
                                    <dt class="col-sm-4">المسمى الوظيفي:</dt>
                                    <dd class="col-sm-8">{{ $bonus->employee->jobTitle->name ?? 'غير محدد' }}</dd>
                                </dl>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="fw-bold">معلومات إضافية</h6>
                                <hr>
                                <dl class="row">
                                    <dt class="col-sm-4">تاريخ الإنشاء:</dt>
                                    <dd class="col-sm-8">{{ $bonus->created_at->format('Y-m-d H:i') }}</dd>
                                    
                                    <dt class="col-sm-4">بواسطة:</dt>
                                    <dd class="col-sm-8">{{ $bonus->creator->name ?? 'غير محدد' }}</dd>
                                    
                                    @if($bonus->approved_by)
                                        <dt class="col-sm-4">تمت الموافقة بواسطة:</dt>
                                        <dd class="col-sm-8">{{ $bonus->approver->name ?? 'غير محدد' }}</dd>
                                        
                                        <dt class="col-sm-4">تاريخ الموافقة:</dt>
                                        <dd class="col-sm-8">{{ $bonus->approved_at ? $bonus->approved_at->format('Y-m-d H:i') : 'غير محدد' }}</dd>
                                    @endif
                                </dl>
                            </div>
                        </div>
                    </div>
                    
                    <!-- أزرار الإجراءات -->
                    <div class="mt-4 border-top pt-4">
                        <div class="d-flex justify-content-between">
                            <div>
                                @if($bonus->status == 'pending')
                                    <form action="{{ route('hrm.bonuses.destroy', $bonus) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه المكافأة؟')">
                                            <i class="fas fa-trash"></i> حذف المكافأة
                                        </button>
                                    </form>
                                @endif
                            </div>
                            
                            <div>
                                @if($bonus->status == 'pending')
                                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                        <i class="fas fa-times"></i> رفض
                                    </button>
                                    
                                    <form action="{{ route('hrm.bonuses.approve', $bonus) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-success" onclick="return confirm('هل أنت متأكد من الموافقة على هذه المكافأة؟')">
                                            <i class="fas fa-check"></i> موافقة
                                        </button>
                                    </form>
                                @elseif($bonus->status == 'approved')
                                    <form action="{{ route('hrm.bonuses.mark-as-paid', $bonus) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-info" onclick="return confirm('هل تم دفع هذه المكافأة؟')">
                                            <i class="fas fa-money-bill"></i> تحديد كمدفوعة
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal رفض المكافأة -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('hrm.bonuses.reject', $bonus) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">رفض المكافأة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="rejection_reason" class="form-label">سبب الرفض <span class="text-danger">*</span></label>
                        <textarea name="rejection_reason" id="rejection_reason" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الرفض</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection