@extends('layouts.modern')

@section('title', 'إدارة المكافآت')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إدارة المكافآت</h5>
                    <a href="{{ route('hrm.bonuses.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> إضافة مكافأة جديدة
                    </a>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0">فلترة النتائج</h6>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('hrm.bonuses.index') }}" method="GET" class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="employee_id">الموظف</label>
                                    <select name="employee_id" id="employee_id" class="form-control select2">
                                        <option value="">جميع الموظفين</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->full_name }} ({{ $employee->employee_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="bonus_type">نوع المكافأة</label>
                                    <select name="bonus_type" id="bonus_type" class="form-control">
                                        <option value="">جميع الأنواع</option>
                                        @foreach($bonusTypes as $key => $value)
                                            <option value="{{ $key }}" {{ request('bonus_type') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">جميع الحالات</option>
                                        @foreach($statuses as $key => $value)
                                            <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="date_from">من تاريخ</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="date_to">إلى تاريخ</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                                <div class="col-md-1 mb-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- جدول المكافآت -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>نوع المكافأة</th>
                                    <th>المبلغ</th>
                                    <th>التاريخ</th>
                                    <th>الوصف</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($bonuses as $bonus)
                                    <tr>
                                        <td>{{ $bonus->id }}</td>
                                        <td>
                                            <a href="{{ route('hrm.employees.show', $bonus->employee_id) }}">
                                                {{ $bonus->employee->full_name }}
                                            </a>
                                            <div class="small text-muted">{{ $bonus->employee->employee_number }}</div>
                                        </td>
                                        <td>{{ $bonus->bonus_type_name }}</td>
                                        <td>{{ number_format($bonus->amount, 2) }}</td>
                                        <td>{{ $bonus->date->format('Y-m-d') }}</td>
                                        <td>{{ Str::limit($bonus->description, 30) }}</td>
                                        <td>
                                            @if($bonus->status == 'pending')
                                                <span class="badge bg-warning text-dark">{{ $bonus->status_name }}</span>
                                            @elseif($bonus->status == 'approved')
                                                <span class="badge bg-success">{{ $bonus->status_name }}</span>
                                            @elseif($bonus->status == 'rejected')
                                                <span class="badge bg-danger">{{ $bonus->status_name }}</span>
                                            @elseif($bonus->status == 'paid')
                                                <span class="badge bg-info">{{ $bonus->status_name }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.bonuses.show', $bonus) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                
                                                @if($bonus->status == 'pending')
                                                    <a href="{{ route('hrm.bonuses.edit', $bonus) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    
                                                    <form action="{{ route('hrm.bonuses.destroy', $bonus) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه المكافأة؟')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد مكافآت</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- ترقيم الصفحات -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $bonuses->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });
    });
</script>
@endpush